function [oa,ob,oc,od,oe] = rulebase(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,w,v,x,y,z)
%RULEBASE: To ease membership function definition for a production 
%	   rules with maximum 4 inputs and one output, this function 
%	   can be utilized. 
% 
% 		[A,B]=RULEBASE(N,U,a,b,c,M,V,ahat,bhat,chat)
%
%	   The inputs are U and V as universe of antecedent and consequent
%	   respectively. The function of membership function for input and
%	   output must be clarified with N and M respectively. For N=1 (M)
%	   exponential Gaussian function, N=2 (M=2) Gaussian function,
%	   N=3(M=3) a trapezoidal function and N=4(M=4) sigmoid function
%	   will be assigned to each fuzzy value.
%
%	   The parameters related to any types of membership functions 
%	   are vectors of a,b,c,ahat,bhat, and chat. The length of these
%	   vectors defines number of rules in rule-base. 
% 	
%           [A1,...,A4,B]=RULEBASE(N1,U1,a1,b1,c1,...,N4,U4,a4,b4,c4,
%							M,V,ahat,bhat,chat)
%
%	             See also FZFIR, BELL_1, BELL_2, TRAPEZE, and SIGMOID.


% FISMAT: Fuzzy Inference Systems toolbox for MATLAB
% (c) A. Lotfi, University of Queensland (Email: lotfia@s1.elec.uq.oz.au)
% 13-10-93
% The program has been tested on MATLAB version 4.1, Sun workstation.

[mc,nc]=size(c(:));

if nargin == 10,
                for i_con = 1:mc
                oa(i_con,:)=fzfir(a,b,c(i_con),d(i_con),e(i_con));
		ob(i_con,:)=fzfir(f,g,h(i_con),i(i_con),j(i_con));
                end
elseif nargin == 15,
		for i_con = 1:mc
                oa(i_con,:)=fzfir(a,b,c(i_con),d(i_con),e(i_con));
                ob(i_con,:)=fzfir(f,g,h(i_con),i(i_con),j(i_con));
		oc(i_con,:)=fzfir(k,l,m(i_con),n(i_con),o(i_con));
                end
elseif nargin == 20,
		for i_con = 1:mc
                oa(i_con,:)=fzfir(a,b,c(i_con),d(i_con),e(i_con));
                ob(i_con,:)=fzfir(f,g,h(i_con),i(i_con),j(i_con));
                oc(i_con,:)=fzfir(k,l,m(i_con),n(i_con),o(i_con));
		od(i_con,:)=fzfir(p,q,r(i_con),s(i_con),t(i_con));
                end

elseif nargin == 25,
                for i_con = 1:mc
                oa(i_con,:)=fzfir(a,b,c(i_con),d(i_con),e(i_con));
                ob(i_con,:)=fzfir(f,g,h(i_con),i(i_con),j(i_con));
                oc(i_con,:)=fzfir(k,l,m(i_con),n(i_con),o(i_con));
                od(i_con,:)=fzfir(p,q,r(i_con),s(i_con),t(i_con));
		oe(i_con,:)=fzfir(w,v,x(i_con),y(i_con),z(i_con));
                end
else
	error('The inputs arguments of RULEBASE is not correct.')
end
