echo on;clc;
% MF_PANEL: Manual tuning of different types of membership function and 
%           considering the effects of quantifiers are presented in this 
%           program. Select desired membership style and change its 
%           parameters. After closing the window, parameters a,b,c along 
%           X as universe and Y as grade of membership are available in 
%           working space.
echo off 


% FISMAT: Fuzzy Inference Systems toolbox for MATLAB
% (c) A. Lotfi, University of Queensland (Email: lotfia@s1.elec.uq.oz.au)
% 13-10-93
% The program has been tested on MATLAB version 4.1, Sun workstation.
clg;

set(gcf,'units','normal','position',[.34 .55 .65 .40]);

axes('units','normal','position',[.2 .10 .6 .82]);
axis([-10 10 0 1]);
x=(-10:.1:10);
a=1;b=1;c=0;
y=bell_1(x,a,b,c);
plot_mf=plot(x,y);
title(['a = ' num2str(a) ', b = ' num2str(b) ', c = ' num2str(c)])
drawnow

vmn_none=['set(mod_idel,''value'',1),',...
	'set(mod_very,''value'',0),',...
	'set(mod_ml,''value'',0),',...
	'set(mod_not,''value'',0),'];


m_pos_x=.01; m_pos_y=.60;
%Create frame for Mebership menu
mem_frame=uicontrol(gcf,'style','frame','units','normal',...
	'position',[m_pos_x-.005 m_pos_y-.005 .15 .33]);

%text lables the radio menu
mem_txt=uicontrol(gcf,...
	'style','text','units','normal',...
	'position',[m_pos_x m_pos_y+.26 .14 .065],...
	'string','Membership');
%Radio buttons that control setting
mem_bell1  = uicontrol(gcf,...
	'style','radio','units','normal',...
	'string','Bell_1',...
	'position',[m_pos_x m_pos_y+.195 .14 .065],...
	'value',1,...
	'hor','left',...
	'callback',[...
	'if get(mem_bell1,''value'') == 1 ,',...
	'set(mem_bell2,''value'' ,0),',...
	'set(mem_trapeze,''value'',0),',...
	'set(mem_sigmoid,''value'',0),',...
	'y=bell_1(x,a,b,c);',...
	'set(plot_mf,''ydata'',y);',....
	'end,',...
	vmn_none]);

mem_bell2=uicontrol(gcf,...
	'style','radio','units','normal',...
	'string','Bell_2',...
	'position',[m_pos_x m_pos_y+.13 .14 .065],...
	'hor','left',...
	'callback',[...
	'if get(mem_bell2,''value'') == 1,',...
	'set(mem_bell1,''value'',0),',...
	'set(mem_trapeze,''value'',0),',...
	'set(mem_sigmoid,''value'',0),',...
	'y=bell_2(x,a,b,c);',...
	'set(plot_mf,''ydata'',y);',....
	'end,',...
	vmn_none]);

mem_trapeze  = uicontrol(gcf,...
	'style','radio','units','normal',...
	'string','Trapezoidal',...
	'position',[m_pos_x m_pos_y+.065 .14 .065],...
	'hor','left',...
	'callback',[...
	'if get(mem_trapeze,''value'') == 1 ,',...
	'set(mem_bell1,''value'',0),',...
	'set(mem_bell2,''value'',0),',...
	'set(mem_sigmoid,''value'',0),',...
	'y=trapeze(x,a,b,c);',...
	'set(plot_mf,''ydata'',y);',....
	'end,',...
	vmn_none]);

mem_sigmoid=uicontrol(gcf,...
	'style','radio','units','normal',...
	'string','Sigmoid',...
	'position',[m_pos_x m_pos_y .14 .065],...
	'hor','left',...
	'callback',[...
	'if get(mem_sigmoid,''value'') == 1,',...
	'set(mem_bell1,''value'',0),',...
	'set(mem_bell2,''value'',0),',...
	'set(mem_trapeze,''value'',0),',...
	'y=sigmoid(x,a,c);',...
	'set(plot_mf,''ydata'',y);',....
	vmn_none,....
	'end']);


o_pos_x=.01; o_pos_y=.10;
%Create the frame
mod_frame=uicontrol(gcf,'style','frame','units','normal',...
'position',[o_pos_x-.005 o_pos_y-.005 .15 .35]);

%text lables the radio menu
mod_txt=uicontrol(gcf,...
	'style','text','units','normal',...
	'position',[o_pos_x o_pos_y+.28 .14 .065 ],...
	'string','Quantifier');

mod_back=['set(plot_mf,''ydata'',modify_y),',...
	'title([''a = '' num2str(a) '', b = '' num2str(b) '', c = '' num2str(c)])'];

%Radio buttons that control setting
mod_idel = uicontrol(gcf,...
	'style','radio','units','normal',...
	'hor','left',...
	'string','None ...',...
	'position',[o_pos_x o_pos_y .14 .065],...
	'value',1,...
	'callback',[...
	'if get(mod_idel,''value'') == 1 ,',...
	'set(mod_very,''value'' ,0);',...
	'set(mod_not,''value'',0);',...
	'set(mod_ml,''value'',0);',...
	'modify_y=y;',...
	mod_back,...
	',end']);
mod_very  = uicontrol(gcf,...
	'style','radio','units','normal',...
	'string','Very',...
	'position',[o_pos_x o_pos_y+.215 .14 .065],...
	'hor','left',...
	'callback',[...
	'if get(mod_very,''value'') == 1 ,',...
	'set(mod_ml,''value'' ,0),',...
	'set(mod_not,''value'',0),',...
	'set(mod_idel,''value'',0),',...
	'modify_y=very(y);',....
	mod_back,...
	',end']);
mod_ml = uicontrol(gcf,...
	'style','radio','units','normal',...
	'string','More or Less',...
	'position',[o_pos_x o_pos_y+.15 .14 .065],...
	'hor','left',...
	'callback',[...
	'if get(mod_ml,''value'') == 1 ,',...
	'set(mod_very,''value'' ,0),',...
	'set(mod_not,''value'',0),',...
	'set(mod_idel,''value'',0),',...
	'modify_y=moreless(y);',....
	mod_back,...
	',end']);
mod_not = uicontrol(gcf,...
	'style','radio','units','normal',...
	'string','Not',...
	'position',[o_pos_x o_pos_y+.085 .14 .065],...
	'hor','left',...
	'callback',[...
	'if get(mod_not,''value'') == 1 ,',...
	'set(mod_very,''value'' ,0),',...
	'set(mod_ml,''value'',0),',...
	'set(mod_idel,''value'',0),',...
	'modify_y=not(y);',....
	mod_back,...
	',end']);

v_pos_x=.82; v_pos_yc=.40; v_pos_yb=.60; v_pos_ya=.80;

% create frame for sliders
frame_vol_a = uicontrol(gcf,'style','frame','units','normal',...
	'position',[v_pos_x-.005 v_pos_ya-.005 .17 .13]);

frame_vol_b = uicontrol(gcf,'style','frame','units','normal',...
	'position',[v_pos_x-.005 v_pos_yb-.005 .17 .13]);

frame_vol_c = uicontrol(gcf,'style','frame','units','normal',...
	'position',[v_pos_x-.005 v_pos_yc-.005 .17 .13]);

sli_back=['a=get(sli_vol_a,''value'');',...
	'b=get(sli_vol_b,''value'');',...
	'c=get(sli_vol_c,''value'');',...
	'title([''a = '' num2str(a) '', b = '' num2str(b) '', c = '' num2str(c)]);',...
	'if get(mem_bell1,''value'') == 1,',...
	'y=bell_1(x,a,b,c);','set(plot_mf,''ydata'',y);',...
	'elseif get(mem_bell2,''value'') == 1,',...
	'y=bell_2(x,a,b,c);','set(plot_mf,''ydata'',y);',...
	'elseif get(mem_trapeze,''value'') == 1,',...
	'y=trapeze(x,a,b,c);','set(plot_mf,''ydata'',y);',...
	'elseif get(mem_sigmoid,''value'') == 1,',...
	'y=sigmoid(x,a,c);','set(plot_mf,''ydata'',y);',...
	'end,',...
	vmn_none];

% text that labels the sliderme
txt_vol_a = uicontrol(gcf,'style','text','units','normal',...
	'string','Min . . .  a . . .  Max',...
	'position',[v_pos_x v_pos_ya .16 .06]);
%control slider
sli_vol_a=uicontrol(gcf,...
	'style','slider','units','normal',...
	'position',[v_pos_x v_pos_ya+.06 .16 .06],...
	'value',1,'max',10,'min',.1,...
	'callback',sli_back);

%text that labels the sliders range
txt_vol_b = uicontrol(gcf,'style','text','units','normal',...
	'string','Min . . .  b . . .  Max',...
	'position',[v_pos_x v_pos_yb .16 .06]);
%control slider
sli_vol_b=uicontrol(gcf,...
	'style','slider','units','normal',...
	'position',[v_pos_x v_pos_yb+.06 .16 .06],...
	'value',1,'max',10,'min',.1,...
	'callback',sli_back);

%text that labels the sliders range
txt_vol_c = uicontrol(gcf,'style','text','units','normal',...
	'string','Min . . .  c . . .  Max',...
	'position',[v_pos_x v_pos_yc .16 .06]);
%control slider
sli_vol_c=uicontrol(gcf,...
	'style','slider','units','normal',...
	'position',[v_pos_x v_pos_yc+.06 .16 .06],...
	'value',0,'max',10,'min',-10,...
	'callback',sli_back);


cl_close_fr = uicontrol(gcf,'style','frame','units','normal',...
	'position',[v_pos_x-.005  .10 .17 .075]);
% closing window push button
cl_close = uicontrol(gcf,...
	'style','push','units','normal',...
	'string','Close Window','fore','r',...
	'position',[v_pos_x .105 .16 .065],...
	'callback',['close(gcf),',...
	'clear m_pos_x m_pos_y o_pos_x o_pos_y v_pos_x v_pos_ya v_pos_yb v_pos_yc ',...
	'vmn_none mem_frame mem_txt mem_bell1 mem_bell2 mem_trapeze mem_sigmoid ',...
	'mod_txt mod_back mod_idel mod_very mod_ml mod_not frame_vol_a frame_vol_b ',...
	'frame_vol_c sli_back txt_vol_a txt_vol_b txt_vol_c sli_vol_a sli_vol_b ',...
	'sli_vol_c cl_close_fr cl_close plot_mf mod_frame']);

