function [I]=integral(A,u)
%INTEGRAL: This function returns the integral of matrix of fuzzy value B over 
%	   universe V. The integral I is a vector the same number on membership
%	   functions in B (the same number of row).
%
%				    [I]=INTEGRAL(B,V)
%
%						See also KOSKO, and CENTRE.

% FISMAT: Fuzzy Inference Systems toolbox for MATLAB
% (c) A. Lotfi, University of Queensland (Email: lotfia@s1.elec.uq.oz.au)
% 13-10-93
% The program has been tested on MATLAB version 4.1, Sun workstation.

diffu=diff(u);
	[mA,nA]=size(A);
		augA=A(:,1:nA-1);
			matdiffu=ones(mA,1) * diffu;
				I=sum((augA .*matdiffu)')';
