function [C]=centre(A,u)
%CENTRE: This function returns the centre of matrix of fuzzy value B over 
%	 universe V. The centre C is a vector the same number on membership
%	 functions in B (the same number of row).
%
%				    [C]=CENTRE(B,V)
%
%				       	See also KOSKO, and INTEGRAL.

% FISMAT: Fuzzy Inference Systems toolbox for MATLAB
% (c) A. Lotfi, University of Queensland (Email: lotfia@s1.elec.uq.oz.au)
% 13-10-93
% The program has been tested on MATLAB version 4.1, Sun workstation.

diffu=diff(u);
	[mA,nA]=size(A);
		augA=A(:,1:nA-1);
			matdiffu=ones(mA,1) * diffu;
				I=sum((augA .*matdiffu)')';
matu=ones(mA,1) * u;
	amatu=A .*matu; 
		augamata=amatu(:,1:nA-1);
			C=sum((augamata .* matdiffu)')' ./I;
