function [dbp,W]=zadeh(a,b,c,d,e,f,g,h,i,j,k)
%ZADEH: Based on Lotfi A. Zadeh's Compositional rule of inference, and 
%       Mamdani's implication relation (MIN), decision for a set of 
%       rules A -> B and observation Ap is given in this function. When 
%	the premise contains only one antecedent, then decision process 
%	is as follow:
%         		[Bp,W] = ZADEH(A,Ap,B,ALSO)                  
%       
%	Where A matrix of antecedent fuzzy value , Ap fuzzy observation
%       vector, B matrix of consequence fuzzy value and ALSO is connective
%	operator of rules and it is defined as follow;
%       		 ALSO:   1 Max  
%				 2 Sum
%	The outputs are vector of fuzzy conclusion Bp and firing weight of 
%	each rule.
%       When premise contains more then one antecedent, Considering
%       liaison operator AND is important. Therefore if AND is 1, then
%       the minimum of two weight selected as overall weight of firing
%       and when it is 2 the multiplication considered. 
%
%      		   [Bp,W] = ZADEH(A1,A1p,...,A4,A4p,B,AND,ALSO)
%
%			See also LARSEN, SUGENO, MAMDANI, KOSKO and TURKSEN.



% FISMAT: Fuzzy Inference Systems toolbox for MATLAB
% (c) A. Lotfi, University of Queensland (Email: lotfia@s1.elec.uq.oz.au)
% 13-10-93
% The program has been tested on MATLAB version 4.1, Sun workstation.

if nargin ==  4

	W=reason(a,b);db=c;also=d;

elseif nargin == 7

	W=reason(a,b,c,d,f);db=e;also=g;

elseif nargin == 9

	W=reason(a,b,c,d,e,f,h);db=g;also=i;

elseif nargin == 11

	W=reason(a,b,c,d,e,f,g,h,j);db=i;also=k;

else
	error('Input arguments are not sufficient.');
end

if W == 0,
   disp(blanks(2)'); disp('Warning: No rule fired!');
end;

% truncation process/ musk

if also == 1
	dbp=max(min(db,diag(W)*ones(size(db))));
elseif also == 2
	dbp=sum(min(db,diag(W)*ones(size(db))));
else
	error('Connector operator ALSO is not a proper method.')
end
