function [dbp,W]=turksen(a,b,c,d,e,f,g,h,i,j,k)
%TURKSEN: Turksen's Approximate Analogical Reasoning Approach based on
%         Similarity Measure is presented in this function. Set of rules 
%         A -> B and observation Ap are as inputs of this function. When 
%	  the premise contains only one  antecedent, then decision process
%	  is as follow:
%       		  [Bp,W] = TURKSEN(A,Ap,B,MISC)
%
%         Input miscellaneous vector MISC is a 3 elements vector contains 
%	  some properties of reasoning.
%                        MISC=[N-SIMILAR N-MODIFY THAO]
%         N-SIMILAR and N-MODIFY are method of similarity measure and 
%	  modification function respectively. Variable THAO is threshold 
%	  value for selecting fired rules. (See also MODIFY and SIMILAR). 
%         The outputs are vector of fuzzy conclusion Bp and firing weight 
%	  of each rule W. In the case multi inputs, if AND is 1 the average
%         of firing weigths, and if AND is 2 the maximum of firing weight 
%	  will be considered for overall firing weight.
%
%      		   [Bp,W] = TURKSEN(A1,A1p,...,A4,A4p,B,AND,MISC)
%
%			See also LARSEN, SUGENO, ZADEH, KOSKO and MAMDANI.


% FISMAT: Fuzzy Inference Systems toolbox for MATLAB
% (c) A. Lotfi, University of Queensland (Email: lotfia@s1.elec.uq.oz.au)
% 13-10-93
% The program has been tested on MATLAB version 4.1, Sun workstation.

dbp=[];

if nargin == 4

        W=similar(a,b,d(1));

        musk=(d(3)*ones(size(W)))-W <= 0;

        db=modify(c,W,d(2));
        dbp=max(min((diag(musk) * ones(size(db))),db));

elseif nargin == 7

        W1=similar(a,b,g(1));
        W2=similar(c,d,g(1));

                if f == 2
                W=max(W1,W2);
                elseif f == 1
                W=(W1+W2)/2;
                else
                error('Input parameters for AND is not correct.');
                end

        musk=(g(3)*ones(size(W)))-W <= 0;

        db=modify(e,W,g(2));
        dbp=max(min((diag(musk) * ones(size(db))),db));

elseif nargin == 9

        W1=similar(a,b,i(1));
        W2=similar(c,d,i(1));
        W3=similar(e,f,i(1));

                if h == 2
                W=max(max(W1,W2),W3);
                elseif h == 1
                W=(W1+W2+W3)/3;
                else
                error('Input parameters for AND is not correct.');
                end

        musk=(i(3)*ones(size(W)))-W <= 0;

        db=modify(g,W,i(2));
        dbp=max(min((diag(musk) * ones(size(db))),db));


elseif nargin == 11

        W1=similar(a,b,k(1));
        W2=similar(c,d,k(1));
        W3=similar(e,f,k(1));
	W4=similar(g,h,k(1));

                if j == 2
                W=max(max(W1,W2),W3,W4);
                elseif j == 1
                W=(W1+W2+W3+W4)/4;
                else
                error('Input parameters for AND is not correct.');
                end

        musk=(k(3)*ones(size(W)))-W <= 0;

        db=modify(i,W,k(2));
        dbp=max(min((diag(musk) * ones(size(db))),db));


else
        error('Input arguments are not correct.');
end

if musk == 0,disp(blanks(2)');disp('Warning: No rule fired!'); end

W=W(:);
