function [Bo,W]=sugeno(a,b,c,d,e,f,g,h,i,j,k,l,m,n)
%SUGENO: Based on Sugeno and Takagi's model of fuzzy systems, inference
%        mechanism for a set of rules A -> B and observation Ao is given
%        in  this function. When the premise contains only one antecedent,
%        then decision process is as follow:
%
%         [Bo,W] = SUGENO(A,Ao,U,P)      P=[P0 P1]
%
%        Where A antecedent matrix, Ao observation crisp value, U universe
%	 of antecedent, P matrix of coefficient for consequent part, Bo is 
%	 crisp decision value, and W is firing weight of each rule.
% 
%        When premise contains more then one antecedent, Considering
%        liaison operator AND is important. Therefore if AND is 1, then
%        the minimum of two weight selected as overall weight of firing
%        and when it is 2 the multiplication considered.
%
%	  [Bo,W] = SUGENO(A1,A1o,U1,...,A4,A4o,U4,P,AND)  P=[P0 P1 .. P4]
%
%		      See also LARSEN, MAMDANI, ZADEH, KOSKO and TURKSEN.




% FISMAT: Fuzzy Inference Systems toolbox for MATLAB
% (c) A. Lotfi, University of Queensland (Email: lotfia@s1.elec.uq.oz.au)
% 13-10-93
% The program has been tested on MATLAB version 4.1, Sun workstation.

if nargin ==  4

        W=grademf(a,b,c);
        bp=d(:,1)+d(:,2) .*b;

elseif nargin == 8

        W1=grademf(a,b,c); W2=grademf(d,e,f);

                if h == 1,
                W=min(W1,W2);
                elseif h == 2
                W=W1 .*W2;
                else
                error('Liasing operator AND is not proper method.')
                end

        bp=g(:,1)+g(:,2)*b+g(:,3)*e;

elseif nargin == 11
        W1=grademf(a,b,c);W2=grademf(d,e,f);W3=grademf(g,h,i);

                if k == 1,
                W=min([W1,W2,W3])';
                elseif k == 2
                W=W1 .*W2 .*W3;
                else
                error('Liasing operator AND is not proper method.')
                end

        bp=j(:,1)+j(:,2)*b+j(:,3)*e+j(:,4)*h;

elseif nargin == 14
        W1=grademf(a,b,c);W2=grademf(d,e,f);W3=grademf(g,h,i);W3=grademf(j,k,l);

                if n == 1,
                W=min([W1,W2,W3,W4])';
                elseif n == 2
                W=W1 .*W2 .*W3 .*W4;
                else
                error('Liasing operator AND is not proper method.')
                end

        bp=m(:,1)+m(:,2)*b+m(:,3)*e+m(:,4)*h+m(:,5)*k;


else
        error('Input arguments are not sufficient.');
end

if W == 0,
   disp(blanks(2)'); disp('Warning: No rule fired!');
end;

Bo=sum(W .* bp)/sum(W);
