function [dbp,W]=mamdani(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o)
%MAMDANI: When the inputs of fuzzy inference systems are crisp rather than
%	  fuzzy value, decision process becomes simpler. This function 
%	  perform the Mamdani's Min-Max mechanism.
%
%         		[Bp,W] = MAMDANI(A,Ao,U,B,ALSO)   
%
%	  Where A and B are matrix of antecedent and consequent respectively
%	  ,Ao is input crisp value and U is the input universe. ALSO as
%	  connective operator that can selected 1 or 2 for Max or Sum of each
%	  rule. The outputs are vector of fuzzy conclusion Bp and firing
%	  weight of each rule. 
%        
%         When premise contains more then one antecedent, Considering
%         liaison operator AND is important. Therefore if AND is 1, then
%         the minimum of two weight selected as overall weight of firing
%         and when it is 2 the multiplication considered. 
%
%         [Bp,W] = MAMDANI(A1,A1o,U1,...,A4,A4o,U4,B,AND,ALSO)
%
%			See also LARSEN, SUGENO, ZADEH, KOSKO and TURKSEN.


% FISMAT: Fuzzy Inference Systems toolbox for MATLAB
% (c) A. Lotfi, University of Queensland (Email: lotfia@s1.elec.uq.oz.au)
% 13-10-93
% The program has been tested on MATLAB version 4.1, Sun workstation.

if nargin ==  5

	W=grademf(a,b,c);db=d;also=e;

elseif nargin == 9

	W1=grademf(a,b,c); W2=grademf(d,e,f);
        if h == 1,
        	W=min(W1,W2);
        elseif h == 2
        	W=W1 .*W2;
        else
        	error('Liasing operator AND is not proper method.')
        end

	db=g;also=i;

elseif nargin == 12

	W1=grademf(a,b,c); W2=grademf(d,e,f); W3=grademf(g,h,i);
	db=j;also=l;

        if k == 1,
        	W=min([W1,W2,W3])';
        elseif k == 2
        	W=W1 .*W2 .*W3;
        else
        	error('Liasing operator AND is not proper method.')
        end

elseif nargin == 15

	W1=grademf(a,b,c); W2=grademf(d,e,f); W3=grademf(g,h,i);W4=grademf(j,k,l);
	db=m;also=o;

        if n == 1,
        	W=min([W1,W2,W3,W4])';
        elseif n == 2
        	W=W1 .*W2 .*W3 .*W4;
        else
        	error('Liasing operator AND is not proper method.')
        end



else
	error('Input arguments are not sufficient.');
end

if W == 0,
   disp(blanks(2)'); disp('Warning: No rule fired!');
end;

% truncation process/ musk

if also == 1
	dbp=max(min(db,diag(W)*ones(size(db))));
elseif also == 2
	dbp=sum(min(db,diag(W)*ones(size(db))));
else
	error('Connector operator ALSO is not a proper method.')
end
