% INTRO_DEMO: To be called from FISDEMO.M.

% FISMAT: Fuzzy Inference Systems toolbox for MATLAB
% (c) A. Lotfi, University of Queensland (Email: lotfia@s1.elec.uq.oz.au)
% 13-10-93
% The program has been tested on MATLAB version 4.1, Sun workstation.

clf;set(gcf,'units','normal','position',[.34 .55 .65 .4])

echo on
clc;
% In this part of demonstration the terminology used for FISMAT will
% be explained.

% Always matrices expressed by A or B (can be A1, A2,..) are matrices
% of membership functions such that each row of matrices belongs to a
% specific membership function and each column represent the grade of
% membership. The membership functions are defined on a predefined 
% universe of discourse U for A or V for B.

pause % Press any key to continue
clc;clf;
% When there is just one membership function, the terminology used is
% Ap or Bp for antecedent or consequent of each rule.
 
U=[-2:.2:2];

Ap=bell_1(U);

plot(U,Ap);
xlabel('Universe of discourse U');ylabel('Grade of membership function');


pause % Press any key to continue
clc;
% There are different ways to introduce membership functions, they are;
% BELL_1, BELL_2, TRAPEZE, and SIGMOID.

% Let's form a matrix of membership function with universe of U and five 
% different membership functions.  
 
A = [bell_1(U)
     bell_2(U,1,1,-1)
     trapeze(U,1,.10,1) 
     sigmoid(U,5,1.2) 
     sigmoid(U,-5,-1.2)];

 
plot(U,A)
xlabel('Universe of discourse U');ylabel('Grade of membership function');
title('Matrix of fuzzy value A');

pause % Press any key to continue
clc
% To create the membership functions for rule-base there is a simple way
% that simply we can form the rule-base parameters. Let's consider a 
% system with one input and one output and 5 number of rules. The only
% information we require is input universe U, output universe V, and
% the parameters which forms the membership functions. These parameters
% must be given in a vector form.

a=[1 1 1 1 1];
b=[1 1 1 1 1];
c=[-2 -1 0 1 2];
 
ahat=[1 1 1 1 1];
bhat=[1 1 1 1 1];
chat=[-2 -1 0 1 2];

U=[-2:.2:2];
V=[-1:.2:1];

[A,B]=rulebase(1,U,a,b,c,1,V,ahat,bhat,chat);

pause % Press any key to continue
clc
% If we want to have a look on whatever has been created for membership 
% functions in rule_base, the MFPLOT is a useful command.

mfplot(A,U,B,V)

pause % Press any key to continue

clf;set(gcf,'units','normal','position',[.34 .55 .65 .4])
clc;
% Suppose we have two matrices/vectors of membership functions A1, A2/
% A1p,A2p. The union, intersection and complement of each membership
% function are given as follows;

U=[-2:.2:2];
A1p=bell_1(U);
A2p=sigmoid(U,3,1);

plot(U,A1p,'r',U,A2p,'g')

echo off
xlabel('Universe of discourse U');ylabel('Grade of membership function');
title('Red line A1''  &  Green line A2'' ')
echo on; 

pause % Press any key to continue
clc
% Then the union of two membership functions is;

C=union(A1p,A2p);

% The intersection of two membership functions is;

D=intersec(A1p,A2p);

plot(U,C,'r',U,D,'g');

echo off
subplot(211);plot(U,A1p,'r',U,A2p,'g');
title('Red line A1''  &  Green line A2'' ')
subplot(212);plot(U,C,'r',U,D,'g');
xlabel('Universe of discourse U');
title('Red line Union(A1'' A2'')  &  Green line Intersection(A1'' A2'') ')
echo on;

pause %Press any key to continue
clc
% We can investigate the effects of some quantifiers on grade of membership
% functions. In this bunch of m-files there are three quantifiers. They
% are VERY, MORELESS, and NOT(COMPLE). 

% Now we can see the effects of these quantifiers on fuzzy value A1p.

vera=very(A1p);
mora=moreless(A1p);
nota=not(A1p);

subplot(211);plot(U,A1p);
echo off
subplot(212);plot(U,vera,'r',U,mora,'g',U,nota,'w');
xlabel('Universe of discourse U');
title('Red line Very &  Green line More_less  & White line Not')
echo on;

pause % Press any key to continue
clc;
% In this part of demonstration we have introduced the following functions;
%
%	BELL_1, BELL_2, TRAPEZE, SIGMOID
%	RULEBASE
%	MFPLOT
% 	UNION, INTERSEC, COMPLE
% 	VERY, MORELESS, NOT

echo off
