function [dA1dA2] = intersec(dA1,dA2)
%INTERSEC:  The intersection of matrix of fuzzy values A and B over the
% 	    same universe will be calculated. 
%
%                              [A1&A2] = INTERSEC(A1,A2)
%
%           Matrices A and B are matrices of membership functions. Output of 
%	    this  function is result grade of membership function A1|A2 over 
%           the same universe.
%					           See also UNION and COMPLE.


% FISMAT: Fuzzy Inference Systems toolbox for MATLAB
% (c) A. Lotfi, University of Queensland (Email: lotfia@s1.elec.uq.oz.au)
% 13-10-93
% The program has been tested on MATLAB version 4.1, Sun workstation.

if size(dA1) ~= size(dA2)
	error('Two fuzzy sets DA1 ana DA2 must be the same dimension.')
end

if (max(max(dA1)) > 1) | (max(max(dA2)) > 1) | (min(min(dA1)) < 0) | (min(min(dA2)) < 0)
	error('Grade of membership function should not be more than one or less than zero.')
end

dA1dA2=min(dA1,dA2);
