echo off

% IMPLY_DEMO: To be called from FISDEMO.M.

% FISMAT: Fuzzy Inference Systems toolbox for MATLAB
% (c) A. Lotfi, University of Queensland (Email: lotfia@s1.elec.uq.oz.au)
% 13-10-93
% The program has been tested on MATLAB version 4.1, Sun workstation.

clf;set(gcf,'units','normal','position',[.34 .55 .65 .4])

echo on;
clc;clf;
% This part of demonstration devoted to some features of implication 
% relation. At first we introduce the IMPLY function which covers
% most of practicable interpretation for fuzzy implication A->B.
% Consider a rule-base with 2 rules and just one antecedent A and one
% consequent B in different universe of U and V respectively. 

a=[1 1]; b=[1 1]; c=[-2  2];

ahat=[1 1]; bhat=[1 1]; chat=[-2 2];

U=[-2:.2:2]; V=[-1:.2:1];

[A,B]=rulebase(2,U,a,b,c,1,V,ahat,bhat,chat);

subplot(221);plot(U,A(1,:)); title('Antecedent A');
ylabel('Rule 1');
subplot(223);plot(U,A(2,:)); xlabel('Universe of discourse U')
ylabel('Rule 2');
subplot(222);plot(V,B(1,:)); title('consequent B');   
subplot(224);plot(V,B(2,:)); xlabel('Universe of discourse V');

pause % Press any key to continue
clc;clf;
% Fuzzy implication relation R related to implication A->B can be 
% obtained by using;

R=imply(A,B,1);

surf(V,U,R);
title('Min operation rule')

pause % Press any key to continue
clc;
% Based of fuzzy relation matrix R and observation vector Ap, using Zadeh's
% compositional rule of inference (CRI), the decision vector Bp is obtained as
% follows;

Ap=(very(A(1,:))+very(A(2,:)))/2;
Bp=cri(R,Ap);

subplot(321);plot(U,A(1,:)); title('Antecedent A');ylabel('Rule 1');
subplot(323);plot(U,A(2,:));ylabel('Rule 2'); 
subplot(322);plot(V,B(1,:)); title('Consequent B');
subplot(324);plot(V,B(2,:)); 
subplot(325);plot(U,Ap);
xlabel('Universe of discourse U ');title('Observation A'' ');
subplot(326);plot(V,Bp);
xlabel('Universe of discourse V');title('Conclusion B'' ');

pause % Press any key to continue
clc;
% If we want to find out the grade of membership for any input fuzzy
% singleton in rule-base, GRADEMF do this job. The terminology used for
% a fuzzy singleton is Ao.
% Consider antecedent part of rule-base A, the grade of membership for
% input Ao = 0.35 are;

W=grademf(A,.35,U)

pause % Press any key to continue
clc;
% In the case, the input Ap is a fuzzy value rather than crisp Ao, the
% grade of weight of rule firing will be obtained by using REASON.

W=reason(A,Ap)

pause % Press any key to continue
clc;
% The firing weights are the max_min of observation Ap and antecedent
% parts of rules. When antecedents are more than one, the operator
% AND should be specified as an input of function.

W= reason(A,Ap,very(A),moreless(Ap),2)

% Where the last input is specified 2 for multiplication interpretation 
% of operator AND.

pause % Press any key to continue
clc;
% To find out the similarity between observation vector Ap and rules
% specified on A, the function SIMILAR govern this task.

W=similar(A,Ap,1)

% The third input of functions specifies different methods of similarity
% measure.

pause % Press any key to continue
clc;
% In this part of demonstration the following functions are used.
%
% 	IMPLY, CRI, GRADEMF, REASON, SIMILAR
