function [surf]=controlsurf(fun,a,b,c,d,e,f,g,h)
%CONTRLSURF: To investigate the fuzzy control strategy with different
%            membership functions under different method of reasoning
%	     this function can be applied. The control surface only for
%	     two cases, when there is one antecedent or when there are
%	     two inputs can be utilized.  	
%
% 		SURF = CONTROLSURF(FUN,A,U,B,V,ALSO(MISC))
%               SURF = CONTROLSURF(FUN,A1,U1,A2,U2,B,V,AND,ALSO(MISC))
%
%	     The inputs of function are matrix of fuzzy values A and B,
%	     along with their universe U and V. The method of reasoning
%	     must be expressed as string input FUN (MAMDANI, LARSEN, KOSKO).
%	     It is to be noted that with KOSKO reasoning, input ALSO should
%	     be considered as MISC variable. 
%            In the case using SUGENO reasoning method the inputs should 
%	     be as follows;
%
%               SURF = CONTROLSURF(FUN,A,U,P)
%               SURF = CONTROLSURF(FUN,A1,U1,A2,U2,P,AND)


% FISMAT: Fuzzy Inference Systems toolbox for MATLAB
% (c) A. Lotfi, University of Queensland (Email: lotfia@s1.elec.uq.oz.au)
% 13-10-93
% The program has been tested on MATLAB version 4.1, Sun workstation.

Bstore=[];

if nargin == 6
	if fun(1:5) == 'kosko'
		for i=1:length(b)
			Bo=kosko(a,b(i),b,c,d,e);
			[Bstore]=[Bstore,Bo];
		end
	else
		for i=1:length(b)
			[Bp]=feval(fun,a,b(i),b,c,e);
			Bo=defzfir(Bp,d,1);
			[Bstore]=[Bstore,Bo];
		end
	end
elseif nargin == 9
	if fun(1:5) == 'kosko'
		for j=1:length(d)
		for i=1:length(b)
			[Bo]=kosko(a,b(i),b,c,d(j),d,e,f,g,h);
		 	[Brow]=[Brow,Bo];
		end
			[Bstore]=[Bstore;Brow];
			Brow=[];
		end	
	else
		for j=1:length(d)
		for i=1:length(b)
			[Bp]=feval(fun,a,b(i),b,c,d(j),d,e,g,h);
			Bo=defzfir(Bp,f,1);
			[Brow]=[Brow,Bo];
		end
			[Bstore]=[Bstore;Brow];
			Brow=[];
		end
	end
elseif nargin == 4
        for i=1:length(b)
                [Bo]=feval(fun,a,b(i),b,c);
                [Bstore]=[Bstore,Bo];
        end

elseif nargin == 7
        for j=1:length(d)
        for i=1:length(b)
                [Bo]=feval(fun,a,b(i),b,c,d(j),d,e,f);
                [Brow]=[Brow,Bo];
        end
                [Bstore]=[Bstore;Brow];
                Brow=[];
        end
else
	error('Inputs of CONTROLSURF are not in a correct format.')
end

surf=Bstore;

