//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: HashStatic.h,v 0.22 1994/07/22 09:20:16 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNHashStatic --- hash tables with static number of entries
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License. 
 **EHEADER********************************************************************/

#ifndef __HashStatic_h
#define __HashStatic_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/HashTable.h>		// Base class

extern CNClassDesc CN_HASHSTATIC;	// CNClass CNHashStatic description

/*
 * The class CNHashStatic
 */

class CNHashStatic : public CNHashTable
{
    struct HashEntry *table;
    unsigned long capacity;
    unsigned long entries;

public:
    virtual void store_key(CNKey *k);
    virtual void store_key(CNKey &k) 
    { store_key(&k); }
    virtual CNKey *get_key(CNKey *k) const;
    virtual CNKey *get_key(CNKey &k) const
    { return get_key(&k); }
    virtual CNObject *get_object(CNKey *k) const;
    virtual CNObject *get_object(CNKey &k) const 
    { return get_object(&k); }

    virtual bool reset();
    virtual bool reset_absolutely();
    virtual bool delete_key(CNKey *k);
    virtual bool delete_key(CNKey &k) 
    { return delete_key(&k); }
    virtual bool delete_key_absolutely(CNKey *k);
    virtual bool delete_key_absolutely(CNKey &k)
    { return delete_key_absolutely(&k); }

    virtual bool is_full() const 
    { return entries == capacity; }
    virtual bool is_empty() const
    { return !entries; }
    virtual unsigned long get_capacity() const 
    { return capacity; }
    virtual unsigned long get_num_entries() const
    { return entries; }
    
private:
    unsigned long collision(unsigned long hash_value);
    void init_table(unsigned long cap);
    unsigned long find_key(CNKey *k, unsigned long hash_value) const;
    void hash(CNKey *k, unsigned long hash_value);
    bool remove_key(CNKey *k, bool remove_absolutely);

    /***** Constructors ******************************************************/
public:
    CNHashStatic(unsigned long cap = DEFAULT_HASH_TABLE_CAPACITY); 	
                                                        // Default constructor
    CNHashStatic(CNParam *param);			        // CNParam constructor
    ~CNHashStatic();

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_HASHSTATIC;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_HASHSTATIC ? TRUE : CNHashTable::is_a(desc);
    };
        
    static CNHashStatic *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNHashStatic *)obj;
#   else
	return (CNHashStatic *)( !obj || obj->is_a(CN_HASHSTATIC)
	       ? obj : fatal_type(obj->class_desc(), CN_HASHSTATIC) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNHashStatic(param) : new CNHashStatic; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__HashStatic_h**/
