//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: FRule.h,v 0.22 1994/07/22 09:21:33 cncl-adm Exp cncl-adm $
 *
 * Class: CNFRule --- Fuzzy rule
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __CNFRule_h
#define __CNFRule_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Object.h>		// Base class
#include <CNCL/FClause.h>
#include <CNCL/FSetArray.h>

extern CNClassDesc CN_FRULE;	// Class CNFRule description


/*
 * The class CNFRule
 */

class CNFRule : public CNObject
{
  public:
    void add_lhs(CNFClause *clause);	// Add LHS clause
    void add_lhs(CNFClause &clause);
    void add_rhs(CNFClause *clause);	// Add RHS clause
    void add_rhs(CNFClause &clause);

    int get_n_lhs() const;		// Get # clauses LHS
    int get_n_rhs() const;		// Get # clauses RHS

    CNFClause *get_lhs(int i) const;	// Get clause from LHS
    CNFClause *get_rhs(int i) const;	// Get clause from RHS

    double set_certainty(double x);	// Get/set certainty value
    double certainty(double x);
    double get_certainty() const;
    double certainty() const;

    double aggregate_value() const;
    					// Aggregate rule inputs (LHS)
    double aggregate(/**FIXME: Operator needed**/);
    
    // Private members
  private:
    CNArrayObject lhs;			// Rule LHS
    CNArrayObject rhs;			// Rule RHS
    double r_certainty;			// Rule certainty
    double agg_value;			// Result of aggregate() LHS
    
    /***** Constructors ******************************************************/
  public:
    CNFRule()               : lhs(0), rhs(0), r_certainty(1.) {}
    CNFRule(CNParam *param) : lhs(0), rhs(0), r_certainty(1.) {}

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_FRULE;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_FRULE ? TRUE : CNObject::is_a(desc);
    };
        
    static CNFRule *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNFRule *)obj;
#   else
	return (CNFRule *)( !obj || obj->is_a(CN_FRULE)
	       ? obj : fatal_type(obj->class_desc(), CN_FRULE) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNFRule(param) : new CNFRule; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


#endif /**__CNFRule_h**/
