//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EventScheduler.h,v 0.22 1994/07/22 09:21:05 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNEventScheduler --- CNEvent scheduler
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __EventScheduler_h
#define __EventScheduler_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Object.h>		// Base class

#include <CNCL/Event.h>
#include <CNCL/EventHandler.h>
#include <CNCL/EventList.h>

extern CNClassDesc CN_EVENTSCHEDULER;// CNClass CNEventScheduler description



/*
 * The class CNEventScheduler
 */

class CNEventScheduler : public CNObject
{
public:
    void send_event(CNEvent *ev);		// Send event (add to list)
    void add_event(CNEvent *ev);		// Send event (add to list)
    void delete_event(CNEventID id);	// Delete event from list
    void delete_events(CNEventHandler *evh);	// Delete events for EvH
    CNEvent *peek_event();		// Peek at next event
    CNEvent *peek_event(CNEventID id);	// Peek at event with id

    void start();			// Start scheduler
    void start(CNEvent *ev);		// Start scheduler with initial event

    void stop();			// Stop scheduler

    CNSimTime time();			// Return simulation time

    // Private members
private:
    CNEventList list;			// CNEvent list
    CNSimTime simtime;			// Simulation time
    bool stop_flag;			// Flag set by stop()

    void process_events();		// CNEvent processing

    /***** Constructors ******************************************************/
public:
    CNEventScheduler();
    CNEventScheduler(CNParam *param);

  private:
    CNEventScheduler(const CNEventScheduler &l)
    {
	fatal(NIL, "can't copy CNEventScheduler object");
    }

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_EVENTSCHEDULER;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_EVENTSCHEDULER ? TRUE : CNObject::is_a(desc);
    };
        
    static CNEventScheduler *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNEventScheduler *)obj;
#   else
	return (CNEventScheduler *)( !obj || obj->is_a(CN_EVENTSCHEDULER)
	       ? obj : fatal_type(obj->class_desc(), CN_EVENTSCHEDULER) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNEventScheduler(param) : new CNEventScheduler; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


#endif /**__EventScheduler_h**/
