#ifndef __SDLSystem_DemonGame_h
#define __SDLSystem_DemonGame_h

#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/SDLManager.h>

#include "SDLSystem_DemonGame_Signals.h"
#include "SDLSystem_DemonGame_Timers.h"
#include "SDLSystem_DemonGame_Channels.h"
#include "SDLSystem_DemonGame_ProcessTypes.h"
#include "SDLSystem_DemonGame_Types.h"

#include <CNCL/SDLEnvironment.h>

#include "SDLProcess_Demon.h"
#include "SDLProcess_Game.h"
#include "SDLProcess_Main.h"

#include <CNCL/FiboG.h>
#include <CNCL/Normal.h>

extern CNClassDesc CN_SDLSYSTEM_DemonGame;

/*
 * The class SDLSystem_DemonGame
 */

class SDLSystem_DemonGame : public CNSDLManager
{
public:

 // Private members
private:
CNSDLProcessData *processes [5];
CNSDLChannel *channels [End_of_Channellist];
ProcessType signal_receiver[End_of_Signallist];
CNRNG *base_generator;
CNRandom *default_random_generator;

/*--------- Constructors ---------*/
public:
SDLSystem_DemonGame() {};
SDLSystem_DemonGame(CNParam *param) {}

SDLSystem_DemonGame(int, CNEventScheduler*, CNRandom* = NIL);

/***** Member functions required by CNCL *********************************/
public:
virtual CNClassDesc class_desc() const
{
return CN_SDLSYSTEM_DemonGame;
};

virtual bool is_a(CNClassDesc desc) const
{
	return desc == CN_SDLSYSTEM_DemonGame ? TRUE : CNSDLManager::is_a(desc);
};

static SDLSystem_DemonGame *cast_from_object(CNObject *obj)
{
#ifdef NO_TYPE_CHECK
	return (SDLSystem_DemonGame *)obj;
#else
	return (SDLSystem_DemonGame *)( !obj || obj->is_a(CN_SDLSYSTEM_DemonGame)
	? obj : fatal_type(obj->class_desc(), CN_SDLSYSTEM_DemonGame) );
#endif
}
static CNObject *new_object(CNParam *param = NIL)
{ return param ? new SDLSystem_DemonGame(param) : new SDLSystem_DemonGame; }

virtual void print (ostream &strm = cout) const;
virtual void dump (ostream &strm = cout) const;
};

#endif /**SDLSystem_DemonGame_h**/