#include "SDLSystem_DemonGame.h"

SDLSystem_DemonGame::SDLSystem_DemonGame(int system, CNEventScheduler *sched, CNRandom *ch_rnd):
CNSDLManager(system,processes,5,signal_receiver,End_of_Signallist,channels,sched)

{
	signal_receiver[0] = 0;
	signal_receiver[Newgame] = 2;
	signal_receiver[Bump] = 3;
	signal_receiver[Score] = 1;
	signal_receiver[Lose] = 1;
	signal_receiver[Win] = 1;
	signal_receiver[Endgame] = 2;
	signal_receiver[Result] = 3;
	signal_receiver[Probe] = 3;
	signal_receiver[GameOver] = 3;

if (!ch_rnd) {
	base_generator = new CNFiboG;
	default_random_generator =
			new CNNormal(1.0, 1.0, base_generator);
}
else
	default_random_generator = ch_rnd;

for (int i = 0; i < End_of_Channellist; i++)
{
	channels[i] = new CNSDLChannel;
	channels[i]->rnd_delay = default_random_generator;
	channels[i]->last_arrival = 0.0;
}

processes[1] = CNSDLEnvironment::pointer_to_environment_data;

processes[2] = new CNSDLProcessData(2,4,1,FALSE,TRUE);
create(new SDLProcess_Demon("Demon",this,4),2);
processes[3] = new CNSDLProcessData(3,3,1,FALSE,FALSE);
processes[4] = new CNSDLProcessData(4,2,1,FALSE,FALSE);
create(new SDLProcess_Main("Main",this,2),4);

}

/***** Default I/O member function for CNCL classes **************************/

// Normal output
void SDLSystem_DemonGame::print(ostream &strm) const
{
	strm << "..." << endl;
}

// Debug output
void SDLSystem_DemonGame::dump(ostream &strm) const
{
	strm << "SDLSystem_DemonGame { $Revision$ ..."
	<< " }" << endl;
}

/***** CNCL stuff for type information ***************************************/

// Describing object for class SDLSystem_DemonGame
static CNClass SDLSystem_DemonGame_desc("SDLSystem_DemonGame", "$Revision$",
			SDLSystem_DemonGame::new_object);

// "Type" for type checking functions
CNClassDesc CN_SDLSYSTEM_DemonGame = &SDLSystem_DemonGame_desc;