#ifndef __SDLProcess_Demon_h
#define __SDLProcess_Demon_h

#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/SDLProcess.h>

#include "SDLSystem_DemonGame_Signals.h"
#include "SDLSystem_DemonGame_Timers.h"
#include "SDLSystem_DemonGame_Channels.h"

extern CNClassDesc CN_SDLPROCESS_Demon;

/*
 * The class SDLProcess_Demon
 */

class SDLProcess_Demon : public CNSDLProcess
{

 // Private members
private:

/*---- procedure declaration ----*/
virtual int process(int);


/*---- process state declaration ----*/
enum states
{
	INIT=0,
	Generate
};

/*---- local variable declaration ----*/


/*--------- Constructors ---------*/
public:
SDLProcess_Demon() {}
SDLProcess_Demon(CNParam *param) {}

SDLProcess_Demon(char*, CNSDLManager*, int);

/***** Member functions required by CNCL *********************************/
public:
virtual CNClassDesc class_desc() const
{
return CN_SDLPROCESS_Demon;
};

virtual bool is_a(CNClassDesc desc) const
{
	return desc == CN_SDLPROCESS_Demon ? TRUE : CNSDLProcess::is_a(desc);
};

static SDLProcess_Demon *cast_from_object(CNObject *obj)
{
#ifdef NO_TYPE_CHECK
	return (SDLProcess_Demon *)obj;
#else
	return (SDLProcess_Demon *)( !obj || obj->is_a(CN_SDLPROCESS_Demon)
		? obj : fatal_type(obj->class_desc(),CN_SDLPROCESS_Demon) );
#endif
}

static CNObject *new_object(CNParam *param = NIL)
{ return param ? new SDLProcess_Demon(param) : new SDLProcess_Demon; }


virtual void print(ostream &strm = cout) const;
virtual void dump (ostream &strm= cout) const;
};

#endif /**SDLProcess_Demon_h**/