// Dieses Program berechnet
//   die Zykluszeit c,
//   den Durchsatz und
//   die mittlere Wartezeit
// eines FDDI Ringes mit
//   einer Ringlaenge von 100 km,
//   25 Stationen,
//   einer Stationslatenz von 64 Bit und
//   einem TTRT von 10 ms
// sowie einer mittleren Packetlaenge von 1024 Bit 
// und einem Ueberhang von 224 Bit.
// 
// Der Grenzwert \gamma wird als Nettowert berechnet, d.h., das der
// Packetueberhang von L_o=224 Bit nicht mitberuecksichtigt wird.
//
// Die Zykluszeit wird gemaess der Formel (20) von M.Tangemann berechnet.
//
// Der Durchsatz wird gemaess der Formel (19) von M.Tangemann berechnet.
//
// Die Zwischenankunftszeit wird gemaess der Formel(25) von 
// M.Tangemann berechnet.
// 

#include <stdlib.h>
#include <stdio.h>

#define c_null  0.0005245  // [Sekunden]
#define N       10
//#define N       25
#define ttrt    0.004       // [Sekunden]
//#define ttrt    0.01       // [Sekunden]
#define cs      1     // 0.6732
//#define cs      0.6732     // 0.6732
#define ts      0.00005000 // [Sekunden]
//#define ts      0.00001248 // [Sekunden]
#define v       100.0      // [Mbps]
#define lp      5000       // Packetlaenge aus Beispiel A [Bit]
//#define lp      1024       // Packetlaenge aus Beispiel A [Bit]
#define lo      0        // Packetueberhang      "      [Bit]
//#define lo      224        // Packetueberhang      "      [Bit]

FILE *datei;
char *dateistr;

double rho;
double gamma;
double c;
double tw;
double throughput;

char stop;

//---------------------------- Funktionen --------------
double rho_a()
{
  return( rho * (lp + lo) / lp);
}

double getgamma()
// um den Nettowert von gamma zu erhalten, muss der overhead
// aus der Rechnung entfernt werden => *1024/1248
{
  return( (ttrt - c_null) / (ttrt + (c_null/N)) * lp / (lp + lo) );
}

double getzykluszeit()
{
  if (rho > gamma)
  {
	 return( (c_null + N*ttrt) / (N + 1) );
  }
  else
  {
	 return( c_null / (1 - rho_a() ) );
  }
}

double getthroughput()
{
	 if (rho > gamma)
  {
	 return( gamma * v );
  }
  else
  {
	 return( rho * v );
  }
}

double gettw()
{
  if (rho > gamma)
  {
	 if (rho_a() == 1.0) return ( 0 );
	 else
	 {
		return( ((c_null+N*ttrt)*(1-rho_a()/N))/(2*(N+1)) + (rho_a()*(cs+1)*ts)/(2*(1-rho_a())) );
	 }
  }
  else
  {
	 if (rho_a() == 1.0) return ( 0 );
	 else
	 {
		return( (c_null*(1-rho_a()/N) + rho_a()*(cs+1)*ts) / (2*(1-rho_a())) );
	 }
  }
}

void abspeichern()
{
  datei = fopen(dateistr, "w+");
  if (datei == NULL) printf("\n Fehler beim oeffnen der Datei! \n");
  else
  {
    fprintf(datei,"Es gibt %d Stationen im Ring. Der TTRT = %g Sekunden. ", N, ttrt);
    fprintf(datei,"Gamma = %g \n\n", gamma);
    fprintf(datei,"rho    c [ms]     tw [ms]    throughput [Mbit]\n");
    for(int ii=0; ii<41; ii++)
    {
      rho = 0.0 + ii / 20.0;
      c   = getzykluszeit() * 1000.0;
      throughput = getthroughput();
      tw  = gettw() * 1000.0;
      fprintf(datei,"%3.2f   %7.6f   %8.6f   %6.3f\n", rho, c, tw, throughput);
    }
    fclose(datei);
  }
}

//--------------------------------------------------- Main -----------------
int main(int argc, char **argv)
{
  printf("Es gibt %d Stationen im Ring. Der TTRT = %g Sekunden. ", N, ttrt);
  gamma = getgamma();
  printf("Gamma = %g \n\n", gamma);
  printf("rho    c [ms]     tw [ms]    throughput [Mbit]\n");
  for(int ii=0; ii<21; ii++)
  {
	 rho = 0.0 + ii / 10.0;
	 c   = getzykluszeit() * 1000.0;
	 throughput = getthroughput();
	 tw  = gettw() * 1000.0;
	 printf("%3.2f   %7.6f   %8.6f   %6.3f\n", rho, c, tw, throughput);
  }

  if (argc == 2)
  {
    dateistr = argv[1];
    abspeichern();
  }

  stop = getchar();
}
