/* file: MIKE.PL {master file, loads the others} */
mike_version('1.40, 16th September, 1990.').
/*
                            *************
                               M I K E
                            *************
               Micro Interpreter for Knowledge Engineering
                  {written in Edinburgh-syntax Prolog}

MIKE: Copyright (c) 1989, 1990 The Open University (U.K.)

MIKE is intended for educational purposes, and may not
be sold as or incorporated in a commercial product without
written permission from: The Copyrights Officer, Open University,
Milton Keynes MK7 6AA, U.K.

The Open University accepts no responsibility for any legal or other
consequences which may arise directly or indirectly as a result of the
use of all or parts of the contents of this program.

This software accompanies Open University Study Pack PD624, 'KNOWLEDGE
ENGINEERING'.  Complete sets of study pack materials may be obtained from:

                      Learning Materials Sales Office
                      The Open University
                      P.O. Box 188
                      Milton Keynes MK7 6DH, U.K.

                      Tel: [+44] (908) 653338
                      Fax: [+44] (908) 653744
*/

/*
IT IS CRITICAL THAT THIS FILE (MIKE.PL) BE LOADED USING consult RATHER
THAN reconsult, I.E.   ?- consult('mike.pl').
ALL OTHER FILES SHOULD BE LOADED USING reconsult, AS DESCRIBED IN THE
PD624 (KNOWLEDGE ENGINEERING) COURSE TEXT. KNOWLEDGE BASES CAN OPTIONALLY BE
LOADED WITH THE MORE INFORMATIVE UTILITY kb, as in ?- kb 'flu.kb'.
THIS IS DESCRIBED IN THE FILE READ.ME.
*/

'Show Version' :- mike_version(Version), write('MIKE V'),write(Version).

commands :-
 writel([
 'COMMAND   EXAMPLE                    EXPLANATION'
,'add       add ''hi there''.            Adds string ''hi there'' to working mem.'
,'          add [jo,says,hi].          Adds the list [jo,says,hi] to working mem.'
,'browse    browse.                    Shows current frame hierarchy.'
,'          browse(person).            Shows frame hierarchy beneath person.'
,'deduce    deduce [Who,says,What].    Triggers backward chaining rules.'
,'describe  describe tom.              Displays details of frame called tom.'
,'          describe rule3.            Displays details of rule called rule3.'
,'fc        fc.                        Forward Chain (clears wm & runs rules).'
,'go        go.                        Like fc, but leaves current wm intact.'
,'kb        kb ''flu.kb''.               Loads new knowledge base (KILLS OLD!).'
,'note      note the age of tom is 34. Stores new slot-filler info in frame.'
,'remove    remove ''hi there''.         Removes string ''hi there'' from wm.'
,'show      show frames.               Displays currently loaded frames.'
,'          show history.              Displays history of rule execution.'
,'          show rules.                Displays names of loaded rules.'
,'          show wm.                   Displays contents of working memory.'
,'strategy  strategy menu.             Menu of 3 conflict resol''n strategies.'
,'          strategy [refractoriness]. Restricts conflict resolution strategy.'
,'tracing   tracing.                   Menu of numerous tracing options.'
,'          tracing(4).                Toggles option 4 between on and off.'
]).

/* COMPATIBILITY NOTE: next line not allowed in some dialects!!! */
help :- commands.

/* 2 options for loading MIKE: (a) modules (pre-tokenized & fast),
                               (b) sources
   The corresponding predicates which do the work are
                               (a) loadmikemodules
                               (b) loadmikesources
   Dialect-specific tests and loading facilities are commented below
*/

loadmikemodules :- /* See further 'COMPATIBILITY NOTE' at end of this file */
  lmm(readwrite), /* ESL Prolog-2-specific... assumes MIKE.PL is consulted */
  reconsult('loadops.pl'), /* operators are outside the scope of modules */
  reconsult('mike.ini'). /* You can alter MIKE.INI to load your own stuff */

/*
You may need to alter the lines which follow to refer to the appropriate
pathname, e.g.
    ?- reconsult('c:\mike\loadops.pl')
*/

loadmikesources :-
   write('Loading auxiliary MIKE files'),
   reconsult('loadops.pl'), write('.'),
   reconsult('engine1.pl'), write('.'),
   reconsult('engine2.pl'), write('.'),
   reconsult('fc_exec.pl'), write('.'),
   reconsult('io.pl'), write('.'),
   reconsult('util.pl'), write('.'),
   reconsult('findall.pl'), write('.'),
   reconsult('browse.pl'), write('.'),
   reconsult('mike.ini'), write('.'). /* Use MIKE.INI for your own stuff */

mikegreeting :-
   writel([nl,nl,nl,nl,nl,nl,nl,
'               MM          MM  II  KK        KK  EEEEEEEEEEE',
'               MMMM      MMMM  II  KK      KK    EE',
'               MM  MM  MM  MM  II  KK    KK      EE',
'               MM    MM    MM  II  KK  KK        EE',
'               MM          MM  II  KKKK          EEEEEE',
'               MM          MM  II  KK  KK        EE',
'               MM          MM  II  KK    KK      EE',
'               MM          MM  II  KK      KK    EE',
'               MM          MM  II  KK        KK  EEEEEEEEEEE',
' ',
'                Micro Interpreter for Knowledge Engineering',
'     from Open University Text/Video Study Pack PD624: KNOWLEDGE ENGINEERING',
' ',
'Copyright (C) 1990 The Open University, Milton Keynes, UK. Tel.+44 908 653338'
]),nl,
writel(['See MIKE.DOC for liability disclaimer, copyright notice, setup info.']),
    nl,
    'Show Version',
    nl,
    writel(['For quick summary, type','  ?- commands.']).

/* ---------------- COMPATIBILITY NOTE: ---------------------------------
   There are two options for loading MIKE: (a) modules; (b) sources.
   The test for the existence of (pre-tokenized, fast-loading) modules
   and the module-loading facility itself are both dialect-specific.

   The line of code which follows means:
     IF the file 'mike_mod.prm' exists in your current default directory,
     THEN load it using the ESL Prolog-2 module-loading facility,
     ELSE load the source code (invokes standard 'reconsult').
*/

?- (exists_file('mike_mod.prm'), loadmikemodules) ; loadmikesources.

/* If you want to load the source code using your own dialect of
   Prolog, simply get rid of the above test and just invoke
   ?- loadsources.
*/
?- mikegreeting.  /* Output the greeting info defined above */