/* file: IO.PL  {query, how, and why} */
/*                          *************
                               M I K E
                            *************
               Micro Interpreter for Knowledge Engineering
                  {written in Edinburgh-syntax Prolog}

MIKE: Copyright (c) 1989, 1990 The Open University (U.K.)

MIKE is intended for educational purposes, and may not
be sold as or incorporated in a commercial product without
written permission from: The Copyrights Officer, Open University,
Milton Keynes MK7 6AA, U.K.

The Open University accepts no responsibility for any legal or other
consequences which may arise directly or indirectly as a result of the
use of all or parts of the contents of this program.

This software accompanies Open University Study Pack PD624, 'KNOWLEDGE
ENGINEERING'.  Complete sets of study pack materials may be obtained from:

                      Learning Materials Sales Office
                      The Open University
                      P.O. Box 188
                      Milton Keynes MK7 6DH, U.K.

                      Tel: [+44] (908) 653338
                      Fax: [+44] (908) 653744
*/
/* This file handles Input/output from/to user via query, how, and why */

query Q receives_answer yes :-
  Q receives_answer no,!,fail.
query Q receives_answer no :-
  Q receives_answer yes,!,fail.

query Question receives_answer Answer :-
	Question receives_answer Answer,!.  /* don't ask same question twice*/
query the A of B receives_answer Answer :-
	the A of B is Answer receives_answer yes.

/* it is an implicit assumption that the answer is either yes or no */
query the Attr of Obj is Value receives_answer Answer:-
	var(Value),
	'pd624 write'(['Error: the Value facet must be bound in a question',nl,
		'of the form "the attribute of object is value".  If you ',nl,
		'actually want to find out the value then you must use the',
		nl,'question form "the attribute of object receives_answer value"',
		nl]),!,fail.
query the Attr of Obj is Value receives_answer Answer :-!,
	write('Is it the case that the '),write(Attr),write(' of '),
	write(Obj),write(' is '),write(Value),write('?'),nl,
	
write('Answer yes/no ==> '),
        'pd624 read'(the Attr of Obj is Value,Answer,X),nl,
	(standardise_answers(X,Answer); /* this will fail is answer is not
                                          yes or no */
	update_answers(the Attr of Obj is Value,X),fail),
	consistency_check(Obj,Attr,Value,Answer),
	update_answers(the Attr of Obj is Value, Answer).
query the Attr of Obj receives_answer Value :- !,
	write('What is the '),write(Attr),write(' of '),
        write(Obj),nl,write('==> '),'pd624 read'(the Attr of Obj,Value,Value1),
	Value = Value1,
	       store(Obj,Attr,Value),
	update_answers(the Attr of Obj, Value).

query  [H|T] receives_answer Whatever :- !,
	'pd624 pretty list'([H|T]),nl,
	yes_no_check([H|T],Whatever).
query Thing receives_answer Whatever :-
	write(Thing),nl,
	yes_no_check(Thing,Whatever).

yes_no_check(Thing,Answer):- (var(Answer); \+(Answer=yes),
        \+(Answer=no)),!, /* next two clauses thus disallowed */
	write(' ==> '),
	'pd624 read'(Thing,Answer,Answer),nl,
	update_answers(Thing,Answer).
	
yes_no_check(Thing,yes):- !,
	write('Answer yes/no ==> '),'pd624 read'(Thing,yes,X),nl,
	(standardise_answers(X,yes);
	update_answers(Thing,X),fail),
	chuck_it_out(Thing),
	assert(currentdb(Thing,true)),
	update_answers(Thing, yes).

yes_no_check(Thing,no):- !,
	write('Answer yes./no. ==> '),'pd624 read'(Thing,no,X),nl,
	(standardise_answers(X,no);
	update_answers(Thing,X),fail),
	assert(currentdb(Thing,false)),
	chuck_it_out(Thing),
	update_answers(Thing,no).

'pd624 read'(Thing,Input,Answer):-
	
        repeat_and_prompt,
        read(X),
	completion(Thing,Input,Answer,X),!.

repeat_and_prompt.
repeat_and_prompt:- nl, write('==> '), repeat_and_prompt.

completion(Thing,Input,Answer,why):-
	Thing explained_by Text,
	'pd624 write'(Text),nl,!,fail.
completion(Thing,Input,Answer,why):-
	write('Currently MIKE has no explanation.'),nl,!,fail.
completion(Thing,Input,Answer,how(Item)):-
 nonvar(Item),
	how Item,nl,!,fail.
completion(Thing,Input,Answer,how(_)):-
	write('MIKE is unable to justify the statement.'),nl,!,fail.
completion(Thing,Input,Answer,halt):- !,
	assert(currentdb(halt,true)).
completion(Thing,Input,Input,Input).
/* yes/no handling is special... user MUST type one of: [yes,y,no,n]
  or the system will complain.  query does the smart thing, i.e. if
  you answer any of the 4 legal choices, your response is asserted in
  the database (under 'receives_answer/2') to avoid asking dumb question
  more than once
*/

completion(Thing,yes,no,no).
completion(Thing,no,yes,yes).
completion(Thing,yes,yes,y).
completion(Thing,no,no,n).
/* next line means: 'For query Thing, you expected a 'yes', but
   you treat it as a 'no' because the user typed in 'n'. */
completion(Thing,yes,no,n).
completion(Thing,no,yes,y).
completion(Thing,Input,X,Y):-
 (Input = yes;Input = no), 'pd624 write'(
   ['ERROR: ',Y,' is an illegal response.',nl,
   'Answer yes. or no. ',nl]),!,fail.
completion(Thing,Input,X,X):- !.

	
update_answers(the A of B,Answer):- \+(B = (C is D)),  /* loop detector */
	update_answers(the A of B is Answer,yes).
update_answers(Thing,Answer):-
	Thing receives_answer Answer1,
	\+ Answer1 = Answer, !,
	write('Warning overwriting existing answer'),nl,write(Thing),
	write(' receives_answer '),write(Answer1),write(' with '),
	nl,write(Thing),write(' receives_answer '),write(Answer),nl,
	retract(Thing receives_answer Answer1),
	assert(Thing receives_answer Answer).
update_answers(T,A):- T receives_answer A,!.
update_answers(T,A):-
	assert(T receives_answer A), !.

how Thing:- 	justification(Thing,Rule,Conditions),
	write(Thing),write(' was concluded from '),write(Rule),nl,
	write('with the following premises '),nl,tab11_write(Conditions),nl.

why X:-
        X explained_by Text,
        'pd624 write'(Text).

chuck_it_out(Thing):-
	retract(currentdb(Thing,Truth)).
chuck_it_out(_). /* or rather not in this case! */

consistency_check(Obj,Attr,Value,no). /* don't record something that's not
					the case */
consistency_check(Obj,Attr,Value,Answer):-
	fetch(Obj,Attr,Value1,[Obj],_),
	(Value1 = Value;
	writel(['Warning: in the knowledge-base is the information that',
		Attr,' of ',Obj,' is ',Value1,nl,
		'However this is going to be overwritten by the following',nl,
                Attr,' of ',Obj,' is ',Value,nl]),
        store(Obj,Attr,Value)).
consistency_check(A,B,C,_):-store(A,B,C).

/* positive answers and translation */
standardise_answers(yes,yes).
standardise_answers(y,yes).
standardise_answers(ok,yes).
standardise_answers(true,yes).
standardise_answers(ye,yes).  /* fake escape recognition!!! */

/* negative answers and their translation */
standardise_answers(no,no).
standardise_answers(n,no).
standardise_answers(false,no).


/* enforce unbound answers to right-hand-side queries */
answer_vetting(C):-
                   var(C),!.
answer_vetting(_):-
  'pd624 write'(['Warning : you should not specify answers to forward',nl,
   'chaining queries.',nl]),!.  /* the cut protects 'pd624 write'!!!! */
