/* file: FINDALL.PL {hand-coded findall} */
/*                          *************
                               M I K E
                            *************
               Micro Interpreter for Knowledge Engineering
                  {written in Edinburgh-syntax Prolog}

MIKE: Copyright (c) 1989, 1990 The Open University (U.K.)

MIKE is intended for educational purposes, and may not
be sold as or incorporated in a commercial product without
written permission from: The Copyrights Officer, Open University,
Milton Keynes MK7 6AA, U.K.

The Open University accepts no responsibility for any legal or other
consequences which may arise directly or indirectly as a result of the
use of all or parts of the contents of this program.

This software accompanies Open University Study Pack PD624, 'KNOWLEDGE
ENGINEERING'.  Complete sets of study pack materials may be obtained from:

                      Learning Materials Sales Office
                      The Open University
                      P.O. Box 188
                      Milton Keynes MK7 6DH, U.K.

                      Tel: [+44] (908) 653338
                      Fax: [+44] (908) 653744
*/
/* findall/3 is not provided as a system primitive in some dialects,
   so this file contains a hand-coded definition.

   findall1/3 is the analogous, except duplicates are removed
*/

/* unique stack-markers are needed in case you nest findall within findall */

unique_pd624_symbol(sym1).
unique_pd624_symbol(sym2).
unique_pd624_symbol(sym3).
unique_pd624_symbol(sym4).
unique_pd624_symbol(sym5).
unique_pd624_symbol(sym6).
unique_pd624_symbol(sym7).
unique_pd624_symbol(sym8).
unique_pd624_symbol(sym9).
unique_pd624_symbol(sym10).
unique_pd624_symbol(sym11).
unique_pd624_symbol(sym12).
unique_pd624_symbol(sym13).
unique_pd624_symbol(sym14).
unique_pd624_symbol(sym15).
unique_pd624_symbol(sym16).
unique_pd624_symbol(sym17).
unique_pd624_symbol(sym18).
unique_pd624_symbol(sym19).
unique_pd624_symbol(sym20).



findall(X, Goal, Xlist) :-
    retract(unique_pd624_symbol(Sym)),
    !,
    (call(Goal),
    assertz(stack(Sym,X)),
    fail;
    assertz(stack(Sym,bottom))),
    collect(Sym,Xlist),
    assert(unique_pd624_symbol(Sym)).

findall1(X, Goal, Xlist) :-
    retract(unique_pd624_symbol(Sym)),
    !,
    (call(Goal),
    do_just_once((stack(Sym,X);assertz(stack(Sym,X)))),
    fail;
    assertz(stack(Sym,bottom))),
    collect(Sym,Xlist),
    assert(unique_pd624_symbol(Sym)).

collect(Sym,L) :-
    retract(stack(Sym,X)), !,
    (X == bottom, !, L = [];
    L = [X | Rest], collect(Sym,Rest)).
