/* file: BROWSE.PL {hierarchical frame browsing utility} */
/*                          *************
                               M I K E
                            *************
               Micro Interpreter for Knowledge Engineering
                  {written in Edinburgh-syntax Prolog}

MIKE: Copyright (c) 1989, 1990 The Open University (U.K.)

MIKE is intended for educational purposes, and may not
be sold as or incorporated in a commercial product without
written permission from: The Copyrights Officer, Open University,
Milton Keynes MK7 6AA, U.K.

The Open University accepts no responsibility for any legal or other
consequences which may arise directly or indirectly as a result of the
use of all or parts of the contents of this program.

This software accompanies Open University Study Pack PD624, 'KNOWLEDGE
ENGINEERING'.  Complete sets of study pack materials may be obtained from:

                      Learning Materials Sales Office
                      The Open University
                      P.O. Box 188
                      Milton Keynes MK7 6DH, U.K.

                      Tel: [+44] (908) 653338
                      Fax: [+44] (908) 653744
*/
/*
A hierarchical frame browsing utility, that shows graphically your frame
hierarchy.  It is more fully documented in the accompanying READ.ME file */

browse :-   /* PATCH 19 JAN: Z^ & Z1^ critical (_ nogood in some Prologs) */
 'pd624 setof1'(X, Y^Z^(Y subclass_of X, not(X subclass_of Z)), RootNodes1),
 'pd624 setof1'(X1, Y1^Z1^(Y1 instance_of X1,         /* PATCH 16 JAN '90 */
                        not(X1 subclass_of Z1),
                        not('pd624 member'(X1,RootNodes1))
                       ),
               RootNodes2),
/*  findall(Obj, Obj instance_of 'Newly Created Object', Loners), */
  append(RootNodes1,RootNodes2,RootNodes),
/*  append(Loners, RootNodes, AllRootNodes), */
  treewrite(RootNodes, 0).    /* PATCH 20 JAN '90: 2nd setof finds NCO */

browse(N) :-
  treewrite([N], 0).

treewrite([], _).
treewrite([X|Xs], Indentation) :-
   nl, tab(Indentation), write(X),
   get_children(X, Kids),
   NewIndent is Indentation + 2,
   treewrite(Kids, NewIndent),
   treewrite(Xs, Indentation).

get_children(Node, Kids) :-
        findall(X, X subclass_of Node, Group1),
        findall(Y, Y instance_of Node, Group2),
        append(Group1, Group2, Kids).

'pd624 setof1'(Var, Goals, Ans) :-  /* PATCH 16 JAN 90 */
         setof(Var, Goals, Ans),
         !.
'pd624 setof1'(_,_,[]).

/* KB LOADING UTILITY */
/* New with version 1.3 */

'banner line' :-
  nl,
  write('------------------------------------------------------------------'),
  nl.

kb X :-  /* load new knowledge base and print out summary information */
    initialise,       /* clear up working memory and various flags */
    fc_reset_history, /* clear up forward-chaining history storage */
    abolish(rule,1),  /* get rid of any current rules */
    abolish(with, 2), /* get rid of any current frames */
    reconsult(X),     /* if file/pathname is wrong, reconsult complains */
    /* the above line overwrites old frames and rules, but the preceding
       calls of 'abolish' are necessary in case the new file happens
       not to have one or the other (i.e. frames or rules) within it */
    write('New knowledge base loaded.'),'banner line',
    write('Currently loaded frames (?- describe <frame>. for details):'),
    nl,browse,'banner line',
    show(rules),'banner line',
    current_conflict_resolution_strategy(Strategy),
    write('The current conflict resolution priority list (in order) is:'),nl,
    write('     '), write(Strategy), 'banner line',
    show(wm), 'banner line'.
