/*
 * Useful CLIPS functions declared for C++
 *
 */

#ifndef clipscpp
#define clipscpp

struct dataObject;

// #define CLIPS6

#if (!defined(CLIPS5) && !defined(CLIPS6))
#define CLIPS5
#endif

#ifndef WXCLIPS
#define WXCLIPS
#endif

extern "C" {
int CLIPSFunctionCall(char *, char *, struct dataObject *);

#ifdef CLIPS6
Bool AddRouter(char *,int,int (*)(char *),
               int (*)(char *,char *),
               int (*)(char *),
               int (*)(int,char *),
               int (*)(int));
#else
Bool AddRouter(char *,int,int (*)(),int (*)(),int (*)(),int (*)(),int (*)());
#endif
void *AddSymbol(char *s);
int  ArgCountCheck(char *, int, int);
void *AssertString(char *);
int  Bload(char *);
int  Bsave(char *);
void *CreateMultifield(int);
int  DefineFunction(char *, int, int (*)(), char *);
int  DefineFunction2(char *, int, int (*)(), char *, char *); // added by Bob Orchard
void ExecuteBatchFile(char *); // Added by JACS
char *GetDefruleName(void *);
void *GetNextDefrule(void *);
void *FindDefrule(char *);
void InitializeCLIPS(void);

#ifdef CLIPS6
void SetBreak(void *);
// int  AddRunFunction (char *, auto void (*)(), int);           //needs fixing for 6 RHW
int  AddRunFunction (char *, void (*)(), int);           //needs fixing for 6 RHW
void Clear(void);
void ListDeffacts (char *, void *);             //modified for 6 RobW
void ShowBreaks(char *, void *);              //replaces listbreakpoints for 6 RobW
void ListDefrules (char *, void *);             //modified for 6 RobW
void Agenda(char *logicalName, void *theModule); //added for 6 RobW
void ListDeftemplates (char *, void *);         //modified for 6 RobW
void ListDefglobals (char *, void *);           //modified for 6 RobW
int  Load(char *);                               // modified for 6 RobW 
int  RemoveBreak(void *);                       //modified for 6 by RobW
long int  Run (long int);                           //modified of 6.  RHW
int  Save(char *);                                  //replaces saveconstructs RW.
int Watch (char *);          // added (replacing setwatch and addwatch. RobW
int Unwatch (char *);       // added (replacing setwatch and addwatch. RobW
void Reset(void);
#else
void AddBreakpoint(void *);
int  AddRunFunction(char *, int (*)(), int);
int  AddWatchItem(char *item, int *flag, int priority);
void ClearCLIPS(void);
void ListBreakpoints(void);
void ListDeffacts(void);
void ListDefrules(void);
void ListAgenda(void);
void ListDeftemplates(void);
void ListDefglobals(void);
int  LoadConstructs(char *);
int  RemoveBreakpoint(void *);
void RunCLIPS(int);
int  SaveConstructs(char *);
int  SetWatchItem(char *item, Bool activate);
void ResetCLIPS(void);
#endif

int  ListMatches(void *);
int  OpenBatch(char *, int);
void PeriodicCleanup(Bool cleanupAllDepths,Bool useHeuristics);
int  PrintCLIPS(char *, char *);

Bool RouteCommand(char *);
int  RtnArgCount();
double RtnDouble(int);
char *RtnLexeme(int);
long RtnLong(int);
struct dataObject *RtnUnknown(int, dataObject *);
void SetMultifieldErrorValue(dataObject *);
void SetPrintWhileLoading(Bool);
void UserFunctions(void);

#ifdef wx_msw
#ifndef WIN32
int  system(char *);
#endif
#endif


}

#ifdef CLIPS6
#define RunCLIPS(x) Run(x)
#define LoadConstructs(x) Load(x)
#define RemoveBreakpoint(x) RemoveBreak(x)
#define AddBreakpoint(x) SetBreak(x)
#define ListBreakpoints() ShowBreaks("stdout",NULL)
#define SaveConstructs(x) Save(x)
#define ListAgenda() Agenda("stdout",NULL)
#define ClearCLIPS() Clear()
#endif

#endif // clipscpp
