;;; Shows how a frame may be created, with a menu bar and
;;; panel, using low-level windows functions.
;;; Load using -clips <file> on the command line or using the Batch
;;; or Load commands from the CLIPS development window; type
;;; (app-on-init) to start.

;;; Sizing callback
(deffunction my-on-size (?id ?w ?h)
 (format t "Got an OnSize message for frame or dialog %d, size (%d, %d).%n" ?id ?w ?h)
)

(deffunction on-close (?frame)
 (format t "Closing frame.%n")
 1)

(deffunction on-menu-command (?frame ?id)
 (format t "Got menu command %d.%n" ?id)
 (if (eq ?id 200) 
  then (message-box "CLIPS for wxWindows Demo
by Julian Smart (c) 1993" "About wxWindows CLIPS Demo")
  else (if (eq ?id 3) then (window-delete ?frame)))
 )

;;; Button callback
(deffunction frame-button-proc (?id)
 (bind ?parent (window-get-parent ?id))
 (bind ?grandparent (window-get-parent ?parent))
 (format t "Pressed button %d%n" ?id)
 (window-show ?grandparent 0)
 (window-delete ?grandparent)
)

;;; Test program to create a frame
(deffunction app-on-init ()
  (bind ?frame (frame-create 0 "My frame" -1 -1 550 400))
;  (window-add-callback ?frame OnSize my-on-size)
  (window-add-callback ?frame OnClose on-close)
  (window-add-callback ?frame OnMenuCommand on-menu-command)

  ;;; Make a menu bar
  (bind ?file-menu (menu-create))
  (menu-append ?file-menu 1 "&Load file")

  (bind ?pull-right (menu-create))
  (menu-append ?pull-right 100 "&Twips")
  (menu-append ?pull-right 101 "&10th mm")

  (menu-append ?file-menu 2 "&Scale picture" ?pull-right)
  (menu-append-separator ?file-menu)
  (menu-append ?file-menu 3 "&Quit")

  (bind ?help-menu (menu-create))
  (menu-append ?help-menu 200 "&About")

  (bind ?menu-bar (menu-bar-create))
  (menu-bar-append ?menu-bar ?file-menu "&File")
  (menu-bar-append ?menu-bar ?help-menu "&Help")

  (frame-set-menu-bar ?frame ?menu-bar)

  ;;; Make a panel and panel items

  (bind ?panel (panel-create ?frame))

  (bind ?button (button-create ?panel frame-button-proc "A button"))
  (bind ?text (text-create ?panel "" "A text item" "Initial value" -1 -1 200))
  (bind ?check (check-box-create ?panel "" "A check box"))

  (panel-new-line ?panel)

  (bind ?choice (choice-create ?panel "" "A choice item"))
  (choice-append ?choice "One")
  (choice-append ?choice "Two")
  (choice-append ?choice "Three")
  (choice-append ?choice "Four")

  (message-create ?panel "Hello! A simple message")

  (bind ?list (list-box-create ?panel "" "A list" 0 -1 -1 100 100))
  (list-box-append ?list "Apple")
  (list-box-append ?list "Pear")
  (list-box-append ?list "Orange")
  (list-box-append ?list "Banana")
  (list-box-append ?list "Fruit")

  (panel-new-line ?panel)

  (bind ?slider (slider-create ?panel "" "A slider" 40 22 101 150))

  (bind ?multi (multi-text-create ?panel "" "Multiline text" "Some text"))

  (window-show ?frame 1)

  ?frame)

