/*
 * wx_cmds.h
 * Command processing
 *
 */

#ifndef cmdsh
#define cmdsh

#if (defined(HARDY_CLIPS) || defined(WXCLIPS) || defined(CLIPS5) || defined(CLIPS6) || defined(CLIPS))
#define USE_CLIPS
#endif

#ifdef USE_CLIPS
#include "clipscpp.h"
#else
#include "clipslib.h"
#endif

class ClipsErrorClass
{
  public:
    ClipsErrorClass(void) { }
    ~ClipsErrorClass(void) { }

   ClipsErrorClass& operator << (char *s);
   ClipsErrorClass& operator << (char c);
   ClipsErrorClass& operator << (int i);
   ClipsErrorClass& operator << (long i);
   ClipsErrorClass& operator << (double d);
   ClipsErrorClass& operator << (float f);
};

extern ClipsErrorClass ClipsError;

// Must be defined by user of library
extern void ClipsErrorFunction(char *s);

#ifdef USE_CLIPS
void wxExecuteClipsFile(char *filename);
void wxUserFunctions();
void wxInitClips(void);
#endif

#define clipsUNKNOWN 0
#define clipsSTRING  1
#define clipsDOUBLE  2
#define clipsLONG    3
#define clipsVOID    4

extern int clipsReturnType;
extern char *clipsReturnString;
extern long clipsReturnLong;
extern double clipsReturnDouble;
 
#ifdef USE_CLIPS
#define wxClipsFunction char *
#else
typedef void (*wxClipsFunction) (void);
#endif

/*
 * Command prototypes
 *
 */

char *wxcGetPlatform(void);
void wxcCleanWindows(void);
long wxcWindowDelete(long id);
long wxcWindowShow(long id, Bool show = TRUE);
long wxcWindowGetParent(long id);
long wxcWindowAddCallback(long id, char *event_type, wxClipsFunction callback);
long wxcWindowGetWidth(long id);
long wxcWindowGetHeight(long id);
long wxcWindowGetClientWidth(long id);
long wxcWindowGetClientHeight(long id);
long wxcWindowGetX(long id);
long wxcWindowGetY(long id);
long wxcWindowSetSize(long id, long x, long y, long w, long h);
long wxcWindowSetClientSize(long id, long w, long h);
long wxcWindowSetFocus(long id);
long wxcWindowFit(long id);
long wxcWindowCentre(long id, char *stringDir = "wxBOTH");
long wxcPanelItemSetDefault(long id);
long wxcPanelItemSetLabel(long id, char *label);
char *wxcPanelItemGetLabel(long id);
long wxcDialogBoxCreate(long parent_id, char *title, long modal = FALSE,
  long x = -1, long y = -1, long width = -1, long height = -1, char *style = "wxABSOLUTE_POSITIONING | wxCAPTION | wxSYSTEM_MENU | wxTHICK_FRAME");
// Create a new panel
long wxcPanelCreate(long parent_id, long x = -1, long y = -1, long width = -1, long height = -1, char *style = "wxABSOLUTE_POSITIONING");
// Set the label position
long wxcPanelSetLabelPosition(long id, char *position);
long wxcPanelSetLabelFont(long id, long fontId);
long wxcPanelSetButtonFont(long id, long fontId);
long wxcPanelNewLine(long id);
long wxcCanvasCreate(long parent_id, long x = -1, long y = -1, long width = -1, long height = -1, char *style = "wxRETAINED");
long wxcCanvasSetScrollbars(long id, long horiz, long vert,
  long x_length, long y_length, long x_page, long y_page);
long wxcCanvasScroll(long id, long x_pos, long y_pos);
long wxcCanvasGetDC(long id);
long wxcDCSetPen(long id, long penId);
long wxcDCSetBrush(long id, long brushId);
long wxcDCSetFont(long id, long fontId);
long wxcDCSetTextForeground(long id, char *colour);
long wxcDCSetTextBackground(long id, char *colour);
long wxcDCSetLogicalFunction(long id, char *op);
long wxcDCBlit(long id, float xdest, float ydest, float width, float height, long sourceId,
  float xsrc, float ysrc, char *logicalFuncString);
long wxcDCDrawLine(long id, float x1, float y1, float x2, float y2);
long wxcDCDrawPoint(long id, float x1, float y1);
long wxcDCDrawRectangle(long id, float x1, float y1, float x2, float y2);
long wxcDCDrawRoundedRectangle(long id, float x1, float y1, float x2, float y2,
  float radius = 20);
long wxcDCDrawEllipse(long id, float x, float y, float width, float height);
long wxcDCDrawText(long id, char *text, float x1, float y1);
long wxcDCSetClippingRegion(long id, float x1, float y1, float x2, float y2);
long wxcDCDestroyClippingRegion(long id);
long wxcDCClear(long id);
long wxcMemoryDCCreate(void);
long wxcMemoryDCDelete(long id);
long wxcMemoryDCSelectObject(long id, long bitmapId);
long wxcPenCreate(char *colour, long width, char *style = "wxSOLID");
long wxcPenDelete(long id);
long wxcBrushCreate(char *colour, char *style = "wxSOLID");
long wxcBrushDelete(long id);
long wxcFontCreate(long pointSize, char *family, char *style, char *weight,
  long underlined = 0);
long wxcFontDelete(long id);
long wxcBitmapCreate(int width, int height, int depth = -1);
long wxcBitmapDelete(long id);
long wxcBitmapLoadFromFile(char *file);
long wxcBitmapGetWidth(long id);
long wxcBitmapGetHeight(long id);
long wxcIconCreate(char *file);
long wxcIconLoadFromFile(char *file);
long wxcIconDelete(long id);
long wxcIconGetWidth(long id);
long wxcIconGetHeight(long id);
long wxcMouseEventIsButton(long id);
long wxcMouseEventButtonDown(long id);
long wxcMouseEventControlDown(long id);
long wxcMouseEventShiftDown(long id);
long wxcMouseEventButton(long id, long butt);
long wxcMouseEventLeftDown(long id);
long wxcMouseEventMiddleDown(long id);
long wxcMouseEventRightDown(long id);
long wxcMouseEventLeftUp(long id);
long wxcMouseEventMiddleUp(long id);
long wxcMouseEventRightUp(long id);
long wxcMouseEventDragging(long id);
double wxcMouseEventPositionX(long id);
double wxcMouseEventPositionY(long id);
long wxcTextWindowCreate(long parent_id, long x = -1, long y = -1, long width = -1, long height = -1,
  char *style = "");
long wxcTextWindowLoadFile(long id, char *filename);
long wxcTextWindowSaveFile(long id, char *filename);
void wxcTextWindowWrite(long id, long val);
void wxcTextWindowWrite(long id, char *val);
void wxcTextWindowWrite(long id, double val);
long wxcTextWindowModified(long id);
long wxcTextWindowClear(long id);
void wxcTextWindowDiscardEdits(long id);
long wxcButtonCreate(long parent_id, wxClipsFunction func, char *label,
  long x = -1, long y = -1, long width = -1, long height = -1, char *style = "");
long wxcButtonCreateFromBitmap(long parent_id, wxClipsFunction func, long bitmapId,
  long x = -1, long y = -1, long width = -1, long height = -1, char *style = "");
long wxcTextCreate(long parent_id, wxClipsFunction func, char *label, char *value = "",
  int x = -1, int y = -1, int width = -1, int height = -1, char *style = "");
long wxcTextSetValue(long id, char *val);
char *wxcTextGetValue(long id);
long wxcMultiTextCreate(long parent_id, wxClipsFunction func, char *label, char *value = "",
  long x = -1, long y = -1, long width = -1, long height = -1, char *style = "");
long wxcMultiTextSetValue(long id, char *val);
char *wxcMultiTextGetValue(long id);
long wxcCheckBoxCreate(long parent_id, wxClipsFunction func, char *label,
  long x = -1, long y = -1, long width = -1, long height = -1, char *style = "");
long wxcCheckBoxSetValue(long id, long val);
long wxcCheckBoxGetValue(long id);
long wxcSliderCreate(long parent_id, wxClipsFunction func, char *label,
  long value, long min_value, long max_value, long width, long x = -1, long y = -1,
  char *style = "");
long wxcSliderSetValue(long id, long val);
long wxcSliderGetValue(long id);
long wxcMessageCreate(long parent_id, char *label, long x = -1, long y = -1, char *style = "");
long wxcListBoxCreate(long parent_id, wxClipsFunction func, char *label, long multiple = 0,
  long x = -1, long y = -1, long width = -1, long height = -1, char *style = "");
long wxcListBoxAppend(long id, char *item_string, char *client_data = NULL);
long wxcListBoxFindString(long id, char *item_string);
long wxcListBoxClear(long id);
long wxcListBoxSetSelection(long id, long sel);
long wxcListBoxDeselect(long id, long sel);
long wxcListBoxGetSelection(long id);
char *wxcListBoxGetStringSelection(long id);
long wxcListBoxSetStringSelection(long id, char *sel);
long wxcListBoxNumber(long id);
long wxcListBoxDelete(long id, long n);
char *wxcListBoxGetClientData(long id, long sel);
char *wxcListBoxGetString(long id, long sel);
long wxcListBoxGetFirstSelection(long id);
long wxcListBoxGetNextSelection(void);
long wxcChoiceCreate(long parent_id, wxClipsFunction func, char *label, long x = -1, long y = -1,
  long width = -1, long height = -1, char *style = "");
long wxcChoiceAppend(long id, char *item_string);
long wxcChoiceFindString(long id, char *item_string);
long wxcChoiceClear(long id);
long wxcChoiceSetSelection(long id, long sel);
long wxcChoiceGetSelection(long id);
char *wxcChoiceGetStringSelection(long id);
long wxcChoiceSetStringSelection(long id, char *sel);
char *wxcChoiceGetString(long id, long sel);
long wxcMenuCreate(char *title = NULL);
long wxcMenuAppend(long id, long item_id, char *menu_string, long submenu_id = -1);
long wxcMenuAppendSeparator(long id);
long wxcMenuEnable(long id, long item_id, long enabled);
long wxcMenuCheck(long id, long item_id, long checked);
long wxcMenuBarCreate(void);
long wxcMenuBarAppend(long id, long menu_id, char *menu_string);
long wxcMenuBarEnable(long id, long item_id, long enabled);
long wxcMenuBarCheck(long id, long item_id, long checked);
long wxcFrameCreate(long parent_id, char *title, long x = -1, long y = -1,
  long width = -1, long height = -1, char *style = "wxDEFAULT_FRAME");
long wxcFrameSetMenuBar(long id, long menubar_id);
long wxcFrameCreateStatusLine(long id);
long wxcFrameSetStatusText(long id, char *text);
long wxcFrameSetIcon(long id, long iconId);
long wxcFrameIconize(long id, long iconize = 1);
char *wxcGetTextFromUser(char *message = "Enter a string", char *default_string = "",
  long centre = 1);
double wxcStringToFloat(char *str);
long wxcStringToLong(char *str);
char *wxcFloatToString(double l);
char *wxcLongToString(long l);
char *wxcStringToSymbol(char *s);
char *wxcSymbolToString(char *s);
char *wxcMessageBox(char *message, char *flags = "OK", long centre = 1, long parentId = 0);
char *wxcFileSelector(char *message = "Select a file",
  char *def_path = NULL, char *def_file = NULL, char *def_ext = NULL,
  char *def_wildcard = "*.*", long parentId = 0);
#ifndef USE_CLIPS
char *wxcGetChoice(char *message, ClipsExpr& choices, long centre = TRUE, long parentId = 0);
#endif
long wxcYield(void);
long wxcSleep(long nSecs);

// Utility functions
wxObject *wxGetTypedObject(long objectId, WXTYPE expectedType);
void wxStoreThingInTable(long item_id, wxObject *object, WXTYPE type);
void wxDeleteThingInTable(long item_id);
wxObject *wxGetThingFromTable(long item_id, WXTYPE *type);
long wxClipsParseBitList(char *bitListString);
void wxCleanWindows(void);

#endif // cmdsh
