/*
 * wxclips.h
 *
 * CLIPS stuff
 *
 */

#ifndef wxclipsh
#define wxclipsh

// Define a new application
class MyApp: public wxApp
{
  public:
    wxFrame *OnInit(void);
};

// Define a new frame
class wxClipsEnvFrame: public wxFrame
{
  public:
    wxPanel *panel;
    wxText *command_line;
    wxTextWindow *text_window;
    wxClipsEnvFrame(wxFrame *frame, char *title, int x, int y, int w, int h);
    ~wxClipsEnvFrame(void);
    void OnSize(int w, int h);
    Bool OnClose(void);
    void OnMenuCommand(int id);
    char *PromptForRuleName(void);
};

// Callbacks
void EnterCommand(wxButton& but, wxCommandEvent& event);
void GenericOk(wxButton& but, wxCommandEvent& event);

// My I/O Routers

extern "C" int DummyGetc(char *c);
extern "C" int DummyUngetc(int i, char *c);
extern "C" int FindOutput(char *name);
extern "C" int PrintOutput(char *name, char *str);
extern "C" int ExitOutput(int exitcode);
extern "C" int ClipsYield(void);

// File menu
#define WXCLIPS_LOAD			  1
#define WXCLIPS_SAVE			  2
#define WXCLIPS_BLOAD			  3
#define WXCLIPS_BSAVE			  4
#define WXCLIPS_QUIT			  5
#define WXCLIPS_BATCH                     6

// Rules menu
#define WXCLIPS_RESETRUN		  20
#define WXCLIPS_RUN 			  21
#define WXCLIPS_RUN_LIMIT		  22
#define WXCLIPS_RESET			  23
#define WXCLIPS_CLEAR			  24
#define WXCLIPS_WATCHES 		  26
#define WXCLIPS_ADD_BREAKPOINT	  27
#define WXCLIPS_REMOVE_BREAKPOINT 28
#define WXCLIPS_SET_STRATEGY	  29
#define WXCLIPS_ASSERT_FACT 	  30

// Application menu
#define WXCLIPS_RUN_APP           40
#define WXCLIPS_CLEAN_WINDOWS     41

// List menu
#define WXCLIPS_LIST_AGENDA 	  50
#define WXCLIPS_LIST_RULES	  51
#define WXCLIPS_LIST_FACTS	  52
#define WXCLIPS_LIST_MATCHES	  53
#define WXCLIPS_LIST_BREAKPOINTS  54
#define WXCLIPS_LIST_TEMPLATES	  55
#define WXCLIPS_LIST_GLOBALS	  56
#define WXCLIPS_LIST_STRATEGY	  57
#define WXCLIPS_CLEAR_SCREEN      58

// Help menu
#define WXCLIPS_ABOUT             70
#define WXCLIPS_REFERENCE         72

void wxShowClipsWindow(void);
void wxDeleteClipsWindow(void);
void wxInitializeClips(void);
wxFrame *wxStartApp(void);

#endif // wxclipsh
