   /*******************************************************/
   /*      "C" Language Integrated Production System      */
   /*                                                     */
   /*                  A Product Of The                   */
   /*             Software Technology Branch              */
   /*             NASA - Johnson Space Center             */
   /*                                                     */
   /*             CLIPS Version 5.10  07/17/91            */
   /*                                                     */
   /*               EXPRESSION HEADER FILE                */
   /*******************************************************/

/*************************************************************/
/* Purpose:                                                  */
/*                                                           */
/* Principal Programmer(s):                                  */
/*      Gary D. Riley                                        */
/*                                                           */
/* Contributing Programmer(s):                               */
/*                                                           */
/* Revision History:                                         */
/*                                                           */
/*************************************************************/

#ifndef _H_expressn

#define _H_expressn

/************************************************************/
/* EXPRESSION STRUCTURE:                                    */
/************************************************************/

struct expr;

#include "symbol.h"

struct expr 
   {
    int type;
    VOID *value;
    struct expr *arg_list;
    struct expr *next_arg;
   };
 
typedef struct expr EXPRESSION;

/************************************************************************/
/* FunctionDefinition Structure:  Stores information about user and     */
/*   system defined functions.                                          */
/*                                                                      */                     
/* callFunctionName:    The name by which CLIPS refers to the function. */
/* actualFunctionName:  The actual name of the user defined C function. */
/* returnValueType:     The return value type of the function. Legal    */
/*                      values are i, f, s, w, c, v, m, and u.          */
/* functionPointer:     A pointer to the user defined C function.       */
/* next:                A pointer to the next function definition.      */
/************************************************************************/
struct FunctionDefinition
  {
   struct symbolHashNode *callFunctionName;
   char *actualFunctionName; 
   char returnValueType;  
   int (*functionPointer)(VOID_ARG);
#if ANSI_COMPILER
   struct expr *(*parser)(struct expr *,char *);
#else
   struct expr *(*parser)();
#endif
   short int bsaveIndex;
   struct FunctionDefinition *next;
  };

#define ExpressionFunctionType(target) (((struct FunctionDefinition *) ((target)->value))->returnValueType)
#define ExpressionFunctionPointer(target) (((struct FunctionDefinition *) ((target)->value))->functionPointer)
#define ExpressionFunctionCallName(target) (((struct FunctionDefinition *) ((target)->value))->callFunctionName)
#define ExpressionFunctionRealName(target) (((struct FunctionDefinition *) ((target)->value))->actualFunctionName)

#define PTIF (int (*)())

/*************************/
/* Type and Value Macros */
/*************************/

#define GetType(target)         ((target).type) 
#define GetpType(target)        ((target)->type) 
#define SetType(target,val)     ((target).type = (val)) 
#define SetpType(target,val)    ((target)->type = (val))

/* JACS */
#define ClipsGetValue(target)        ((target).value)
#define GetpValue(target)       ((target)->value) 
#define ClipsSetValue(target,val)    ((target).value = (VOID *) (val))
#define SetpValue(target,val)   ((target)->value = (VOID *) (val)) 

/*==========================================================*/
/* Macros for accessing expressions directly with EXPR_PTR. */
/*==========================================================*/

typedef struct expr * EXPR_PTR;
   
#ifdef LOCALE
#undef LOCALE
#endif

#ifdef _EXPRESSN_SOURCE_
#define LOCALE
#else
#define LOCALE extern
#endif

#if ANSI_COMPILER
   LOCALE struct expr                   *Function0Parse(char *);
   LOCALE struct expr                   *Function1Parse(char *);
   LOCALE struct expr                   *Function2Parse(char *,char *);
   LOCALE struct expr                   *CollectArguments(struct expr *,char *);
   LOCALE struct expr                   *ArgumentParse(char *,int *);
   LOCALE BOOLEAN                        ConstantExpression(struct expr *);
   LOCALE VOID                           ReturnExpression(struct expr *);
   LOCALE VOID                           PrintExpression(char *,struct expr *);
   LOCALE VOID                           ExpressionInstall(struct expr *);
   LOCALE VOID                           ExpressionDeinstall(struct expr *);
   LOCALE int                            AddFunctionParser(char *,struct expr *(*)());
   LOCALE int                            RemoveFunctionParser(char *);
   LOCALE struct expr                   *CopyExpression(struct expr *);
   LOCALE struct expr                   *PackExpression(struct expr *);
   LOCALE int                            ListToPacked(struct expr *,struct expr *,int);
   LOCALE VOID                           ReturnPackedExpression(struct expr *);
   LOCALE int                            ExpressionSize(struct expr *);
   LOCALE int                            CountArguments(struct expr *);
   LOCALE BOOLEAN                        ExpressionContainsVariables(struct expr *,int);
   LOCALE BOOLEAN                        IdenticalExpression(struct expr *,struct expr *);
   LOCALE struct expr                   *ParseAtomOrExpression(char *);
   LOCALE struct FunctionDefinition     *GetFunctionList(void);
   LOCALE VOID                           SetFunctionList(struct FunctionDefinition *);
   LOCALE VOID                           InstallFunctionList(struct FunctionDefinition *);
   LOCALE struct FunctionDefinition     *FindFunction(char *);
   LOCALE VOID                           AddHashFunction(struct FunctionDefinition *);
   LOCALE EXPRESSION                    *ParseConstantArguments(char *,int *);
#else
   LOCALE struct expr                   *Function0Parse();
   LOCALE struct expr                   *Function1Parse();
   LOCALE struct expr                   *Function2Parse();
   LOCALE struct expr                   *CollectArguments();
   LOCALE struct expr                   *ArgumentParse();
   LOCALE BOOLEAN                        ConstantExpression();
   LOCALE VOID                           ReturnExpression();
   LOCALE VOID                           PrintExpression();
   LOCALE VOID                           ExpressionInstall();
   LOCALE VOID                           ExpressionDeinstall();
   LOCALE int                            AddFunctionParser();
   LOCALE int                            RemoveFunctionParser();
   LOCALE struct expr                   *CopyExpression();
   LOCALE struct expr                   *PackExpression();
   LOCALE int                            ListToPacked();
   LOCALE VOID                           ReturnPackedExpression();
   LOCALE int                            ExpressionSize();
   LOCALE int                            CountArguments();
   LOCALE BOOLEAN                        ExpressionContainsVariables();
   LOCALE BOOLEAN                        IdenticalExpression();
   LOCALE struct expr                   *ParseAtomOrExpression();
   LOCALE struct FunctionDefinition     *GetFunctionList();
   LOCALE VOID                           SetFunctionList();
   LOCALE VOID                           InstallFunctionList();
   LOCALE struct FunctionDefinition     *FindFunction();
   LOCALE VOID                           AddHashFunction();
   LOCALE EXPRESSION                    *ParseConstantArguments();
#endif

#endif




