   /*******************************************************/
   /*      "C" Language Integrated Production System      */
   /*                                                     */
   /*                  A Product Of The                   */
   /*             Software Technology Branch              */
   /*             NASA - Johnson Space Center             */
   /*                                                     */
   /*             CLIPS Version 5.10  07/17/91            */
   /*                                                     */
   /*              COMPATIBILITY HEADER FILE              */
   /*******************************************************/

/*************************************************************/
/* Purpose: Use this file to enable the use of some old      */
/*   CLIPS macros and functions with version 5.0 of CLIPS.   */
/*                                                           */
/* Principal Programmer(s):                                  */
/*      Gary D. Riley                                        */
/*                                                           */
/* Contributing Programmer(s):                               */
/*                                                           */
/* Revision History:                                         */
/*                                                           */
/*************************************************************/

#ifndef _CMPTBLTY_HEADER_
#define _CMPTBLTY_HEADER_

#include "clips.h"

/****************************/
/* Redefine some old terms. */
/****************************/

#define HASH_PTR SYMBOL_HN *

#define VALUE_PTR DATA_OBJECT_PTR
#define VALUE DATA_OBJECT

#define MULTIPLE MULTIFIELD

/****************************************************************/
/* ------------ Functions for use in user programs ------------ */
/****************************************************************/

#define define_function(a,b,c,d) DefineFunction(a,b,c,d)
#define num_args() RtnArgCount()
#define rfloat(x) ((float) RtnDouble(x))
#define rstring(x) RtnLexeme(x)
#define rhash(x) FindSymbol(RtnLexeme(x))
/* rmulfloat - defined in evaluatn.h */
/* rmulstring - defined in evaluatn.h */
/* rmulhash - defined in evaluatn.h */
/* rmultype - defined in evaluatn.h */
#define runknown(x,y) RtnUnknown(x,y)

#define act_router(x) ActivateRouter(x)
#define add_router(x,y,z,q,r,s,t) AddRouter(x,y,z,q,r,s,t)
#define cl_exit(x) ExitCLIPS(x)
#define cl_getc(x) GetcCLIPS(x)
#define cl_print(x,y) PrintCLIPS(x,y)
#define cl_ungetc(x,y) UngetcCLIPS(x,y)
#define deact_router(x) DeactivateRouter(x)
#define del_router(x) DeleteRouter(x)
/* make_unknown - ???? */
/* log_namep - ???? */
#define add_symbol(x) AddSymbol(x)
#define get_segment(x) CreateMultifield(x)
#define get_el(x) CreateFact(x)
#define add_fact(x) AddFact(x)
#define symbol_string(x) ValueToString(x)
#define generic_compute(x,y) EvaluateExpression(x,y)
   
/************************************************************/
/* Macros for accessing expressions directly with EXPR_PTR. */
/************************************************************/

/* Defined in expressn.h */

/*********************************************/
/* Macros for accessing values of a SEGMENT. */
/*********************************************/

#define set_segtype(x,y,z) SetMFType(x,y,z)
#define set_segfloat(x,y,z) SetMFValue(x,y,AddDouble((double) z))
#define set_seghash(x,y,z) SetMFValue(x,y,z)
#define set_segstring(x,y,z) SetMFValue(x,y,AddSymbol(z))

#define get_segtype(x,y) ((GetMFType(x,y) == INTEGER) ? NUMBER : GetMFType(x,y))
#define get_segfloat(x,y) ((GetMFType(x,y) == NUMBER) ? \
                           ((float) ValueToDouble(GetMFValue(x,y))) : \
                           ((float) ValueToLong(GetMFValue(x,y))))
#define get_seghash(x,y) ((SYMBOL_HN *) GetMFValue(x,y))
#define get_segstring(x,y) ValueToString(GetMFValue(x,y))
#define get_seglength(x) GetDOLength(x)

/**************************************************/
/* Macros for accessing values of an ELEMENT_PTR. */
/**************************************************/

#define set_elmtype(target,value)  SetType(target,value)   
#define set_elmfloat(target,value) ClipsSetValue(target,AddDouble(value))
#define set_elmhash(target,value)  ClipsSetValue(target,value)

#define get_elmtype(target)  ((GetType(target) == INTEGER) ? NUMBER : GetType(target))
#define get_elmfloat(target) ((get_elmtype(target) == NUMBER) ? \
                              ((float) ValueToDouble(ClipsGetValue(target))) : \
                              ((float) ValueToLong(ClipsGetValue(target))))
#define get_elmhash(target)  ((SYMBOL_HN *) ClipsGetValue(target))
#define get_elmstring(target) ValueToString(ClipsGetValue(target))

/***********************************************/
/* Macros for accessing values of a VALUE_PTR. */
/***********************************************/

#define set_vptype(target,value)    SetpType(target,value)  
#define set_vpfloat(target,value)   SetpValue(target,AddDouble(value))  
#define set_vphash(target,value)    SetpValue(target,value)
#define set_vpstring(target,value)  SetpValue(target,AddSymbol(value))  
#define set_vpbegin(target,value)   SetpDOBegin(target,value) 
#define set_vpend(target,value)     SetpDOEnd(target,value)
#define set_vpsegment(target,value) SetpValue(target,value)

#define get_vptype(target)          ((GetpType(target) == INTEGER) ? NUMBER : GetpType(target))
#define get_vpfloat(target)         ((GetpType(target) == NUMBER) ? \
                                     ((float) ValueToDouble(GetpValue(target))) : \
                                     ((float) ValueToLong(GetpValue(target))))
#define get_vphash(target)          ((SYMBOL_HN *) GetpValue(target))  
#define get_vpstring(target)        ValueToString(GetpValue(target))   
#define get_vplength(target)        ((GetpType(target) == MULTIPLE) ? \
                                       GetpDOLength(target) : -1)
#define get_vpbegin(target)         ((GetpType(target) == MULTIPLE) ? \
                                       GetpDOBegin(target) : -1)
#define get_vpend(target)           ((GetpType(target) == MULTIPLE) ? \
                                       GetpDOEnd(target) : -1)
#define get_vpsegment(target)       ((GetpType(target) == MULTIPLE) ? \
                                       ((SEGMENT) GetpValue(target)) : NULL)
#define get_vpelement(item,pos)     GetMFPtr(GetpValue(item),pos)

/*******************************************/
/* Macros for accessing values of a VALUE. */
/*******************************************/
   
#define set_valtype(target,value)    SetType(target,value)  
#define set_valfloat(target,value)   ClipsSetValue(target,AddDouble(value))
#define set_valhash(target,value)    ClipsSetValue(target,value)
#define set_valstring(target,value)  ClipsSetValue(target,AddSymbol(value))
#define set_valbegin(target,value)   SetDOBegin(target,value) 
#define set_valend(target,value)     SetDOEnd(target,value)
#define set_valsegment(target,value) ClipsSetValue(target,value)

#define get_valtype(target)          ((GetType(target) == INTEGER) ? NUMBER : GetType(target))
#define get_valfloat(target)         ((GetType(target) == NUMBER) ? \
                                      ((float) ValueToDouble(ClipsGetValue(target))) : \
                                      ((float) ValueToLong(ClipsGetValue(target))))
#define get_valhash(target)          ((SYMBOL_HN *) ClipsGetValue(target))
#define get_valstring(target)        ValueToString(ClipsGetValue(target))
#define get_vallength(target)        ((GetType(target) == MULTIPLE) ? \
                                       GetDOLength(target) : -1)
#define get_valbegin(target)         ((GetType(target) == MULTIPLE) ? \
                                       GetDOBegin(target) : -1)
#define get_valend(target)           ((GetType(target) == MULTIPLE) ? \
                                       GetDOEnd(target) : -1)
#define get_valsegment(target)       ((GetType(target) == MULTIPLE) ? \
                                       ((SEGMENT) ClipsGetValue(target)) : NULL)
#define get_valelement(item,pos)     GetMFPtr(ClipsGetValue(item),pos)

/****************************************/
/* Old 4.1 Macros for accessing values. */
/****************************************/

#define rtype(x) ((GetType(x) == INTEGER) ? NUMBER : GetType(x))
#define rvalfloat(x) ((GetType(x) == NUMBER) ? \
                      ((float) DOToDouble(x)) : ((float) DOToLong(x))) 
#define rvalstring(x) DOToString(x)
#define rlength(x) GetDOLength(x)
#define assign_unknown(x,y,z,q) AssignUnknown(x,y,z,q)

/*********************************/
/* Remapping of CLIPS functions. */
/*********************************/
  
#define reset_clips() ResetCLIPS()
#define clear_clips() ClearCLIPS()
#define run(x) RunCLIPS(x)
#define load_rules(x) LoadConstructs(x)
#define init_clips() InitializeCLIPS()
#define bload(x) Bload(x)
#define bsave(x) Bsave(x)
#define displayfacts() ListFacts()
#define printagenda() ListAgenda()
#define pretty_print(x,y) PPDefrule(x,y)
#define pp_deffact(x,y) PPDeffacts(x,y)
#define pp_deftemplate(x,y) PPDeftemplate(x,y)
#define set_watch(x,y) SetWatchItem(x,y)
#define open_crsv_trace(x) OpenCRSVTrace(x)
#define close_crsv_trace() CloseCRSVTrace()
#define open_dribble(x) OpenDribble(x)
#define close_dribble() CloseDribble()
#define assert(x) AssertString(x)
#define retract_fact(x) RetractFact(x)
#define excise_rule(x)  ((FindDefrule(x) == NULL) ? 0 : DeleteDefrule(FindDefrule(x)))
#define delete_deffacts(x) ((FindDeffacts(x) == NULL) ? 0 : DeleteDeffacts(FindDeffacts(x)))
#define DeleteDeftemplate(x) ((FindDeftemplate(x) == NULL) ? 0 : DeleteDeftemplate(FindDeftemplate(x)))

#define add_exec_function(x,y) AddRunFunction(x,y)
#define remove_exec_function(x) RemoveRunFunction(x)

#define mem_used() ((float) MemoryUsed())
#define mem_requests() ((float) MemoryRequests())
#define release_mem(x,y) ReleaseMemory(x,y)
#define set_conserve(x) SetConserveMemory(x)

#define add_element(x,y,z,q,r) \
  (SetMFType(x,y,z), \
   ((z == NUMBER) ? SetMFValue(x,y,AddDouble(r)) : SetMFValue(x,y,AddSymbol(q))))
   
#define usrfuncs() UserFunctions()

#endif










