   /*******************************************************/
   /*      "C" Language Integrated Production System      */
   /*                                                     */
   /*                  A Product Of The                   */
   /*             Software Technology Branch              */
   /*             NASA - Johnson Space Center             */
   /*                                                     */
   /*               CLIPS Version 5.10  07/17/91          */
   /*                                                     */
   /*                                                     */
   /*******************************************************/

/*************************************************************/
/* Purpose:                                                  */
/*                                                           */
/* Principal Programmer(s):                                  */
/*      Brian L. Donnell                                     */
/*                                                           */
/* Contributing Programmer(s):                               */
/*                                                           */
/* Revision History:                                         */
/*                                                           */
/*************************************************************/

#ifndef _H_defins
#define _H_defins

struct definstance;

#include "object.h"
     
typedef struct definstance
  {
   unsigned busy;
   SYMBOL_HN *name;
   EXPRESSION *mkinstance;
   char *pp_form;
   struct definstance *prv,*nxt;
   long bsaveIndex;
  } DEFINSTANCES;

#ifdef LOCALE
#undef LOCALE
#endif

#ifdef _DEFINS_SOURCE_
#define LOCALE
#else
#define LOCALE extern
#endif

#if ANSI_COMPILER

LOCALE VOID SetupDefinstances(void);
LOCALE VOID SetDefinstancesList(DEFINSTANCES *);
LOCALE char *GetDefinstancesName(VOID *);
LOCALE VOID *GetNextDefinstances(VOID *);
LOCALE VOID *FindDefinstances(char *);
LOCALE int IsDefinstancesDeletable(VOID *);
LOCALE VOID CmdUndefinstances(void);

#if (! BLOAD_ONLY) && (! RUN_TIME)
LOCALE int ClearDefinstances(void);
#endif
LOCALE int DeleteDefinstances(VOID *);
#if DEBUGGING_FUNCTIONS
LOCALE VOID PPDefinstances(void);
LOCALE VOID CmdListDefinstances(void);
LOCALE char *GetDefinstancesPPForm(VOID *);
LOCALE VOID ListDefinstances(void);
#endif

#else

LOCALE VOID SetupDefinstances();
LOCALE VOID SetDefinstancesList();
LOCALE char *GetDefinstancesName();
LOCALE VOID *GetNextDefinstances();
LOCALE VOID *FindDefinstances();
LOCALE int IsDefinstancesDeletable();
LOCALE VOID CmdUndefinstances();

#if (! BLOAD_ONLY) && (! RUN_TIME)
LOCALE int ClearDefinstances();
#endif
LOCALE int DeleteDefinstances();
#if DEBUGGING_FUNCTIONS
LOCALE VOID PPDefinstances();
LOCALE VOID CmdListDefinstances();
LOCALE char *GetDefinstancesPPForm();
LOCALE VOID ListDefinstances();
#endif

#endif

#ifndef _DEFINS_SOURCE_
extern DEFINSTANCES *DefinstancesList;
#endif

#endif





