/* ************************************************************************
   FILE : WINMAIN.C
       This file contains the main driver for the CLIPS interface and the
     standard CLIPS routine usrfuncs().
       Support Routines can be found in the files : CLIPSWIN.C, ENV.C, POP.C,
     KEY.C, COLOR.C, MOUSE.C, DIRMENU.C, CLPMENU.C, ALPHA.C and HELP.C
     All of these source files have HEADER files which correspond to them.

   -- The Turbo-C version of this interface requires ~360K to start up, and the
      Microsoft-C version requires ~400K.  Thus, for any rule-base
      but a small one, your machine should have 640K of RAM.  With DOS
      loaded, after startup this should leave you with ~200-230K for your
      rule-base (this should be sufficient for ~100 rules at most).

      The Turbo-C generated executable is the one included here.

   -- Also be warned that the CLIPS on-line help system requires ~25K of RAM.
      Note that these numbers only apply to the full-featured version of the
      interface.

   In order to recompile and relink this interface, the following things
     are required :

   -- Borland International's Turbo C Complier Version 1.5 or better
      OR
      Microsoft's C Compiler Version 5.1 or better
   -- Aspen Scientific's Curses Screen Package Version 4.0 or better
       (This includes the 4 header files CURSES.H, XCURSES.H, BOX.H,
        and CURPROTO.H, as well as the large memory model library
        CURSESL.LIB (for Turbo-C) or LCURSES.LIB (for Microsoft-C))
   -- All normal CLIPS header files and object modules (except MAIN.OBJ)
      -- The makefile expects all of the CLIPS standard object modules
         to be stored in a library created by the Turbo C Librarian called
         CLIPSL.LIB (or the Microsoft Librarian called LCLIPS.LIB).

   -- A makefile for use with Borland's Make Facility (included with
      the Turbo C package) has been included.  Users of Microsoft's MAKE
      utility should be able to modify the makefile included.

      -- To remake the interface CLIPSWIN.EXE, set the flag ENVIRONMENT_UTILITY
         to 0 in the file COMMON.H, then execute the command "make".

      -- To remake the environment-utility CLPSUTIL.EXE, set the flag
         ENVIRONMENT_UTILITY to 1 in the file COMMON.H, then execute the
         command "make -Denvutil".

      -- The mouse-interface should work with all Microsoft-compatible mice,
         but has only been tested with Mouse System's PC-Mouse and Microsoft
         Mouse.

      -- To remake either the interface or the utility without Mouse
         support, set the flag MOUSE to 0 in COMMON.H, then execute the
         command "make -Dnomouse" or "make -Denvutil -Dnomouse"

      -- When compiling under Microsft-C 5.1, add the parameter -Dmsc to
         the make command-line.  Make sure the compiler-selection flag in
         the CLIPS header file SETUP.H is set appropriately.

      -- The files that you need can be seen by examining the makefile.
   *********************************************************************** */
   
/* =======================================================================
   ***********************************************************************
                             HEADER FILES
   ***********************************************************************
   ======================================================================= */
#include "common.h"   /* Standard header files, constants, and macros      */
#include "clipswin.h" /* init_interface() prototype                        */

/* =======================================================================
   ***********************************************************************
            EXTERN PROTOTYPES FOR CLIPS FUNCTIONS NOT IN THIS FILE
   ***********************************************************************
   ======================================================================= */
extern int init_clips(void);
extern int reroute_stdin(int,char *[]);
extern int cl_print(char *,char *);
extern int command_loop(void);
extern int define_function(char *,char,int (*)(),char *);

/* =======================================================================
   ***********************************************************************
                   EXTERNALLY VISIBLE FUNCTION PROTOTYPES
   ***********************************************************************
   ======================================================================= */
void main(int,char *[]);                /* Main driver                   */
void usrfuncs(void);                    /* CLIPS user-defined fns.       */

/* =======================================================================
   ***********************************************************************
                         EXTERNALLY VISIBLE FUNCTIONS
   ***********************************************************************
   ======================================================================= */

/******************************************************************************
 NAME        : main
 PURPOSE     : Main driver for the CLIPS interface
 DESCRIPTION : Initializes the screen interface windows, CLIPS data
               data structures, performs any command preprocessing
               required, and activates the CLIPS top level command loop.
               Also intializes monochrome setup for -m or /m option on
               command line.
 INPUTS      : 1) argc - the number of arguments CLIPS was called with
               2) *argv[] - string array containing the arguments
 RETURNS     : Nothing useful.
 NOTES       : This function is identical to the standard MAIN.C included
               with CLIPS with the exception of the calls to init_interface()
               (this file), and the monochrome-command-line-flag loop.
 ******************************************************************************/
void main(argc,argv)
  int argc;
  char *argv[];
  {
   int i,j;
   int set_mono = FALSE,
       set_ega = FALSE;

   for (i = 1 ; i < argc ; i++)
     {
      if ((argv[i][0] == '/') || (argv[i][0] == '-'))
        {
         for (j = 1 ; argv[i][j] != EOS ; j++)
           {
            if ((argv[i][j] == 'm') || (argv[i][j] == 'M'))
              set_mono = TRUE;
            else if ((argv[i][j] == 'e') || (argv[i][j] == 'E'))
              set_ega = TRUE;
            else if ((argv[i][j] == 'f') || (argv[i][j] == 'F'))
              {}
            else
              {
               printf("\'%c\' is not a valid flag.\n",argv[i][j]);
               exit(0);
              }
           }
        }
     }
   if (set_ega)
     putenv("TERM=ega-pc");
   init_clips();
   init_interface(set_mono);
   reroute_stdin(argc,argv);
   cl_print("wdisplay","      CLIPS (V4.30 5/26/89)\n");
   cl_print("wdisplay","      CLIPS DOS Window Interface (V2.01 5/26/89)\n");
   cl_print("wdisplay","Press F1 for Help\n");
   command_loop();
  }

/******************************************************************************
 NAME        : usrfuncs
 PURPOSE     : Process user defined function for CLIPS
 DESCRIPTION : This routine establishes any user-functions for CLIPS
               via the define_function() mechanism (see CLIPS Reference Manual).
 INPUTS      : None
 RETURNS     : Nothing useful.
 NOTES       : This procedure is identical to the one in standard CLIPS.
 ******************************************************************************/
void usrfuncs(void)
  {
   /* Example --

     define_function("myfun",'i',myfunction,"myfunction");

    */
   define_function("clear-window",'i',clips_clear_window,"clips_clear_window");
  }


