#---------------------------------------------------------------------------
# make file tcclips.mak  for Turbo C 1.5, 2.0 make of CLIPS v4.3 spb 5-12-89
#
# USE: \tc15\make -ftcclips<return>   (extension .mak assumed for tcclips)
#
# Assumes CLIPS source (.c), include (.h) files and this make file and link
# list file clipsobj.430 (described below) on subdirectory c:\tcclips
# and object (.obj) files and executible (tcclips.exe) will be written on
# subdirectory c:\tcclips by Turbo C; finally make executed while logged on
# c:\tcclips subdirectory
#
# Also assumes Turbo C is on subdirectory c:\tc15
#
# For problems (US Government & Contractors ONLY) call
#  Stephen Baudendistel  CLIPS HELP DESK (713) 280-2233
#
# IMPORTANT! See notes at end of this file!!!
#--------------------------------------------------------------------------
# MACRO DEFINITIONS
#
exefile=tcclips.exe
linkline=\tc15\tlink \tc15\c0l.obj @clipsobj.430,$(exefile),NUL,\tc15\emu \tc15\mathl \tc15\cl
compass1=\tc15\tcc -c -I\tc15 -I\tcclips -ml -n\tcclips
compass2=rem TRA LA LA LA
#
# explicit rule defines how executible, tcclips.mak.exe, depends on .obj files
#
$(exefile):   analysis.obj\
              bload.obj\
              bsave.obj\
              build.obj\
              commline.obj\
              deffacts.obj\
              deftmcom.obj\
              deftmfun.obj\
              drive.obj\
              edbasic.obj\
              edmain.obj\
              edmisc.obj\
              edstruct.obj\
              edterm.obj\
              engine.obj\
              evaluatn.obj\
              expressn.obj\
              factmngr.obj\
              generate.obj\
              intrbrws.obj\
              intrexec.obj\
              intrfile.obj\
              lhsparse.obj\
              main.obj\
              match.obj\
              math.obj\
              memory.obj\
              multivar.obj\
              reorder.obj\
              retract.obj\
              router.obj\
              rulecomp.obj\
              rulemngr.obj\
              rulepars.obj\
              scanner.obj\
              strings.obj\
              symbol.obj\
              sysdep.obj\
              sysio.obj\
              syspred.obj\
              sysprime.obj\
              syssecnd.obj\
              textpro.obj\
              utility.obj\
              variable.obj
  $(linkline)

#
# explicit rules define how the object (.obj) files depend on .h files
#
analysis.obj: analysis.h clipsmem.h constant.h expressn.h lhsparse.h\
              setup.h symbol.h

bload.obj:    access.h clipsmem.h constant.h deffacts.h expressn.h network.h\
              setup.h symbol.h

bsave.obj:    access.h clipsmem.h constant.h deffacts.h expressn.h network.h\
              setup.h symbol.h

build.obj:    clipsmem.h constant.h expressn.h network.h rule.h setup.h\
              symbol.h variable.h

commline.obj: access.h clipsmem.h constant.h expressn.h network.h rule.h\
              scanner.h setup.h symbol.h

deffacts.obj: access.h clipsmem.h constant.h deffacts.h expressn.h network.h\
              scanner.h setup.h symbol.h

deftmcom.obj: access.h clipsmem.h constant.h deftempl.h expressn.h lhsparse.h\
              network.h scanner.h setup.h symbol.h

deftmfun.obj: access.h clipsmem.h constant.h deftempl.h expressn.h lhsparse.h\
              network.h scanner.h setup.h symbol.h

drive.obj:    access.h clipsmem.h constant.h expressn.h network.h setup.h\
              symbol.h

edbasic.obj:  access.h clipsmem.h constant.h expressn.h network.h setup.h\
              symbol.h

edmain.obj:   access.h clipsmem.h constant.h expressn.h network.h setup.h\
              symbol.h

edmisc.obj:   access.h clipsmem.h constant.h expressn.h network.h setup.h\
              symbol.h

edstruct.obj: access.h clipsmem.h constant.h expressn.h network.h setup.h\
              symbol.h

edterm.obj:   access.h clipsmem.h constant.h expressn.h network.h setup.h\
              symbol.h

engine.obj:   access.h clipsmem.h constant.h engine.h expressn.h network.h\
              setup.h  symbol.h

evaluatn.obj: access.h clipsmem.h constant.h engine.h expressn.h network.h\
              setup.h  symbol.h

expressn.obj: clipsmem.h constant.h expressn.h scanner.h setup.h symbol.h

factmngr.obj: access.h clipsmem.h constant.h expressn.h network.h scanner.h\
              setup.h symbol.h

generate.obj: clipsmem.h constant.h expressn.h lhsparse.h setup.h symbol.h\
              variable.h

intrbrws.obj: access.h clipsmem.h constant.h engine.h expressn.h network.h\
              rule.h setup.h symbol.h

intrexec.obj: access.h clipsmem.h constant.h engine.h expressn.h network.h\
              rule.h setup.h symbol.h

intrfile.obj: access.h clipsmem.h constant.h expressn.h network.h rule.h\
              scanner.h setup.h symbol.h

lhsparse.obj: clipsmem.h constant.h expressn.h lhsparse.h scanner.h setup.h\
              symbol.h

main.obj:     main.c

match.obj:    access.h clipsmem.h constant.h expressn.h network.h setup.h\
              symbol.h

math.obj:     access.h clipsmem.h constant.h expressn.h network.h setup.h\
              symbol.h

memory.obj:   clipsmem.h constant.h setup.h

multivar.obj: access.h clipsmem.h constant.h expressn.h network.h scanner.h\
              setup.h symbol.h

reorder.obj:  clipsmem.h constant.h expressn.h lhsparse.h setup.h symbol.h

retract.obj:  clipsmem.h constant.h expressn.h network.h setup.h symbol.h

router.obj:   clipsmem.h constant.h router.h setup.h

rulecomp.obj: access.h clipsmem.h constant.h deffacts.h engine.h expressn.h\
              network.h setup.h symbol.h

rulemngr.obj: clipsmem.h constant.h expressn.h network.h rule.h setup.h\
              symbol.h

rulepars.obj: clipsmem.h constant.h expressn.h lhsparse.h network.h rule.h\
              scanner.h setup.h symbol.h variable.h

scanner.obj:  clipsmem.h constant.h scanner.h setup.h symbol.h

strings.obj:  access.h clipsmem.h constant.h expressn.h network.h setup.h\
              symbol.h

symbol.obj:   clipsmem.h constant.h setup.h symbol.h

sysdep.obj:   access.h clipsmem.h constant.h expressn.h network.h setup.h\
              symbol.h

sysio.obj:    access.h clipsmem.h constant.h expressn.h network.h scanner.h\
              setup.h  symbol.h

syspred.obj:  access.h clipsmem.h constant.h expressn.h network.h setup.h\
              symbol.h

sysprime.obj: access.h clipsmem.h constant.h expressn.h network.h setup.h\
              symbol.h

syssecnd.obj: access.h clipsmem.h constant.h expressn.h network.h setup.h\
              symbol.h

textpro.obj:  access.h clipsmem.h constant.h expressn.h network.h setup.h\
              symbol.h

utility.obj:  access.h clipsmem.h constant.h expressn.h network.h setup.h\
              symbol.h

variable.obj: clipsmem.h constant.h expressn.h lhsparse.h setup.h symbol.h\
              variable.h

# implicit rule for compiling .c source files into .obj files

.c.obj:
   $(compass1) $*.c
   $(compass2)

#---------------------------------------------------------------------------
# You must also create a file for the link line above named clipsobj.430
# the contents of this file are: (remove make comments symbols [#]
# below when you create the file)
#
#analysis.obj+
#bload.obj+
#bsave.obj+
#build.obj+
#commline.obj+
#deffacts.obj+
#deftmcom.obj+
#deftmfun.obj+
#drive.obj+
#edbasic.obj+
#edmain.obj+
#edmisc.obj+
#edstruct.obj+
#edterm.obj+
#engine.obj+
#evaluatn.obj+
#expressn.obj+
#factmngr.obj+
#generate.obj+
#intrbrws.obj+
#intrexec.obj+
#intrfile.obj+
#lhsparse.obj+
#main.obj+
#match.obj+
#math.obj+
#memory.obj+
#multivar.obj+
#reorder.obj+
#retract.obj+
#router.obj+
#rulecomp.obj+
#rulemngr.obj+
#rulepars.obj+
#scanner.obj+
#strings.obj+
#symbol.obj+
#sysdep.obj+
#sysio.obj+
#syspred.obj+
#sysprime.obj+
#syssecnd.obj+
#textpro.obj+
#utility.obj+
#variable.obj
#---------------------------------------------------------------------------
# IMPORTANT NOTES:
#
# Be sure to set the IBM_TBC flag to 1 in SETUP.H file and set all other
# compiler flags to 0
#
#------------------------END of FILE---------------------------------------
