#---------------------------------------------------------------------------
# make file scoclips.mak for SCO XENIX C 2.2.3 make of CLIPS v4.3 spb 5-18-89
#
# USE: make -f scoclips.mak<return>
#
# Assumes CLIPS source (.c), include (.h) files and this make file
# on subdirectory c:/users/spb/clips and object (.o) files and executable
# (scoclips) will be written on subdirectory c:/users/spb/clips by the C
# compiler; finally make executed while logged on c:/users/spb/clips
# subdirectory.  This make file tested on 80286, hopefully works for 80386.
#
# As copied back to DOS disk the tabs necessary before implicit commands
# are lost and YOU MUST RESTORE THEM BEFORE THIS FILE WILL WORK ON A UNIX
# SYSTEM.  So use vi to edit this file by deleting the spaces before the
# implicit commands $(compass1), $(compass2), $(linkline) and then inserting
# one tab.  If you don't do this you will get complaints about 'need
# separator on line xxx'
#
# For problems (US Government & Contractors ONLY) call
#  Stephen Baudendistel  CLIPS HELP DESK (713) 280-2233
#
# IMPORTANT! See notes at end of this file!!!
#--------------------------------------------------------------------------
# MACRO DEFINITIONS
#
exefile=scoclips
linklist=analysis.o\
         bload.o\
         bsave.o\
         build.o\
         commline.o\
         deffacts.o\
         deftmcom.o\
         deftmfun.o\
         drive.o\
         edbasic.o\
         edmain.o\
         edmisc.o\
         edstruct.o\
         edterm.o\
         engine.o\
         evaluatn.o\
         expressn.o\
         factmngr.o\
         generate.o\
         intrbrws.o\
         intrexec.o\
         intrfile.o\
         lhsparse.o\
         main.o\
         match.o\
         math.o\
         memory.o\
         multivar.o\
         reorder.o\
         retract.o\
         router.o\
         rulecomp.o\
         rulemngr.o\
         rulepars.o\
         scanner.o\
         strings.o\
         symbol.o\
         sysdep.o\
         sysio.o\
         syspred.o\
         sysprime.o\
         syssecnd.o\
         textpro.o\
         utility.o\
         variable.o
# memory model specification -Ml2 set to generate 80286 code
# set to -Ml3 for 80386 or -Ml0 for 8086
linkline=cc -Ml2 -o $(exefile) $(linklist) -ltermcap -lm
compass1=cc -c -FPi -Ml2
compass2=

#
# explicit rule defines how executable, scoclips, depends on .o files
#
$(exefile):  $(linklist)
        $(linkline)

#
# explicit rules define how the object (.o) files depend on .h files
#
analysis.o: analysis.h clipsmem.h constant.h expressn.h lhsparse.h\
              setup.h symbol.h

bload.o:    access.h clipsmem.h constant.h deffacts.h expressn.h network.h\
              setup.h symbol.h

bsave.o:    access.h clipsmem.h constant.h deffacts.h expressn.h network.h\
              setup.h symbol.h

build.o:    clipsmem.h constant.h expressn.h network.h rule.h setup.h\
              symbol.h variable.h

commline.o: access.h clipsmem.h constant.h expressn.h network.h rule.h\
              scanner.h setup.h symbol.h

deffacts.o: access.h clipsmem.h constant.h deffacts.h expressn.h network.h\
              scanner.h setup.h symbol.h

deftmcom.o: access.h clipsmem.h constant.h deftempl.h expressn.h lhsparse.h\
              network.h scanner.h setup.h symbol.h

deftmfun.o: access.h clipsmem.h constant.h deftempl.h expressn.h lhsparse.h\
              network.h scanner.h setup.h symbol.h

drive.o:    access.h clipsmem.h constant.h expressn.h network.h setup.h\
              symbol.h

edbasic.o:  access.h clipsmem.h constant.h expressn.h network.h setup.h\
              symbol.h

edmain.o:   access.h clipsmem.h constant.h expressn.h network.h setup.h\
              symbol.h

edmisc.o:   access.h clipsmem.h constant.h expressn.h network.h setup.h\
              symbol.h

edstruct.o: access.h clipsmem.h constant.h expressn.h network.h setup.h\
              symbol.h

edterm.o:   access.h clipsmem.h constant.h expressn.h network.h setup.h\
              symbol.h

engine.o:   access.h clipsmem.h constant.h engine.h expressn.h network.h\
              setup.h  symbol.h

evaluatn.o: access.h clipsmem.h constant.h engine.h expressn.h network.h\
              setup.h  symbol.h

expressn.o: clipsmem.h constant.h expressn.h scanner.h setup.h symbol.h

factmngr.o: access.h clipsmem.h constant.h expressn.h network.h scanner.h\
              setup.h symbol.h

generate.o: clipsmem.h constant.h expressn.h lhsparse.h setup.h symbol.h\
              variable.h

intrbrws.o: access.h clipsmem.h constant.h engine.h expressn.h network.h\
              rule.h setup.h symbol.h

intrexec.o: access.h clipsmem.h constant.h engine.h expressn.h network.h\
              rule.h setup.h symbol.h

intrfile.o: access.h clipsmem.h constant.h expressn.h network.h rule.h\
              scanner.h setup.h symbol.h

lhsparse.o: clipsmem.h constant.h expressn.h lhsparse.h scanner.h setup.h\
              symbol.h

main.o:     main.c

match.o:    access.h clipsmem.h constant.h expressn.h network.h setup.h\
              symbol.h

math.o:     access.h clipsmem.h constant.h expressn.h network.h setup.h\
              symbol.h

memory.o:   clipsmem.h constant.h setup.h

multivar.o: access.h clipsmem.h constant.h expressn.h network.h scanner.h\
              setup.h symbol.h

reorder.o:  clipsmem.h constant.h expressn.h lhsparse.h setup.h symbol.h

retract.o:  clipsmem.h constant.h expressn.h network.h setup.h symbol.h

router.o:   clipsmem.h constant.h router.h setup.h

rulecomp.o: access.h clipsmem.h constant.h deffacts.h engine.h expressn.h\
              network.h setup.h symbol.h

rulemngr.o: clipsmem.h constant.h expressn.h network.h rule.h setup.h\
              symbol.h

rulepars.o: clipsmem.h constant.h expressn.h lhsparse.h network.h rule.h\
              scanner.h setup.h symbol.h variable.h

scanner.o:  clipsmem.h constant.h scanner.h setup.h symbol.h

strings.o:  access.h clipsmem.h constant.h expressn.h network.h setup.h\
              symbol.h

symbol.o:   clipsmem.h constant.h setup.h symbol.h

sysdep.o:   access.h clipsmem.h constant.h expressn.h network.h setup.h\
              symbol.h

sysio.o:    access.h clipsmem.h constant.h expressn.h network.h scanner.h\
              setup.h  symbol.h

syspred.o:  access.h clipsmem.h constant.h expressn.h network.h setup.h\
              symbol.h

sysprime.o: access.h clipsmem.h constant.h expressn.h network.h setup.h\
              symbol.h

syssecnd.o: access.h clipsmem.h constant.h expressn.h network.h setup.h\
              symbol.h

textpro.o:  access.h clipsmem.h constant.h expressn.h network.h setup.h\
              symbol.h

utility.o:  access.h clipsmem.h constant.h expressn.h network.h setup.h\
              symbol.h

variable.o: clipsmem.h constant.h expressn.h lhsparse.h setup.h symbol.h\
              variable.h

# implicit rule for compiling .c source files into .o files

.c.o:
        $(compass1) $*.c
        $(compass2)

#---------------------------------------------------------------------------
# IMPORTANT NOTES:
#
# Be sure to set the UNIX_V flag to 1 in SETUP.H file and set all other
# compiler flags to 0
#
#------------------------END of FILE---------------------------------------
