/* ----------------------------------------------------------------------
   Code returned by cancelled or invalid menus -- Don't change the values
   of these codes, correct operation depends on these values
   ---------------------------------------------------------------------- */
#define MENU_RIGHT_ABORT -2
#define MENU_LEFT_ABORT  -1
#define MENU_ABORT        0

/* -------------------------------------------------------------------------
   Menu Item Handler Routines Status Return Codes -- Don't change the values
   of these codes, correct operation depends on these values
   ------------------------------------------------------------------------- */
#define MENU_ITEM_CLIPS_INPUT 2
#define MENU_ITEM_COMPLETION  1
#define MENU_ITEM_ABORT       0

/* -----------------------------
   mew_menu() Visual Image Codes
   ----------------------------- */
#define VISUAL_POP_UP_MENU_NO  0  /* Visual display is already taken care of */
#define VISUAL_POP_UP_MENU_YES 1  /* Allocate a pop-up window for menu       */

/* ------------------------------------------
   Pop-up warning message justification codes
   ------------------------------------------ */
#define LFT_JUST 0
#define MID_JUST 1
#define RGT_JUST 2

/* ---------------------------------
   Pop-up warning message bell codes
   --------------------------------- */
#define SILENCE  0
#define BEEP     1

/* --------------------
   Menu item type codes
   -------------------- */
#define ITEM    0
#define SUBMENU 1

/* ---------------
   Menu item type
   --------------- */

struct menu;

struct menu_item
  {
   int type;                        /* Item type -- ITEM (0), SUBMENU (1) */
   char *name;                      /* Name of the menu item              */
   union
     {
      int  (*handler)(int);         /* Address of the handler routine     */
      struct menu *submenu;         /* Address of child sub-menu          */
     } desc;
  };

/* ---------------
   Menu type
   --------------- */
struct menu
  {
   int level;                /* Depth of menu (starting at 0)           */
   int item_cnt;             /* Number of items in a menu               */
   struct menu_item **items; /* List of menu items and handler routines */
   WINDOW *border,           /* Visual menu representation - the border */
          *text;             /* The actual selection text - this window 
                                is a sub-window of the first            */
  };

typedef struct menu_item MENU_ITEM;
typedef struct menu MENU;

#ifndef MENU_SOURCE

extern MENU *new_menu(int,int,...);
extern int  create_visual_menu(MENU *);
extern void draw_pop_up_menu(MENU *);
extern MENU *kill_menu(MENU *);

extern int  activate_pop_up_menu(MENU *,int,int);

extern int  pop_up_warning(int,int,int,...);
extern char *pop_up_text(char *,char *,int);
extern void pop_up_highlight(WINDOW *,int,ch_attr,int,ch_attr);
extern int  change_menu_item(MENU *,int,char *);

#endif


