/************************************************************
 * This file has all the functions that handle all the CRSV *
 * menus.                                                   *
 ************************************************************/

#include <curses.h>      /* Aspen Scientific Curses V4.0 Header Files -   */
#include <xcurses.h>     /*    Screen interface function prototypes and   */
#include <box.h>         /*      constants                                */
#include <ctype.h>

#include "crsv.h"

#define CRSVWIN_SOURCE

#include "pcint.h"       /* Standard header files, constants, and macros  */
#include "pcconst.h"


/*******************************************************
 *   INTERNAL FUNCTIONS Available externally
 *            CRSV Menu Interface Functions 
 *******************************************************
 */

int do_main_menu(int),                /* Main menu options */
    do_help(int);

int do_add(int),                      /* File menu options */
    do_remove(int),
    do_move_up(int),
    do_move_down(int), 
    do_dribble(int),
    do_exit(int);  

int do_run(int);                      /* Execute menu options */

int do_be_verbose(int),               /* Options menu options */
    do_crss_ref_rel(int),
    do_style_wrng_anal(int),
    do_rule_deff_sum(int),
    do_ver_rule_w_defrel(int),
    do_crss_ref_usr_func(int),
    do_create_defrel_file(int),
    do_drib_sum(int),
    do_anal_drib(int);
   
int do_pause(int),                    /* Special menu options */
    do_clear(int);

int do_nothing(int);                  /* Watch/Unwatch functions */


/*******************************************************
 *   EXTERNAL FUNCTIONS AND VARIABLES
 *******************************************************
*/
extern int atoi(char*);
extern WINDOW 	*def_rel_win_border,    /* boder region of Defrelation window */
	       	*def_rel_win_text,      /* Text region of Derelation window */
		*drib_file_win_text,    /* Border region of trace file window */
		*drib_file_win_border,  /* Text region of Trace file window */
		*file_win_border,       /* Border region of File list window */
		*file_win_text;         /* Text region of File list window */



extern MENU *file_menu,          /* File menu in the main menu */
	    *options_menu,       /* Options menu in the main menu */
            *special_menu;       /* Special menu in the main menu */

extern short option_flags[10];   /* Flags of the CRSV options */
extern short PAUSE_OUT_PUT;      /* Pausing output option */
extern FILE *drib_fp;
extern WINBLK *pop_up_queue_top; /* Top of pop_up queue */

/* ----------------------
 *  From CRSVPC.C
 * ----------------------
 */

extern int  main_pop_up_start(int);     /* Gets center screen box coord  */
extern void crsv_addstr(char *);    /*Print a string to CRSV window */
extern void crsv_clear_win(void);
extern void crsv_error_message(char*,char*);
extern void crsv_warning_message(char*,char*);
extern void stop_interface(int);

extern int    num_files;                        /* Number of files */
extern char   file_list[MAX_FILES][MAX_NAME];   /* List of files */
extern char   def_rel_file[MAX_NAME];           /* Defrelations file name */
extern char   drib_file_name[MAX_NAME];         /* Dribble file name */


/* ----------------------
 *  From POPUP.C
 * ----------------------
 */

extern void change_popup_option(MENU*,int,short[]); /* Mark or unmark the options in the menu */

/* ----------------------
 *  From CRSV.C
 * ----------------------
 */

extern void   init_globals(void);
extern int    process_main(int, char[MAX_FILES][MAX_NAME],
                           char[MAX_NAME],char[MAX_NAME]);
extern void   end_crsv(void);


/**************************************************************
 *        INTERNAL FUNCTIONS                                  *
 **************************************************************/

/* Delete a file from an array of files */

static void delete_file_from_list(char[MAX_FILES][MAX_NAME],int,int*);

/* Exchange the position of a file in an array of files */

static void exchange_file_from_list(char[MAX_FILES][MAX_NAME],int,int);

/* Mark On or Off an item in a menu */

static void change_on_off_option(MENU*,int,int,char*);

static short DRIB_WIN_IN_QUEUE = FALSE;
static short DEF_REL_WIN_IN_QUEUE = FALSE;
static short FILE_WIN_IN_QUEUE = TRUE;


/* ****************************************************************************
   ============================================================================
                       CRSV MENU INTERFACE FUNCTIONS
   ============================================================================
   ****************************************************************************/

/******************************************************************************
 NAME        : do_main_menu
 PURPOSE     : Picks the pop-up menu to display for a selection in the main menu
 DESCRIPTION : 
 INPUTS      : 1) The index in the main-menu from which this routine was
                  called - this argument is used to determine which sub-menu
                  applies.
 RETURNS     : 1) MENU_ITEM_ABORT if the pop-up-menu is cancelled,
               2) otherwise the return code of the pop-up menu
                  (see corresponding menu declaration in allocate_menus() in
                   this file and activate_pop_up_menu() in POPUP.C).
 NOTES       : The main-menu option "Help" is handled by the routine do_help().
 ******************************************************************************/
int do_main_menu(index)
  int index;
  {
   MENU *menu;
   int ctr,rtn;
   static short START = TRUE;

   switch(index)
     {
      case FILE_INDEX : menu = file_menu;
                        break;
      case OPTS_INDEX : menu = options_menu;
                        if(START)
                          {
                            CHECK_STYLE = OFF;
			    CHECK_DEFRELS = OFF;
                            option_flags[2] = FALSE;
			    option_flags[4] = FALSE;
                            do_style_wrng_anal(3);
			    do_ver_rule_w_defrel(5);
                            START = FALSE;
                          }
                        break;
      case SPE_INDEX  : menu = special_menu;
			break;
      default         : return(MENU_ITEM_ABORT);
     }
   if((drib_file_win_border != NULL)&&(!DRIB_WIN_IN_QUEUE))
     {
        insert_pop_up(drib_file_win_border);
	insert_pop_up(drib_file_win_text);
        DRIB_WIN_IN_QUEUE = TRUE;
     }
   if((def_rel_win_border != NULL)&&(!DEF_REL_WIN_IN_QUEUE))
    {
   	insert_pop_up(def_rel_win_border);
	insert_pop_up(def_rel_win_text);
        DEF_REL_WIN_IN_QUEUE = TRUE;
    }
   if(!FILE_WIN_IN_QUEUE)
    {
   	insert_pop_up(file_win_border);
	insert_pop_up(file_win_text);
        FILE_WIN_IN_QUEUE = TRUE;
    }    
   ctr = main_pop_up_start(index);
   rtn = activate_pop_up_menu(menu,CRSV_Y-1,ctr,NULL);
   if (rtn == MENU_ABORT)
     return(MENU_ITEM_ABORT);
   return(rtn);
  }

   extern unsigned sleep(unsigned);
   extern void nosound(void);
   extern void sound(unsigned);

/******************************************************************************
 NAME        : do_help
 PURPOSE     : Provides an on-line help facility for the interface
 DESCRIPTION : 
 INPUTS      : 1) The index in the main menu from which this routine was called
 RETURNS     : Returns MENU_ITEM_ABORT
 NOTES       : None
 ******************************************************************************/
int do_help(index)
  int index;
  {
   WINDOW *win;

   if (pop_up_warning("Are you upset that\nHelp is not yet available?",
                          MID_JUST,SILENCE,CONFIRM) == YES)
     {
      win = newwin(4,20,12,30);
      xpaint(win,A_FHI_WHITE|A_BRED);
      wattrset(win,A_FHI_WHITE|A_BRED);
      mvwaddstr(win,2,7,"TOUGH!");
      wrefresh(win);
      sound(21);
      sleep(2);
      nosound();
      delwin(win);
      redisplay_wins();
     }
   return(MENU_ITEM_ABORT);
  }

/******************************************************************************
 NAME        : do_pause
 PURPOSE     : 
 DESCRIPTION : 
 INPUTS      : Ignored
 RETURNS     : Nothing useful.
 NOTES       : 
 ******************************************************************************/

int do_pause(index)
int index;
{
    if(PAUSE_OUT_PUT == FALSE)
      {
        change_on_off_option(special_menu,index,16,"Off");
        PAUSE_OUT_PUT = TRUE;
      }
    else
      {
        change_on_off_option(special_menu,index,16,"On ");
        PAUSE_OUT_PUT = FALSE;
      }
   return(MENU_ITEM_ABORT);
}
/******************************************************************************
 NAME        : do_clear
 PURPOSE     : 
 DESCRIPTION : 
 INPUTS      : Ignored
 RETURNS     : Nothing useful.
 NOTES       : 
 ******************************************************************************/

int do_clear(index)
int index;
{
/*    WINBLK *ptr; */

    crsv_clear_win();
    (void)pop_up_queue_top;
    if(!FILE_WIN_IN_QUEUE)
      {
        insert_pop_up(file_win_border);
        insert_pop_up(file_win_text);
	FILE_WIN_IN_QUEUE = TRUE;
      }
    if((def_rel_win_border != NULL)&&(!DEF_REL_WIN_IN_QUEUE))
     {
           insert_pop_up(def_rel_win_border);
           insert_pop_up(def_rel_win_text);
           DEF_REL_WIN_IN_QUEUE = TRUE;
     }
    if((drib_file_win_border != NULL)&&(!DRIB_WIN_IN_QUEUE))
     {
           insert_pop_up(drib_file_win_border);
           insert_pop_up(drib_file_win_text);
           DRIB_WIN_IN_QUEUE = TRUE;
       }
    redisplay_wins();
    return(MENU_ITEM_ABORT);
}
/******************************************************************************
 NAME        : do_nothing
 PURPOSE     : Empty stub place holder for menu-itme handlers.
 DESCRIPTION : 
 INPUTS      : Ignored
 RETURNS     : Nothing useful.
 NOTES       : Used by the watch sub-menu.
 ******************************************************************************/
int do_nothing(index)
  int index;
  {
   return(MENU_ITEM_COMPLETION);
  }

/******************************************************************************
 NAME        :  do_verbose
 PURPOSE     :  Marking the verbose option On or Off 
 DESCRIPTION :  First, the function marks or unmarks the verbose option
                in the option menu; second, it changes the flag to TRUE
                or FALSE depend on the old value of the verbose flag.
 INPUTS      :  position of the option in the menu
 RETURNS     :  integer.
 NOTES       : 
 ******************************************************************************/
  
int do_be_verbose(index) 
int index ;
  {
    change_popup_option(options_menu,index,option_flags);
    if(VERBOSE == TRUE)
      {
        VERBOSE = FALSE;
        option_flags[index-1] = FALSE;
      }
    else
      {
        VERBOSE = TRUE;
        option_flags[index-1] = TRUE;
      }
    return(MENU_ITEM_ABORT);
  }
/******************************************************************************
 NAME        : do_crss_ref_rel
 PURPOSE     : Marking or unmarking the CHECK_RELATION flag
 DESCRIPTION : 
 INPUTS      : position of the item in the menu
 RETURNS     : integer
 NOTES       : 
 ******************************************************************************/
  
int do_crss_ref_rel(index) 
int index;
{
    change_popup_option(options_menu,index,option_flags);
    if(CHECK_RELATIONS == TRUE)
      {
         CHECK_RELATIONS = FALSE;
         option_flags[index-1] = FALSE;
      }
    else
      {
         CHECK_RELATIONS = TRUE;
         option_flags[index-1]= TRUE;
       }
    return(MENU_ITEM_ABORT);
}
/******************************************************************************
 NAME        : do_style_wrng_anal
 PURPOSE     : To turn CHECK_STYLE flag ON or OFF
 DESCRIPTION : 
 INPUTS      : Ignored
 RETURNS     : Ignored
 NOTES       : 
 ******************************************************************************/

int do_style_wrng_anal(index)
int index; 
{
    change_popup_option(options_menu,index,option_flags);
    if(CHECK_STYLE == TRUE)
      {
         CHECK_STYLE = FALSE;
         option_flags[index-1] = FALSE;
      }
    else
      {
         CHECK_STYLE = TRUE;
         option_flags[index-1] = TRUE;
      }
    return(MENU_ITEM_ABORT);
}
/******************************************************************************
 NAME        : do_rule_deff_sum
 PURPOSE     : to turn CHECK_RULES flag ON or OFF
 DESCRIPTION : 
 INPUTS      : Ignored
 RETURNS     : Ignored
 NOTES       : 
 ******************************************************************************/

int do_rule_deff_sum(index) 
int index; 
{  
   change_popup_option(options_menu,index,option_flags);
   if(CHECK_RULES == TRUE)
     {
        CHECK_RULES = FALSE;
        option_flags[index-1] = FALSE;
     }
   else
    {
        CHECK_RULES = TRUE;
        option_flags[index-1] = TRUE;
    }
   return(MENU_ITEM_ABORT);
}
/******************************************************************************
 NAME        : do_ver_rule_w_defrel
 PURPOSE     : To turn CHECK_DEFRELS flag ON or OFF
 DESCRIPTION : 
 INPUTS      : Ignored
 RETURNS     : Ignored
 NOTES       : 
 ******************************************************************************/

int do_ver_rule_w_defrel(index) 
int index; 
{

    if(CHECK_DEFRELS == TRUE)
      { 
        change_popup_option(options_menu,index,option_flags);
        CHECK_DEFRELS = FALSE;
        option_flags[index-1] = FALSE;
      }
    else
      {
        if(CREATE_DEFRELS == TRUE)
          pop_up_warning("Incompatible with CREATE_DEFRELS option",
			MID_JUST,SILENCE,NOT_CONFIRM);
        else
          {
             change_popup_option(options_menu,index,option_flags);
             CHECK_DEFRELS = TRUE;
             option_flags[index-1] = TRUE;
          }
      }
    return(MENU_ITEM_ABORT);
}
/******************************************************************************
 NAME        : do_crss_ref_ur_func
 PURPOSE     : To turn CHECK_EX_FLAG flag ON or OFF
 DESCRIPTION : 
 INPUTS      : Ignored
 RETURNS     : Ignored
 NOTES       : 
 ******************************************************************************/
int do_crss_ref_usr_func(index) 
int index; 
{    
    change_popup_option(options_menu,index,option_flags);
    if(CHECK_EX_FLAG == TRUE)
      {
         CHECK_EX_FLAG = FALSE;
         option_flags[index-1] = FALSE;
      }
    else
      {
        CHECK_EX_FLAG = TRUE;
        option_flags[index-1] = TRUE;
      }
    return(MENU_ITEM_ABORT);
}
/******************************************************************************
 NAME        : do_create_defrel_file
 PURPOSE     : marking or unmarking the option flag
 DESCRIPTION : if CREATE_DEFRELS is TRUE, it will change CREATE_DEFRELS to FALSE
               and delete the Defrelation window from the queue and the screen.
	       It also unmark the option from the menu then set defrelation 
               file name to NULL.
	       Else if CREATE_DEFRELS is FALSE, it will change te flag to TRUE
               and create the window to contain the name of the defrelation
               file. It also marks the option in the menu and allows user 
               to enter the name of the defrelation.
 INPUTS      : postion of the item in the menu.
 RETURNS     : integer.
 NOTES       : It only creates the window for Defrelation after it successfully
               read the file name for Defrelation.
 ******************************************************************************/

int do_create_defrel_file(index) 
int index; 
{
  register int i, tmax;
  char str_num[10],buf[80];
    if(CREATE_DEFRELS == TRUE)
     {
        change_popup_option(options_menu,index,option_flags);
        CREATE_DEFRELS = FALSE;
        option_flags[index-1] = FALSE;
        if(delete_pop_up(def_rel_win_text) == TRUE)
          delwin(def_rel_win_text);
        else
          pop_up_warning("ERROR in DEL",MID_JUST,SILENCE,NOT_CONFIRM);
        if(delete_pop_up(def_rel_win_border) == TRUE)
          delwin(def_rel_win_border);
  	else
          pop_up_warning("ERROR in DEL",MID_JUST,SILENCE,NOT_CONFIRM);
        def_rel_win_text = NULL;
        def_rel_win_border = NULL;
        DEF_REL_WIN_IN_QUEUE = FALSE;
        def_rel_file[0] = 0;
     }
    else
     {
        if(CHECK_DEFRELS == TRUE)
            {
               pop_up_warning("Incompatible with CHECK_DEFRELS option ",
			    MID_JUST,SILENCE,NOT_CONFIRM);
               return(MENU_ITEM_ABORT);
            }
        if(pop_up_text("Enter the file name for defrelations",
			   def_rel_file,MAX_NAME-1) == NULL)
           return(MENU_ITEM_ABORT);
        sprintf(buf,"\nWould you like to change \nthe max. number of literal values?\ndefault is %d",MAX_SINGLE_LIST);
        if(pop_up_warning(buf,MID_JUST,SILENCE,CONFIRM) == YES)
          {
           tmax = MAX_SINGLE_LIST;
           MAX_SINGLE_LIST = -1;
           while(MAX_SINGLE_LIST < 0)
            {
              if(pop_up_text("Enter the maximum number. The number must be between 0 and 32767",str_num,sizeof(str_num) -1) == NULL)
                {
	          MAX_SINGLE_LIST = tmax;	        
                  return(MENU_ITEM_ABORT);
                }
              MAX_SINGLE_LIST = 5;
              for(i = 0; i < strlen (str_num) ; i++)
               {
                  if(!isdigit(str_num[i]))
		   {
		     MAX_SINGLE_LIST = -1;
		     str_num[0] = 0;
                     break;
		   }
               }
	       if(str_num[0] != 0)
		 {
                    MAX_SINGLE_LIST = atoi(str_num);
   	            if(MAX_SINGLE_LIST > 32767)
	               MAX_SINGLE_LIST = -1;
	         }
            }
          }
        if((def_rel_win_border = newwin(DEF_REL_WIN_LNS,DEF_REL_WIN_COLS,
					   DEF_REL_WIN_Y,DEF_REL_WIN_X))== NULL)
           return(MENU_ITEM_ERROR);
        if((def_rel_win_text = subwin(def_rel_win_border,DEF_REL_WIN_LNS-3,
					DEF_REL_WIN_COLS-2,DEF_REL_WIN_Y+2,
					DEF_REL_WIN_X+1))==NULL)
          {
              delwin(def_rel_win_border);
              return(MENU_ITEM_ERROR);         
          }
         xpaint(def_rel_win_border,(colors[POP_TEXT_BGD]|colors[POP_TEXT_INPUT]));
         xbox(def_rel_win_border,DB_V_LIN,DB_H_LIN,colors[POP_TEXT_BORDER]|colors[POP_TEXT_BGD]);
         wattrset(def_rel_win_border,(colors[POP_TEXT_INPUT]|colors[POP_TEXT_BGD]));
         mvwaddstr(def_rel_win_border,1,1,"Name of Defrelation File ");
         xpaint(def_rel_win_text,A_FMAGENTA|A_BWHITE);
         wattrset(def_rel_win_text,A_FMAGENTA|A_BWHITE);
         nodelay(def_rel_win_text,TRUE);
         wmove(def_rel_win_text,0,0);
         for(i=0;i< (DEF_REL_WIN_COLS-5);i++)
           {
              if(i >= strlen(def_rel_file))
                 break;
	      waddch(def_rel_win_text,def_rel_file[i]);
           }
         if(i < (strlen(def_rel_file) -1))
           waddstr(def_rel_win_text,"...");
         insert_pop_up(def_rel_win_border);
         insert_pop_up(def_rel_win_text);
         DEF_REL_WIN_IN_QUEUE = TRUE;
         change_popup_option(options_menu,index,option_flags);
         CREATE_DEFRELS = TRUE;
         option_flags[index-1] = TRUE;
     }
    return(MENU_ITEM_ABORT);
    
}
/******************************************************************************
 NAME        :	do_drib_sum
 PURPOSE     : 	Change the value of the flag.
 DESCRIPTION : 	If ANALYZE_TRACE is TRUE, the function will change the flag to
		FALSE and unmark the item in the option menu. It also dequeues 
		the window from the queue and set drib_file_name to NULL.
		Else if ANALYZE_TRACE is FALSE, the function will change the 
		flag to TRUE and mark the item from the options menu. It also
		creates the window to contain the name of the dribble file.
 INPUTS      : 	Ignored.
 RETURNS     : 	integer.
 NOTES       :  It only creates the window after it successfully read the name
		of the trace file.
 ******************************************************************************/
int do_drib_sum(index) 
int index ; 
{
    register int i;
    if(ANALYZE_TRACE == TRUE)
      {
        change_popup_option(options_menu,index,option_flags);    	
        ANALYZE_TRACE = FALSE;
        option_flags[index-1] = FALSE;
        drib_file_name[0] = EOS;
        if(delete_pop_up(drib_file_win_text) == TRUE)
          delwin(drib_file_win_text);
        else
          pop_up_warning("ERROR in DEL",MID_JUST,SILENCE,NOT_CONFIRM);
        if(delete_pop_up(drib_file_win_border) == TRUE)
          delwin(drib_file_win_border);
  	else
          pop_up_warning("ERROR in DEL",MID_JUST,SILENCE,NOT_CONFIRM);
        drib_file_win_text = NULL;
        drib_file_win_border = NULL;
        drib_file_name[0] = 0;
        DRIB_WIN_IN_QUEUE = FALSE;
      }
    else
      {
        if(pop_up_text("Enter the name of the trace file ",
			   drib_file_name,MAX_NAME-1) == NULL)
           return(MENU_ITEM_ERROR);
        if((drib_file_win_border = newwin(DRIB_WIN_LNS,DRIB_WIN_COLS,
					   DRIB_WIN_Y,DRIB_WIN_X))== NULL)
                return(MENU_ITEM_ERROR);
        if((drib_file_win_text = subwin(drib_file_win_border,DRIB_WIN_LNS-3,
					DRIB_WIN_COLS-2,DRIB_WIN_Y+2,
					DRIB_WIN_X+1))==NULL)
             {
                   delwin(drib_file_win_border);
                   return(MENU_ITEM_ERROR);         
             }
       xpaint(drib_file_win_border,(colors[POP_TEXT_BGD]|colors[POP_TEXT_INPUT]));
       xbox(drib_file_win_border,DB_V_LIN,DB_H_LIN,colors[POP_TEXT_BORDER]|colors[POP_TEXT_BGD]);
       wattrset(drib_file_win_border,colors[POP_TEXT_PROMPT]|colors[POP_TEXT_BGD]);
       mvwaddstr(drib_file_win_border,1,1,"Name of the Dribble File ");
       xpaint(drib_file_win_text,A_FMAGENTA|A_BWHITE);
       wattrset(drib_file_win_text,A_FMAGENTA|A_BWHITE);
       nodelay(drib_file_win_text,TRUE);
       wmove(drib_file_win_text,0,0);
       for(i=0;i< (DRIB_WIN_COLS-5);i++)
         {
            if(i >= strlen(drib_file_name))
               break;
            waddch(drib_file_win_text,drib_file_name[i]);
         }
       if(i < (strlen(drib_file_name) - 1))
       waddstr(drib_file_win_text,"...");
       insert_pop_up(drib_file_win_border);
       insert_pop_up(drib_file_win_text);
       DRIB_WIN_IN_QUEUE = TRUE;
       change_popup_option(options_menu,index,option_flags);
       ANALYZE_TRACE  = TRUE;
       option_flags[index-1] = TRUE;
     }
    return(MENU_ITEM_ABORT);
}

/******************************************************************************
 NAME        : do_run
 PURPOSE     : Execute CRSV
 DESCRIPTION : 
 INPUTS      : 
 RETURNS     : 
 NOTES       : 
 ******************************************************************************/

int do_run(index) 
int index; 
{

    if(drib_file_win_border != NULL)
       {
          delete_pop_up(drib_file_win_text);
          delete_pop_up(drib_file_win_border);
	  DRIB_WIN_IN_QUEUE = FALSE;
       }
    if(def_rel_win_border != NULL)
       {
          delete_pop_up(def_rel_win_text);
          delete_pop_up(def_rel_win_border);
	  DEF_REL_WIN_IN_QUEUE = FALSE;
       }
    delete_pop_up(file_win_text);
    delete_pop_up(file_win_border);
    FILE_WIN_IN_QUEUE = FALSE;
    process_main(num_files,file_list,def_rel_file,drib_file_name);
    mvcur(0,0,CRSV_Y,CRSV_X);
    return(MENU_ITEM_ABORT);
}
/******************************************************************************
 NAME        : 	do_add()
 PURPOSE     : 	Add file to the list, also upates the window.
 DESCRIPTION : 	
 INPUTS      : 	Ignored.
 RETURNS     :  MENU_ITEM_ABORT
 NOTES       : 	Also allow user to delete a file during adding
 ******************************************************************************/

int do_add(index) 
int index; 
{
   int ch,chcnt = 0,
       wincols = 1,winrows,
       quit = FALSE,diff = 2;
   char *cmdstr,*buf,*blank_str;
   register int i;


   /*==========================================*
         HACKING! to make the file_win_text,and
	 file_win_border stay at the end of the 
	 queue.
    *==========================================*/

   delete_pop_up(file_win_text);
   delete_pop_up(file_win_border);
   insert_pop_up(file_win_border);
   insert_pop_up(file_win_text);
   redisplay_wins();


   winrows = num_files + 1;
   blank_str = balloc(MAX_NAME + 1,char);
   buf = balloc(MAX_NAME + 1,char);
   for(i = 0; i < MAX_NAME +1;i++)
	blank_str[i] = ' ';
   blank_str[i] = EOS;
   mvcur(0,0,FILE_WIN_LNS+7,FILE_WIN_COLS+5);
   wmove(file_win_border,winrows+diff,1);
   xwaddch(file_win_border,(char)26);
   wmove(file_win_text,winrows,wincols);
   wrefresh(file_win_border);
   wrefresh(file_win_text);
   while (! quit)
     {
      /* =================================================
         Poll the keyboard and handle any characters there
         ================================================= */
      if ((ch = wgetch(file_win_text)) != -1)
        {
         ch = key_map(ch);
         if ((ch >= LOW_PRN_ASCII) && (ch <= HIGH_PRN_ASCII))
           {
	    if(num_files >= MAX_FILES)
              {
		mvwaddch(file_win_border,winrows+diff,1,' ');
		wrefresh(file_win_border);
                if(pop_up_warning("Maximum number of files is 10, Return to File menu ? ",MID_JUST,BEEP,CONFIRM)== YES)
                   quit = TRUE;
                else
                  {
                    wmove(file_win_border,winrows+diff,wincols);
		    xwaddch(file_win_border,(char)26);
                    wrefresh(file_win_border);
                  }
              }
            else if ((chcnt < MAX_NAME)&&(winrows > num_files))
              {
               buf[chcnt++] = ch;
               buf[chcnt] = EOS;
               waddch(file_win_text,ch);
               wrefresh(file_win_text);
              }
            else
              beep();
           }
         else 
           switch(ch)
             {
           	case DELETE:
		    if (file_list[num_files][0] == EOS)
	     		{
            		  if (chcnt != 0)
              	 	    {
               	    		buf[--chcnt] = EOS;
               	    		waddstr(file_win_text,DEL_STR);
               	    		wrefresh(file_win_text);
                 	    }
               		 else
                  		beep();
	     		}
	    	    else
			beep();
		    break;
		case NEWLINE:
	            if (chcnt != 0)
        	      {
			strcpy(file_list[num_files],buf);
			num_files++;
			mvwaddch(file_win_border,winrows+diff,1,' ');
			winrows++;
			wmove(file_win_border,winrows+diff,wincols);
			xwaddch(file_win_border,(char)26);
			wrefresh(file_win_border);
                        wmove(file_win_text,winrows,wincols);
			wrefresh(file_win_text);
			chcnt = 0;
			buf[chcnt] = 0;
              	      }
            	    else
			beep();
		    break;
		case REDRAW_CMD:
	            redisplay_wins();
        	    wrefresh(file_win_text);
        	    break;
                case UP_ARROW:
		    if((winrows > 1)&&(chcnt == 0))
	     	      {
			mvwaddch(file_win_border,winrows+diff,wincols,' ');
			winrows--;
			wmove(file_win_border,winrows+diff,wincols);
			xwaddch(file_win_border,(char)26);
			wmove(file_win_text,winrows,wincols);
			wrefresh(file_win_border);
			wrefresh(file_win_text);
	      	      }
	      	    else
			beep(); 
		    break;
		case DOWN_ARROW:
		    if((winrows < (num_files + 1))&&(chcnt == 0))
	      	      {
			mvwaddch(file_win_border,winrows+diff,wincols,' ');
			winrows++;
			wmove(file_win_border,winrows+diff,wincols);
			xwaddch(file_win_border,(char)26);
			wmove(file_win_text,winrows,wincols);
			wrefresh(file_win_border);
			wrefresh(file_win_text);
	      	      }
		    else
	     	        beep();
		    break;
		case CTRL_D:
		    if((file_list[winrows-1][0] != EOS)&&(chcnt == 0))
	      	      {	
   	        	for(i = winrows; i < (num_files) ; i++)
	  	  	  {
		   	     mvwaddstr(file_win_text,i,wincols,blank_str);
		   	     mvwaddstr(file_win_text,i,wincols,file_list[i]);
		          }
		        mvwaddstr(file_win_text,i,wincols,blank_str);
		        wmove(file_win_text,winrows,wincols);
			wrefresh(file_win_text);
	      		delete_file_from_list(file_list,winrows-1,&num_files);
               	      }
             	    else
	               beep();
	            break;
		case ESC:
			if(chcnt == 0)
			  {
			     mvwaddch(file_win_border,winrows+diff,wincols,' ');
			     wrefresh(file_win_border);
			     quit = TRUE;

			  }
			else
			  beep();
			break;
		default:
                      beep();
           } 
        } 
      } 
        
    return(MENU_ITEM_ABORT);	
}
/******************************************************************************
 NAME        : delete_file_from_list()
 PURPOSE     : Delete a file from an array of files.
 DESCRIPTION : 
 INPUTS      : array of files,index of the file to be delete,and number
	       of files in the array.
 RETURNS     : Nothing!
 NOTES       : 
 ******************************************************************************/
void delete_file_from_list(text_list,cur_text,max_text)
char text_list[MAX_FILES][MAX_NAME];
int cur_text,*max_text;

{
    register int i;
 
    for(i = cur_text; i< ((*max_text) - 1); i++)
      {
	text_list[i][0] = EOS;
	strcpy(text_list[i],text_list[i+1]);
      }
    text_list[(*max_text) - 1][0] = EOS;
    (*max_text)--;
}
/******************************************************************************
 NAME        : 	do_remove
 PURPOSE     : 	Remove a file from an array of files, and from the window too.
 DESCRIPTION : 
 INPUTS      : 	position of the item in the menu option.
 RETURNS     :  integer.
 NOTES       : 
 ******************************************************************************/
int do_remove(index) 
int index; 
{

   int ch,
       wincols= 1,winrows,
       quit = FALSE,diff = 2;
   char *blank_str;
   register int i;

   /*==========================================*
         HACKING! to make the file_win_text 
         and file_win_border stay at the end 
	 of the queue.
    *==========================================*/

   delete_pop_up(file_win_text);
   delete_pop_up(file_win_border);
   insert_pop_up(file_win_border);
   insert_pop_up(file_win_text);
   redisplay_wins();
   if(num_files == 0)
    {
       beep();
       return(MENU_ITEM_ABORT);
    }
   winrows = 1;

   /* Allocate a blank line */

   blank_str = balloc(MAX_NAME + 1,char);
   for(i = 0; i < MAX_NAME +1;i++)
	blank_str[i] = ' ';
   blank_str[i] = EOS;
   
   /* Move curses to a new position */

   mvcur(0,0,FILE_WIN_LNS+7,FILE_WIN_COLS+5);
   wmove(file_win_border,winrows+diff,wincols);
   xwaddch(file_win_border,(char)26);
   wmove(file_win_text,winrows,wincols);
   wrefresh(file_win_border);
   wrefresh(file_win_text);

   while (! quit)
     {
      /* =================================================
         Poll the keyboard and handle any characters there
         ================================================= */
      if ((ch = wgetch(file_win_text)) != -1)
        {
         ch = key_map(ch);
         switch(ch)
             {
		case REDRAW_CMD:
	            redisplay_wins();
        	    wrefresh(file_win_text);
        	    break;
                case UP_ARROW:
		    if(winrows > 1)
	     	      {
			mvwaddch(file_win_border,winrows+diff,wincols,' ');
			winrows--;
			wmove(file_win_border,winrows+diff,wincols);
			xwaddch(file_win_border,(char)26);
			wmove(file_win_text,winrows,wincols);
			wrefresh(file_win_border);
			wrefresh(file_win_text);
	      	      }
	      	    else if( num_files > 0)
	     	      {
			mvwaddch(file_win_border,winrows+diff,wincols,' ');
			winrows = num_files;
			wmove(file_win_border,winrows+diff,wincols);
			xwaddch(file_win_border,(char)26);
			wmove(file_win_text,winrows,wincols);
			wrefresh(file_win_border);
			wrefresh(file_win_text);
	      	      }
		    break;
		case DOWN_ARROW:
		    if(winrows < num_files)
	      	      {
			mvwaddch(file_win_border,winrows+diff,wincols,' ');
			winrows++;
			wmove(file_win_border,winrows+diff,wincols);
			xwaddch(file_win_border,(char)26);
			wmove(file_win_text,winrows,wincols);
                        wrefresh(file_win_border);
			wrefresh(file_win_text);
	      	      }
		    else if(num_files > 0)
                      {
			mvwaddch(file_win_border,winrows+diff,wincols,' ');
			winrows = 1;
			wmove(file_win_border,winrows+diff,wincols);
			xwaddch(file_win_border,(char)26);
			wmove(file_win_text,winrows,wincols);
                        wrefresh(file_win_border);
			wrefresh(file_win_text);
	      	      }
		    break;
		case NEWLINE:
		     if(file_list[winrows-1][0] != EOS)
	      	      {	
         	        for(i = winrows; i < num_files ; i++)
	  	  	    {
		   	      mvwaddstr(file_win_text,i,wincols,blank_str);
		   	      mvwaddstr(file_win_text,i,wincols,file_list[i]);
		            }
 		        mvwaddstr(file_win_text,i,wincols,blank_str);
		        delete_file_from_list(file_list,winrows - 1,&num_files);
                        if((winrows > num_files)&&(num_files > 0))
                          {
                            mvwaddch(file_win_border,winrows+diff,wincols,' ');
                            winrows = num_files;                            
                            wmove(file_win_border,winrows+diff,wincols);
                            xwaddch(file_win_border,(char)26);
                            wrefresh(file_win_border);
			  }
		        wmove(file_win_text,winrows,wincols);
			wrefresh(file_win_text);
               	      }
             	    else
	               beep();
	            break;
		case ESC:
			quit = TRUE;
                        mvwaddch(file_win_border,winrows+diff,wincols,' ');
			break;
		default:
                      beep();
           } 
        } 
    } 
    return(MENU_ITEM_ABORT);	
}
/******************************************************************************
 NAME        : 	do_move_up()
 PURPOSE     : 	moves a file in an array of files to the top, also moves it 
		to the top of the window too.
 DESCRIPTION :  
 INPUTS      : 	Ignored.
 RETURNS     :  MENU_ITEM_ABORT.
 NOTES       : 
 ******************************************************************************/
int do_move_up(index)
int index;
{

   int ch,
       wincols= 1,winrows,
       quit = FALSE,diff = 2;
   char *blank_str;
   register int i;

   /*==========================================*
         HACKING! to make the file_win_text 
         and file_win_border stay at the end 
	 of the queue.
    *==========================================*/

   delete_pop_up(file_win_text);
   delete_pop_up(file_win_border);
   insert_pop_up(file_win_border);
   insert_pop_up(file_win_text);
   redisplay_wins();
   if(num_files > 0)
     winrows = num_files;
   else
     {
       beep();
       return(MENU_ITEM_ABORT);
     }

   /* ALlocate a blank line for reinitialize */

   blank_str = balloc(MAX_NAME + 1,char);
   for(i = 0; i < MAX_NAME +1;i++)
	blank_str[i] = ' ';
   blank_str[i] = EOS;

   /* Move curses to a new position */

   mvcur(0,0,FILE_WIN_LNS+7+num_files,FILE_WIN_COLS+5);
   wmove(file_win_border,winrows+diff,wincols);
   xwaddch(file_win_border,(char)26);
   wrefresh(file_win_border);
   wmove(file_win_text,winrows,wincols);
   wrefresh(file_win_text);

   while (! quit)
     {
      /* =================================================
         Poll the keyboard and handle any characters there
         ================================================= */
      if ((ch = wgetch(file_win_text)) != -1)
        {
         ch = key_map(ch);
         switch(ch)
             {
		case REDRAW_CMD:
	            redisplay_wins();
        	    wrefresh(file_win_text);
		    wrefresh(file_win_border);
        	    break;
                case UP_ARROW:
		    if(winrows > 1)
	     	      {
			mvwaddch(file_win_border,winrows+diff,wincols,' ');
			winrows--;
			wmove(file_win_border,winrows+diff,wincols);
			xwaddch(file_win_border,(char)26);
			wrefresh(file_win_border);
			wmove(file_win_text,winrows,wincols);
			wrefresh(file_win_text);
	      	      }
	      	    else if( num_files > 0)
	     	      {
			mvwaddch(file_win_border,winrows+diff,wincols,' ');
			winrows = num_files;
			wmove(file_win_border,winrows+diff,wincols);
			xwaddch(file_win_border,(char)26);
			wrefresh(file_win_border);
			wmove(file_win_text,winrows,wincols);
			wrefresh(file_win_text);
	      	      }
		    break;
		case DOWN_ARROW:
		    if(winrows < num_files )
	      	      {
			mvwaddch(file_win_border,winrows+diff,wincols,' ');
			winrows++;
			wmove(file_win_border,winrows+diff,wincols);
			xwaddch(file_win_border,(char)26);
                        wrefresh(file_win_border);
			wmove(file_win_text,winrows,wincols);
			wrefresh(file_win_text);
	      	      }
		    else if(num_files > 0)
	      	      {
			mvwaddch(file_win_border,winrows+diff,wincols,' ');
			winrows = 1;
			wmove(file_win_border,winrows+diff,wincols);
			xwaddch(file_win_border,(char)26);
                        wrefresh(file_win_border);
			wmove(file_win_text,winrows,wincols);
			wrefresh(file_win_text);
	      	      }
		    break;
		case NEWLINE:
		    if(file_list[winrows-1][0] != EOS)
	      	      {	
   	        	for(i = winrows;i > 1 ; i--)
	  	  	  {
		   	     mvwaddstr(file_win_text,i,wincols,blank_str);
		   	     mvwaddstr(file_win_text,i,wincols,file_list[i-2]);
		          }
		        mvwaddstr(file_win_text,i,wincols,blank_str);
                        mvwaddstr(file_win_text,i,wincols,file_list[winrows-1]);
			mvwaddch(file_win_border,winrows+diff,wincols,' ');
		        wmove(file_win_border,3,wincols);
                        xwaddch(file_win_border,(char)26);
			wrefresh(file_win_border);
			wmove(file_win_text,1,wincols);
 			wrefresh(file_win_text);
	      		exchange_file_from_list(file_list,winrows-1,0);
                        winrows = 1;
               	      }
             	    else
	               beep();
	            break;
		case ESC:
 		    quit = TRUE;
		    mvwaddch(file_win_border,winrows+diff,wincols,' ');
		    break;
		default:
                      beep();
           } 
        } 
      } 
  return(MENU_ITEM_ABORT);
}
/******************************************************************************
 NAME        : 	do_move_down
 PURPOSE     : 	Moves a file to the bottom of the file list, updates the window
		also.
 DESCRIPTION : 
 INPUTS      :  Ignored
 RETURNS     : 
 NOTES       : 
*****************************************************************************/
int do_move_down(index)
int index;
{

   int ch,
       wincols= 1,winrows,
       quit = FALSE,diff = 2;
   char *blank_str;
   register int i;

   /*==========================================*
         HACKING! to make the file_win_text 
         and file_win_border stay at the end 
	 of the queue.
    *==========================================*/

   delete_pop_up(file_win_text);
   delete_pop_up(file_win_border);
   insert_pop_up(file_win_border);
   insert_pop_up(file_win_text);
   redisplay_wins();
   if(num_files == 0)
    {
      beep();
      return(MENU_ITEM_ABORT);
    }
   winrows = 1;

   /* Allocate a blank line */

   blank_str = balloc(MAX_NAME + 1,char);
   for(i = 0; i < MAX_NAME +1;i++)
	blank_str[i] = ' ';
   blank_str[i] = EOS;

   /* Move the curses to the new position */

   mvcur(0,0,FILE_WIN_LNS+7,FILE_WIN_COLS+5);
   wmove(file_win_border,winrows+diff,wincols);
   xwaddch(file_win_border,(char)26);
   wrefresh(file_win_border);
   wmove(file_win_text,winrows,wincols);
   wrefresh(file_win_text);

   while (! quit)
     {
      /* =================================================
         Poll the keyboard and handle any characters there
         ================================================= */
      if ((ch = wgetch(file_win_text)) != -1)
        {
         ch = key_map(ch);
         switch(ch)
             {
		case REDRAW_CMD:
	            redisplay_wins();
        	    wrefresh(file_win_text);
        	    break;
                case UP_ARROW:
		    if(winrows > 1)
	     	      {
			mvwaddch(file_win_border,winrows+diff,wincols,' ');
			winrows--;
			wmove(file_win_border,winrows+diff,wincols);
			xwaddch(file_win_border,(char)26);
			wrefresh(file_win_border);
			wmove(file_win_text,winrows,wincols);
			wrefresh(file_win_text);
	      	      }
	      	    else if(num_files > 0)
	     	      {
			mvwaddch(file_win_border,winrows+diff,wincols,' ');
			winrows = num_files;
			wmove(file_win_border,winrows+diff,wincols);
			xwaddch(file_win_border,(char)26);
			wrefresh(file_win_border);
			wmove(file_win_text,winrows,wincols);
			wrefresh(file_win_text);
	      	      }
		    break;
		case DOWN_ARROW:
		    if(winrows < num_files )
	      	      {
			mvwaddch(file_win_border,winrows+diff,wincols,' ');
			winrows++;
			wmove(file_win_border,winrows+diff,wincols);
			xwaddch(file_win_border,(char)26);
			wrefresh(file_win_border);
			wmove(file_win_text,winrows,wincols);
			wrefresh(file_win_text);
	      	      }
		    else if (num_files > 0)
                     {
			mvwaddch(file_win_border,winrows+diff,wincols,' ');
			winrows = 1;
			wmove(file_win_border,winrows+diff,wincols);
			xwaddch(file_win_border,(char)26);
			wrefresh(file_win_border);
			wmove(file_win_text,winrows,wincols);
			wrefresh(file_win_text);
	      	      }
		    break;
		case NEWLINE:
		    if(file_list[winrows-1][0] != EOS)
	      	      {	
			mvwaddch(file_win_border,winrows+diff,wincols,' ');
   	        	for(i = winrows;i < num_files ; i++)
	  	  	  {
		   	     mvwaddstr(file_win_text,i,wincols,blank_str);
		   	     mvwaddstr(file_win_text,i,wincols,file_list[i]);
		          }
		        mvwaddstr(file_win_text,i,wincols,blank_str);
                        mvwaddstr(file_win_text,i,wincols,file_list[winrows-1]);
                        wmove(file_win_border,num_files+diff,wincols);
                        xwaddch(file_win_border,(char)26);
			wrefresh(file_win_border);
		        wmove(file_win_text,num_files,wincols);
                        wrefresh(file_win_text);
	      		exchange_file_from_list(file_list,winrows-1,
							num_files - 1);
                        winrows = num_files;
               	      }
             	    else
	               beep();
	            break;
		case ESC:
		     quit = TRUE;
                     mvwaddch(file_win_border,winrows+diff,wincols,' ');
  		     break;
		default:
                      beep();
           } 
        } 
      } 

   return(MENU_ITEM_ABORT);
}

/******************************************************************************
 NAME        : 	exchange_file_from_list()
 PURPOSE     : 	change the position of a file to a new position in the file list.
 DESCRIPTION : 
 INPUTS      : 	File_list: array of files;
		current_position;
		new_position;
 RETURNS     : 	Nothing!
 NOTES       : 
 ******************************************************************************/
void exchange_file_from_list(file_list,current_pos,new_pos)
char file_list[MAX_FILES][MAX_NAME];
int current_pos,new_pos;
{
    char buf[MAX_NAME];
    register int i;

    buf[0] = EOS;
    strcpy(buf,file_list[current_pos]);
    if(current_pos > new_pos)
     {
        for (i = current_pos; i > new_pos; i--)
          {
             file_list[i][0] = EOS;
             strcpy(file_list[i],file_list[i-1]);
          }
        file_list[i][0] = EOS;
        strcpy(file_list[i],buf);
     }
    else if(current_pos < new_pos)
     {
        for(i = current_pos; i < new_pos; i++)
          {
             file_list[i][0] = EOS;
             strcpy(file_list[i],file_list[i+1]);
          }
        file_list[i][0] = EOS;
        strcpy(file_list[i],buf);
     }
}
/******************************************************************************
 NAME        : 	change_on_off_option()
 PURPOSE     : 	Mark an item from a menu to whatever Buf is(On or Off).
 DESCRIPTION : 
 INPUTS      : 	The menu containing the item;
		The row position of the item;
		The column position of the item that will be overwrite
		with the new mark;
		The character pointer containing the new mark("On" or "Off")..
 RETURNS     : 	Nothing!
 NOTES       : 
 ******************************************************************************/
void change_on_off_option(menu,item,cols,buf)
MENU  *menu;
int   item;
int cols;
char *buf;
{
   wmove(menu->text,item-1,cols);
   wattrset(menu->text,winat(menu->text));
   waddstr(menu->text,buf);
   wmove(menu->text,item-1,0);
}

/******************************************************************************
 NAME        : 	Do_dribble()
 PURPOSE     : 	Allows everything written to the screen will also be written
		to a file.
 DESCRIPTION : 
 INPUTS      : 	Ignored
 RETURNS     : 	MENU_ITEM_ERROR or MENU_ITEM_ABORT
 NOTES       : 
 ******************************************************************************/

int do_dribble(index) 
int index; 
{
    char buf[MAX_NAME];
    
    if(drib_fp == NULL)
       {
          change_on_off_option(file_menu,index,12,"Off");
          if(pop_up_text("Enter The File Name",buf,MAX_NAME-1) == NULL)
            {
               change_on_off_option(file_menu,index,12,"On ");
               return(MENU_ITEM_ABORT);
            }
          if((drib_fp = fopen(buf,"w")) == NULL)
            return(MENU_ITEM_ERROR);
       }
    else
       {
          change_on_off_option(file_menu,index,12,"On ");
          fclose(drib_fp);
          drib_fp = NULL;
       }
    return(MENU_ITEM_ABORT);	
}

/******************************************************************************
 NAME        : do_exit
 PURPOSE     : CRSV (exit)
 DESCRIPTION : 
 INPUTS      : Ignored.
 RETURNS     : MENU_ITEM_ABORT or MENU_ITEM_COMPLETION
 NOTES       : None
 ******************************************************************************/
int do_exit(index)
  int index;
  {
   int query;

   query = pop_up_warning("\nWARNING!\n\nDo you really want to\nExit CRSV?",
                           MID_JUST,SILENCE,CONFIRM);
   if (query == NO)
     return(MENU_ITEM_ABORT);
   if(drib_fp != NULL)
       fclose(drib_fp);
   stop_interface(0);
   end_crsv();
   return(MENU_ITEM_COMPLETION);
  }



