/* ************************************************************************
 * FILE : PCINT.H
 * This file contains the macros, constants, and definitions used
 * in the PC interface to CRSV.
 * ************************************************************************
 */

/* ---------------------- Various Useful Constants -------------------------- */

#define FORMFEED         '\f'
#define CRGRTN           '\r'
#define BLANK            ' '
#define DELETE           '\b'
#define ESC              '\033'

#define DEL_STR          "\b \b"

#define LOW_PRN_ASCII    ' '
#define HIGH_PRN_ASCII   '~'


/* -------------------- Dynamic Memory Access Macros ------------------------ */

extern char *gen_alloc();
extern void  gen_free();

#define balloc(nm,bk)       ((bk *) gen_alloc(sizeof(bk)*((unsigned)nm),"balloc"))
#define release(nm,bk,ad)   gen_free((char *)ad, nm*sizeof(bk))


/* --------------- Color Array Map Size and Indices ------------------------ */

#define BGD_MSK 0x0fff
#define FGD_MSK 0xf0ff
#define HGH_MSK 0xf7ff

#define flip_fgd_bgd(attr)  ((((attr) & BGD_MSK & HGH_MSK) << 4) | \
                            (((attr) & FGD_MSK) >> 4))

#define bgd_reverse(bgd)    ((~bgd & 0x7000) >> 4)
#define fgd_reverse(fgd)    ((~fgd & 0x0700) << 4)

#define fgd_color(i)        ((i & 0x000f) << 8)
#define bgd_color(i)        ((i & 0x0007) << 12)

#define fgd_index(clr)      ((clr & 0x0f00) >> 8)
#define bgd_index(clr)      ((clr & 0x7000) >> 12)

#define MAX_FGDS        16
#define MAX_BGDS        8

#define MAX_COLOR_DEFS  22
#define MAX_MAIN_SCREEN 14

#define WFOOTER         0
#define STDIN           1
#define MAIN_BACKGD     2
#define MAIN_BORDER     3
#define ADVERTISE       4
#define MAIN_MENU_BGD   5
#define MAIN_MENU_TEXT  6
#define MORE_MSG        7
#define POP_MENU_BGD    8
#define POP_MENU_BORDER 9
#define POP_MENU_TEXT   10
#define POP_TEXT_BGD    11
#define POP_TEXT_BORDER 12
#define POP_TEXT_PROMPT  13
#define POP_TEXT_INPUT  14
#define POP_WARN_BGD    15
#define POP_WARN_BORDER 16
#define POP_WARN_TEXT   17
#define POP_FILE_BGD    18
#define POP_FILE_BORDER 19
#define POP_FILE_TEXT   20
#define POP_FILE_MOUSE  21

#ifndef COLOR_SOURCE

extern ch_attr colors[MAX_COLOR_DEFS];   /* Screen Interface Colors */

#endif


/* -------------------- Various window constants --------------------------- */

#define FILE_INDEX 0
#define OPTS_INDEX 1
#define EXEC_INDEX 2
#define SPE_INDEX  3
#define HELP_INDEX 4
#define hide_cursor()   mvcur(0,0,LINES,0)
                        /* This is a hack trick to hide the cursor on
                           IBM-PC compatible terminals - it moves the
                           cursor to a non-existent line */

#ifndef CRSVWIN_SOURCE

extern void redisplay_wins(void);       /* Redraws entire screen         */
extern int  insert_pop_up(WINDOW *);    /* Puts window in pop-up queue   */
extern int  delete_pop_up(WINDOW *);     /* Takes the specific window from queue  */


#endif

/*----------------------------------------------------------------------
 * Queue block structure for placing/removing windows on/from the
 * physical screen -- a queue is formed of all pop-up windows
 * currently on the screen (this does not include the main windows which
 * are always present).  On a complete redraw of the screen, the
 * main windows are first redrawn, and then this queue is followed
 * in order.  Thus, "removing" a window from the screen becomes a simple
 * task : simply remove it from the queue and then redraw the screen
 *   As expected, insertions/deletions can only occur at the end of the
 * queue 
 * ---------------------------------------------------------------------- 
 */
typedef struct window_block
  {
   WINDOW *win;               /* Window in the queue            */
   struct window_block *prv,  /* Pointer to the previous window */
                       *nxt;  /* Pointer to the next window     */
  } WINBLK;


/* -------------------- Key definition constants --------------------------- */

#define CTRL_A      0001
#define CTRL_B      0002
#define CTRL_C      0003
#define CTRL_D      0004
#define CTRL_E      0005
#define CTRL_F      0006
#define CTRL_G      0007
#define CTRL_H      0010
#define CTRL_I      0011
#define CTRL_J      0012
#define CTRL_K      0013
#define CTRL_L      0014
#define CTRL_M      0015
#define CTRL_N      0016
#define CTRL_O      0017
#define CTRL_P      0020
#define CTRL_Q      0021
#define CTRL_R      0022
#define CTRL_S      0023
#define CTRL_T      0024
#define CTRL_U      0025
#define CTRL_V      0026
#define CTRL_W      0027
#define CTRL_X      0030
#define CTRL_Y      0031
#define CTRL_Z      0032
/* ESCAPE is Octal 33 -- Defined in COMMON.H */
#define CTRL_SLASH  0034
#define CTRL_BRACK  0035
#define CTRL_HAT    0036
#define CTRL_SCORE  0037

#define MAX_IBMPC_KEY 359

/* --------------------------------------------------------
   Extended Action Codes for CLIPS Window Interface Actions
   -------------------------------------------------------- */

#define EXT_MASK     0x80         /* Extened-bit part of char code            */

#define LEFT_ARROW  (0|EXT_MASK)  /* Main menu selection                      */
#define RIGHT_ARROW (1|EXT_MASK)  /* Main menu selection                      */
#define UP_ARROW    (2|EXT_MASK)  /* Pop-up menu selection/buffer scroll      */
#define DOWN_ARROW  (3|EXT_MASK)  /* Pop-up menu selection/buffer scroll      */
#define PAGE_UP     (4|EXT_MASK)  /* Buffer scroll                            */
#define PAGE_DOWN   (5|EXT_MASK)  /* Buffer scroll                            */
#define BUFFER_TOP  (6|EXT_MASK)  /* Buffer scroll                            */
#define BUFFER_END  (7|EXT_MASK)  /* Buffer scroll                            */
#define MAIN_MENU   (8|EXT_MASK)  /* Activate current main menu selection     */
#define EXIT_TO_OS  (9|EXT_MASK)  /* Premature abortion of CRSV to DOS       */
#define REDRAW_CMD  (10|EXT_MASK) /* Forces a refresh of the screen           */
#define CLEAR_WIN   (11|EXT_MASK) /* Forces the screen to be erased           */
#define RUN_CMD     (12|EXT_MASK) /* Equivalent to CRSV (run)                */
#define HELP_CMD    (13|EXT_MASK) /* Help request                             */
#define FILE_MENU   (14|EXT_MASK) /* Call up File Menu                        */
#define SPEC_MENU   (15|EXT_MASK)
#define OPTION_MENU (16|EXT_MASK) /* Call up Options Menu                     */

#define DO_NOTHING  (17|EXT_MASK)
#define BAD_KEY     (18|EXT_MASK) 



#define MAX_CNTRL_KEYS 32
#define MAX_EXTND_KEYS 99

#ifndef KEY_SOURCE

extern int key_map(int);

extern unsigned char keyctab[],
                     keyextab[];

#endif


/* ------------- Menu, pop-up warning, and pop-up text entry stuff ------- */

/* -------------------------------------------
   Code returned by cancelled or invalid menus
   ------------------------------------------- */
#define MENU_ABORT 0

/* ----------------------------------------------
   Menu Item Handler Routines Status Return Codes
   ---------------------------------------------- */
#define MENU_ITEM_CRSV_INPUT 2
#define MENU_ITEM_COMPLETION  1
#define MENU_ITEM_ABORT       0
#define MENU_ITEM_ERROR      -1
/* -----------------------------
   mew_menu() Visual Image Codes
   ----------------------------- */
#define VISUAL_POP_UP_MENU_NO  0  /* Visual display is already taken care of */
#define VISUAL_POP_UP_MENU_YES 1  /* Allocate a pop-up window for menu       */

/* ------------------------------------------
   Pop-up warning message justification codes
   ------------------------------------------ */
#define LFT_JUST 0
#define MID_JUST 1
#define RGT_JUST 2

/* ---------------------------------
   Pop-up warning message bell codes
   --------------------------------- */
#define SILENCE  0
#define BEEP     1

/* ---------------------------------
   Confirm messgae code
 * ---------------------------------*/
#define CONFIRM     1
#define NOT_CONFIRM 0

/* ---------------
   Menu item type
   --------------- */
typedef struct menu_item
  {
   char *name;                      /* Name of the menu item            */
   int  (*handler)(int);             /* Address of the handler routine   */
  } MENU_ITEM;

/* ---------------
   Menu type
   --------------- */
typedef struct menu
  {
   int item_cnt;         /* Number of items in a menu               */
   MENU_ITEM **items;    /* List of menu items and handler routines */
   WINDOW *border,       /* Visual menu representation - the border */
          *text;         /* The actual selection text - this window 
                            is a sub-window of the first            */
  } MENU;

#ifndef MENU_SOURCE

extern MENU *new_menu(int,int,...);
extern int  create_visual_menu(MENU *);
extern void draw_pop_up_menu(MENU *);
extern MENU *kill_menu(MENU *);

extern int  activate_pop_up_menu(MENU *,int,int,int *);

extern int  pop_up_warning(char *,int,int,int);
extern char *pop_up_text(char *,char *,int);

#endif
