/* =======================================================================
   ***********************************************************************
                                CONSTANTS
   ***********************************************************************
   ======================================================================= */

   
/* Screen Dimensions */

/* Screen-Map (Not to scale)

          HEADER WIN (Top 3 lines)
   +--------+----------------------------+
   | AD-WIN |         MAIN_MENU_WIN      |
   +--------+----------------------------+
  L|                                     |R
  B|                                     |B
  O|                                     |O
  R|              CRSV WIN              |R
  D|                                     |D
   |                                     |
   |                                     |
   +-------------------------------------+
              FOOTER (Bottom 1 line)

*/

#define HDR_LNS         3
#define HDR_COLS        80
#define HDR_Y           0
#define HDR_X           0

#define CRSV_LOGO      "CRSV"

#define AD_LNS          1
#define AD_COLS         7
#define AD_Y            1
#define AD_X            1

#define MN_MENU_LNS     1
#define MN_MENU_COLS    HDR_COLS-AD_COLS-3
#define MN_MENU_Y       1
#define MN_MENU_X       AD_COLS+2

/* LBORD_LNS is defined in terms of how many lines there are on the screen */
#define LBORD_COLS      1
#define LBORD_Y         3
#define LBORD_X         0

/* LBORD_LNS is defined in terms of how many lines there are on the screen */
#define RBORD_COLS      1
#define RBORD_Y         3
#define RBORD_X         79

#define FTR_LNS         1
#define FTR_COLS        80
/* FTR_Y is defined in terms of how many lines there are on the screen */
#define FTR_X           0

/* CRSV_LNS is defined in terms of how many lines there are on the screen */
#define CRSV_COLS      78
#define CRSV_Y         3
#define CRSV_X         1

#define FILE_WIN_LNS   5    /* Starting position of file window */
#define FILE_WIN_COLS  2
#define DRIB_WIN_X     FILE_WIN_COLS+MAX_NAME+8
#define DRIB_WIN_Y     FILE_WIN_LNS
#define DRIB_WIN_LNS   4
#define DRIB_WIN_COLS  28

#define DEF_REL_WIN_X     DRIB_WIN_X
#define DEF_REL_WIN_Y     FILE_WIN_LNS+DRIB_WIN_LNS+4
#define DEF_REL_WIN_LNS   4
#define DEF_REL_WIN_COLS  28

/* about CRSV window */

#define ABOUT_CRSV_LNS  14
#define ABOUT_CRSV_COLS 36
#define ABOUT_CRSV_X    (CRSV_COLS - ABOUT_CRSV_COLS)/2
#define ABOUT_CRSV_Y    5

#define PAGE_LEN        21
#define CRSV_PAD_LNS    63   /* 3 pages of 21 lines each */

/* CRSV Window Scrolling Command Codes */
#define UP              0
#define DOWN            1
#define TOP             2
#define BOTTOM          3

/* -------------------------------------------------
   Keyboard Buffer Size for getc/ungetc simulations
   ------------------------------------------------- */
#define UNGET_BUF_SIZE     256

