#define CTRL_A      0001
#define CTRL_B      0002
#define CTRL_C      0003
#define CTRL_D      0004
#define CTRL_E      0005
#define CTRL_F      0006
#define CTRL_G      0007
#define CTRL_H      0010
#define CTRL_I      0011
#define CTRL_J      0012
#define CTRL_K      0013
#define CTRL_L      0014
#define CTRL_M      0015
#define CTRL_N      0016
#define CTRL_O      0017
#define CTRL_P      0020
#define CTRL_Q      0021
#define CTRL_R      0022
#define CTRL_S      0023
#define CTRL_T      0024
#define CTRL_U      0025
#define CTRL_V      0026
#define CTRL_W      0027
#define CTRL_X      0030
#define CTRL_Y      0031
#define CTRL_Z      0032

/* ESCAPE is Octal 33 -- Defined in COMMON.H */

#define CTRL_SLASH  0034
#define CTRL_BRACK  0035
#define CTRL_HAT    0036
#define CTRL_SCORE  0037

#define MAX_IBMPC_KEY 359

/* ------------------------------------------------------------

   Extended Action Codes for CLIPS Window Interface Actions

   The maximum possible number of actions is Hex 7F (or
   Decimal 127) since the action code must be stored in 1-byte
   and the high-order bit is reserved for an extension flag.
   In addition, the last two codes Hex 7E and 7F are reserved
   for the special DO_NOTHING and BAD_KEY codes.  Thus,
   key-action codes may only range from Hex 0 to 7D (or Decimal
   0 to 125) inclusive.

   IMPORTANT!!!!! -- When adding new key-binding codes (if any)
   Be sure to add them at the end right before the DO_NOTHING
   action to insure backwards compatibility with data files
   generated by previous versions of CLIPSWIN & CLPSUTIL

   It is important that the key-codes proceed sequentially for
   the corresponding action-name-array in KEY.C which is used
   in CLPSUTIL

   ------------------------------------------------------------ */

#define EXT_MASK     0x80         /* Extened-bit part of char code            */

#define LEFT_ARROW  (0|EXT_MASK)  /* Main menu selection                      */
#define RIGHT_ARROW (1|EXT_MASK)  /* Main menu selection                      */
#define UP_ARROW    (2|EXT_MASK)  /* Pop-up menu selection/buffer scroll      */
#define DOWN_ARROW  (3|EXT_MASK)  /* Pop-up menu selection/buffer scroll      */
#define PAGE_UP     (4|EXT_MASK)  /* Buffer scroll                            */
#define PAGE_DOWN   (5|EXT_MASK)  /* Buffer scroll                            */
#define BUFFER_TOP  (6|EXT_MASK)  /* Buffer scroll                            */
#define BUFFER_END  (7|EXT_MASK)  /* Buffer scroll                            */
#define MAIN_MENU   (8|EXT_MASK)  /* Activate current main menu selection     */
#define EXIT_TO_OS  (9|EXT_MASK)  /* Premature abortion of tutor to DOS       */
#define REDRAW_CMD  (10|EXT_MASK) /* Forces a refresh of the screen           */
#define CLEAR_WIN   (11|EXT_MASK) /* Forces the screen to be erased           */
#define LOAD_CMD    (12|EXT_MASK) /* Equivalent to CLIPS (load <file>)        */
#define RESET_CMD   (13|EXT_MASK) /* Equivalent to CLIPS (reset)              */
#define RUN_CMD     (14|EXT_MASK) /* Equivalent to CLIPS (run)                */
#define STEP_CMD    (15|EXT_MASK) /* Equivalent to CLIPS (run <limit>)        */
#define HELP_CMD    (16|EXT_MASK) /* Help request                             */
#define DBG_TOGGLE  (17|EXT_MASK) /* Toggles between (watch/unwatch all)      */
#define DOS_CMD     (18|EXT_MASK) /* Executes a single DOS command            */
#define SPAWN_CLI   (19|EXT_MASK) /* Starts up a new COMMAND.COM              */
#define TOGGLE_MORE (20|EXT_MASK) /* Toggles --More-- Facility On/Off         */
#define EXEC_MENU   (21|EXT_MASK) /* Call up Execution menu                   */
#define DBG_MENU    (22|EXT_MASK) /* Call up Debug Menu                       */
#define FILE_MENU   (23|EXT_MASK) /* Call up File Menu                        */
#define ACTION_MENU (24|EXT_MASK) /* Call up Action Menu                      */
#define EXAM_MENU   (25|EXT_MASK) /* Call up Examine Menu                     */
#define OPTION_MENU (26|EXT_MASK) /* Call up Options Menu                     */
#define DESCRIBE_KEY (27|EXT_MASK) /* Describe action for key                 */

#define DO_NOTHING  (126|EXT_MASK)
#define BAD_KEY     (127|EXT_MASK) 

#define MAX_CNTRL_KEYS 32
#define MAX_EXTND_KEYS 99

#ifndef KEY_SOURCE

#if ENVIRONMENT_UTILITY
extern void bind_keys(void);
#endif

extern int key_map(int);
extern char *key_action(int);

extern unsigned char keyctab[],
                     keyextab[];

#endif
