/* --------------- CLIPS Compiler/System Configuration File ----------------- */
#include "setup.h"

/*************************************************************************/
/* MOUSE : Set this flag is you want the IBM-PC interface to make use of */
/*         a Mouse Systems PC-Mouse (if it is available).                */
/*         If this flag is off, it will save you ~3.6K.                  */
/*************************************************************************/
#define MOUSE 1

/*************************************************************************/
/* ENVIRONMENT_UTILITY : Set this flag to conform the object modules for */
/* the color-setting/key-binding facility.  This flag should NOT be set  */
/* when compiling the actual interface!                                  */
/*************************************************************************/
#define ENVIRONMENT_UTILITY 0

/* ------------------- Standard Library Header Files ------------------------ */

#include <stdio.h>       /* Standard terminal interface routines  */
#include <stdlib.h>      /* Standard C-library interface routines */
#include <string.h>      /* String manipulation routines          */

#if IBM_TBC
#include <alloc.h>       /* Memory allocation stuff               */
#endif
#if IBM_MSC
#include <malloc.h>       /* Memory allocation stuff               */
#endif

#if ! ENVIRONMENT_UTILITY

/* ---------------------- CLIPS Memory Functions ---------------------------- */

extern char *genalloc(int);
extern int genfree(char *,int);
extern char *genrealloc(char *,unsigned,unsigned);

#endif


/* ---------------------- Various Useful Constants -------------------------- */

#define TRUE             1
#define FALSE            0
#define ERROR            -1

#define YES              1
#define NO               0 

#define ON               1
#define OFF              0

#define EOS              '\0'
#define NEWLINE          '\n'
#define FORMFEED         '\f'
#define CRGRTN           '\r'
#define BLANK            ' '
#define TAB              '\t'
#define DELETE           '\b'
#define ESC              '\033'

#define DEL_STR          "\b \b"

#define LOW_PRN_ASCII    ' '
#define HIGH_PRN_ASCII   '~'

/* -------------------- Dynamic Memory Access Macros ------------------------ */

#if ! ENVIRONMENT_UTILITY

#define salloc(bk)             (struct bk *) genalloc (sizeof(struct bk))
#define balloc(nm,bk)          (bk *) genalloc (sizeof(bk)*((unsigned) nm))
#define ralloc(bk,ad,osz,nsz)  (bk *) genrealloc (((char *) ad), \
                                            ((unsigned) osz),((unsigned) nsz))
#define release(nm,bk,ad)       genfree((char *) ad,nm*sizeof(bk))

#else

#define salloc(bk)             (struct bk *) malloc (sizeof(struct bk))
#define balloc(nm,bk)          (bk *) malloc (sizeof(bk)*((unsigned) nm))
#define ralloc(bk,ad,osz,nsz)  (bk *) realloc (((char *) ad),((unsigned) nsz))
#define release(nm,bk,ad)      free((char *) ad)

#endif



/* ----------------------- Bit Manipulation Macros -------------------------- */

#define testbit(x,b)                (x & (1L << b))
#define setbit(x,b)                 (x | (1L << b))
#define clearbit(x,b)               (x & ~(1L << b))
