/* Color Array Map Size and Indices */

#define BGD_MSK 0x0fff
#define FGD_MSK 0xf0ff
#define HGH_MSK 0xf7ff

#define flip_fgd_bgd(attr)  ((((attr) & BGD_MSK & HGH_MSK) << 4) | \
                            (((attr) & FGD_MSK) >> 4))

#define bgd_reverse(bgd)    ((~bgd & 0x7000) >> 4)
#define fgd_reverse(fgd)    ((~fgd & 0x0700) << 4)

#define fgd_color(i)        ((i & 0x000f) << 8)
#define bgd_color(i)        ((i & 0x0007) << 12)

#define fgd_index(clr)      ((clr & 0x0f00) >> 8)
#define bgd_index(clr)      ((clr & 0x7000) >> 12)

#define MAX_FGDS        16
#define MAX_BGDS        8

#define MAX_COLOR_DEFS  30
#define MAX_MAIN_SCREEN 14

#define WCLIPS          0
#define WDIALOG         1
#define WDISPLAY        2
#define WERROR          3
#define WTRACE          4
#define WAGENDA         5
#define STDIN           6
#define STDOUT          7
#define MAIN_BACKGD     8
#define MAIN_BORDER     9
#define ADVERTISE       10
#define MAIN_MENU_BGD   11
#define MAIN_MENU_TEXT  12
#define MEMORY_MSG      13
#define WATCH_MSG       14
#define MORE_MSG        15
#define POP_MENU_BGD    16
#define POP_MENU_BORDER 17
#define POP_MENU_TEXT   18
#define POP_TEXT_BGD    19
#define POP_TEXT_BORDER 20
#define POP_TEXT_PROMPT 21
#define POP_TEXT_INPUT  22
#define POP_WARN_BGD    23
#define POP_WARN_BORDER 24
#define POP_WARN_TEXT   25
#define POP_FILE_BGD    26
#define POP_FILE_BORDER 27
#define POP_FILE_TEXT   28
#define POP_FILE_MOUSE  29

#ifndef COLOR_SOURCE

extern ch_attr colors[MAX_COLOR_DEFS],
               mono[MAX_COLOR_DEFS];

#if ENVIRONMENT_UTILITY
extern void set_colors(void);
#endif

#endif
