   /*******************************************************/
   /*      "C" Language Integrated Production System      */
   /*                                                     */
   /*                  A Product Of The                   */
   /*             Software Technology Branch              */
   /*             NASA - Johnson Space Center             */
   /*                                                     */
   /*             CLIPS Version 5.10  07/17/91            */
   /*                                                     */
   /*                     MAIN MODULE                     */
   /*******************************************************/

/*************************************************************/
/* Purpose:                                                  */
/*                                                           */
/* Principal Programmer(s):                                  */
/*      Gary D. Riley                                        */
/*                                                           */
/* Contributing Programmer(s):                               */
/*                                                           */
/* Revision History:                                         */
/*                                                           */
/*************************************************************/

#include <stdio.h>
#include "setup.h"
#include "sysdep.h"
#include "commline.h"
#include "expressn.h"
#include <sybfront.h>
#include <sybdb.h>
#include <syberror.h>

#if ANSI_COMPILER
int main(int,char *[]);
VOID UserFunctions(void);
#else
int main();
VOID UserFunctions();
#endif

int err_handler();
int msg_handler();


/***************************************************************/
/* MAIN: Start execution of CLIPS.  This function must be      */
/*   redefined in order to embed CLIPS within another program. */
/*   Example of redefined main:                                */
/*     main()                                                  */
/*       {                                                     */
/*        init_clips();                                        */
/*            .                                                */
/*            .                                                */
/*            .                                                */
/*        process_data();                                      */
/*        RunCLIPS(-1);                                        */
/*        evaluate_data();                                     */
/*            .                                                */
/*            .                                                */
/*            .                                                */
/*        final_results();                                     */
/*       }                                                     */
/***************************************************************/
int main(argc,argv)
  int argc;
  char *argv[] ;
  {
   InitializeCLIPS();   
   dbinit();
   dberrhandle(err_handler);
   dbmsghandle(msg_handler);
   RerouteStdin(argc,argv);
   CommandLoop();
   dbexit();
   return(-1);
  }
  
/*************************************************************/
/* UserFunctions:  The function which informs CLIPS of any   */
/*   user defined functions.  In the default case, there are */
/*   no user defined functions.  To define functions, either */
/*   this function must be replaced by a function with the   */
/*   same name within this file, or this function can be     */
/*   deleted from this file and included in another file.    */
/*   User defined functions may be included in this file or  */
/*   other files.                                            */
/*   Example of redefined UserFunctions:                     */
/*     UserFunctions()                                       */
/*       {                                                   */
/*        DefineFunction("fun1",'i',fun1,"fun1");            */
/*        DefineFunction("other",'f',other,"other");         */
/*       }                                                   */
/*************************************************************/
VOID UserFunctions()
  {
	extern int my_dbopen();
	extern int my_dbclose();
	extern int my_dbcmd();
	extern int my_dbquery();
	extern int my_dbadd();
	DefineFunction("dbopen", 'b',PTIF my_dbopen, "my_dbopen");
	DefineFunction("dbclose", 'b',PTIF my_dbclose, "my_dbclose");
	DefineFunction("dbadd", 'b',PTIF my_dbadd, "my_dbadd");
	DefineFunction("dbcmd", 'i',PTIF my_dbcmd, "my_dbcmd");
	DefineFunction("dbquery", 'i',PTIF my_dbquery, "my_dbquery");
  }

