#include <sybfront.h>
#include <sybdb.h>
#include <syberror.h>
#include "clips.h"

/* dbdatlen() returns the number of bytes of data in a column,  */
/* however we are converting data to strings.  integers, 	*/
/* datetime's, etc., will need more space when converted to 	*/
/* strings, so we declare (as a dumb fix) a maximum size to 	*/
/* expect, so we must have at least this much space to be safe	*/
#define MIN_SIZE 25


VOID *AddSymbol();

static DBPROCESS *dbproc = NULL;


/* fact_tmp points to the start of the buffer used for assembling the	*/
/* string for asserting a returned row as a fact.			*/
static char *fact_tmp;

/* fact_size is the current size of the fact_tmp buffer.		*/
/* fact_len is the length of the string in the fact_tmp buffer		*/
/*  these values are maintained by the program as it does stuff.	*/
/* note that (fact_tmp + fact_len) points to the terminating null of	*/
/* the string being built.						*/
static int fact_size, fact_len;

int my_dbopen() {
/* opens a connection to the sybase data server. if a connection is 	*/
/* already open, it closes it. syntax is: (dbopen user passwd dbname)	*/
/* where user is the user name, passwd is the password, and dbname is	*/
/* the name of the database to use.  dbopen returns TRUE if it succeeds,*/
/* or FALSE if it fails. 						*/
  LOGINREC *login;

  if (ArgCountCheck("dbclose", EXACTLY, 3) == -1)
    return;
  if (dbproc != NULL)
    dbclose(dbproc);
  login = dblogin();
  DBSETLUSER(login, RtnLexeme(1));
  DBSETLPWD(login, RtnLexeme(2));
  dbproc = dbopen(login, NULL);
  dbloginfree(login);
  if (dbproc == NULL) /*in the case of a login failure*/
    return 0;
  if (dbuse(dbproc, RtnLexeme(3)) == FAIL)
    return 0;
  return dbproc != NULL;
}

int my_dbclose() {
/* closes a connection to the sybase data server, if one is open. 	*/
/* returns TRUE in any case.						*/
  dbclose(dbproc);
  dbproc = NULL;
  return 1;
}

my_dbadd() {
/* add to command buffer but not execute it yet */
/* syntax: (dbadd "blah" "bleh" "blah")			*/
/* returns TRUE for success, FALSE for failure	*/
/* IT IS UP TO THE USER TO SEPARATE COMMANDS WITH WHITESPACES */
  int i,j;

  if ((dbproc == NULL) || (DBDEAD(dbproc)))
    return -1; 
  j = RtnArgCount();
  for (i=1; i <= j; i++)
    if (dbcmd(dbproc, RtnLexeme(i))==FAIL)
      return;
  return 1;
}

my_dbcmd() {
/* execute an sql command, returns the number of rows returned, or -1	*/
/* in the case of an error. syntax is (dbcmd "query")			*/
/* where query is the command to be executed.  helps if a connection to */
/* a server has been opened.						*/
  int i = 0;
  RETCODE x;

  if (ArgCountCheck("dbcmd", EXACTLY, 1) == -1)
    return -1;
  if ((dbproc == NULL) || (DBDEAD(dbproc)))
    return -1; 
  dbcmd(dbproc, RtnLexeme(1));
  if (dbsqlexec(dbproc) == FAIL)
    return -1;
  while((x=dbresults(dbproc)) != NO_MORE_RESULTS) {
    if (x == FAIL) 
      return -1;
    while((x=dbnextrow(dbproc)) != NO_MORE_ROWS) {
      if (x == FAIL) 
	return -1;
      i++;
    }
  }
  return i;
}

my_dbquery() {
/* execute an sql command, returns the number of rows returned, or -1	*/
/* in the case of an error.  Asserts all rows returned as facts.	*/
/* syntax is (dbquery "query" fact_name)				*/
/* where query is the command to be executed and fact_name is the name	*/
/* for the fact, this assumes a deftemplate has been created for it.	*/ 
/* again, it is useful if a connection to a server has been opened.	*/
  int i = 0, j,l;
  RETCODE x;
  int ctype;
  char *temp;

  /* stupidity check */
  if (ArgCountCheck("dbquery", EXACTLY, 2) == -1)
    return -1;
  if ((dbproc == NULL) || (DBDEAD(dbproc)))
    return -1; 

  /* execute query */
  dbcmd(dbproc, RtnLexeme(1));
  if (dbsqlexec(dbproc) == FAIL)
    return -1;


  /* retrieve any rows returned and assert as facts	*/
  /*  start with a buffer big enough for most uses	*/
  if ((fact_tmp = (char *)malloc((fact_size = 32768))) == NULL) {
    fprintf(stderr, "unable to allocate memory for fact_tmp in db_query\n");
    dbexit();
    exit(1);
  }

  /* multiple results are possible if multiple commands were run */
  while((x=dbresults(dbproc)) != NO_MORE_RESULTS) {
    if (x == FAIL) 
      return -1;
    while((x=dbnextrow(dbproc)) != NO_MORE_ROWS) {
      if (x == FAIL) 
	return -1;
      /* For each row we build a string which we get CLIPS to assert 	*/
      /* as a fact.  this string is built one field at a time with the	*/
      /* column data we get from the Sybase.				*/

      fact_len = 0;
      add_to_fact_tmp(RtnLexeme(2));
      j = 0;
      while(j++ < dbnumcols(dbproc)) {
	add_to_fact_tmp("\n  ("); /* ) comment for vi */
	add_to_fact_tmp(dbcolname(dbproc, j));
	ctype = dbcoltype(dbproc, j);
	/* if it's going to be a quoted string, we must escape	*/
	/* double qoutes and backslashes with backslashes	*/
	if ((ctype == SYBCHAR) || (ctype == SYBTEXT) ||
		(ctype == SYBDATETIME) || (ctype == SYBDATETIME4)) {
	  add_to_fact_tmp(" \"");
	  l = dbdatlen(dbproc, j);
	  /* we need a temporary buffer for counting "'s and \'s	*/
	  if ((temp=(char *)malloc((l> MIN_SIZE ? l + 1 : MIN_SIZE))) == NULL) {
	    fprintf(stderr, "unable to allocate temp string buffer in my_dbquery\n");
	    dbexit();
	    exit();
	  }
	  dbconvert(dbproc, ctype, dbdata(dbproc, j), dbdatlen(dbproc, j),
			SYBCHAR, temp, -2);
	  add_qs_to_fact_tmp(temp);
	  free(temp);
	  add_to_fact_tmp("\"");
	} else {
	  add_to_fact_tmp(" ");
	  fact_tmp_alloc( MIN_SIZE );
	  dbconvert(dbproc, ctype, dbdata(dbproc, j), dbdatlen(dbproc, j),
			SYBCHAR, (fact_tmp + fact_len), -2);  /* comment for vi ( */
	  /* update the fact_len after dbconvert()'ing directly to fact_tmp*/
	  while(*(fact_tmp+fact_len)) fact_len++;
	}
	add_to_fact_tmp(")"); 
      }
      AssertString(fact_tmp); /* and hope there's a deftemplate for it */
      i++;
    }
  }
  free(fact_tmp);
  return i;
}

add_to_fact_tmp(s)
/* appends a string to the fact_tmp buffer, allocating more space if	*/
/* it is needed.  does not escape "'s or \'s				*/
char *s;
{
  int i;
  char *s1;

  i = strlen(s);
  fact_tmp_alloc(i);
  for (s1 = fact_tmp + fact_len ; *s1 = *s ; s1++, s++);
  fact_len = fact_len + i;
}

add_qs_to_fact_tmp(s)
/* appends a string to the fact_tmp buffer, allocating more space if	*/
/* it is needed.  will escape "'s and \'s with a \			*/
char *s;
{
  int i;
  char *s1;

  i = strlen(s);
  for (s1 = s; *s1; s1++)
    if ((*s1 == '"') || (*s1 == '\\'))
      i++;
  fact_tmp_alloc(i);
  for (s1 = fact_tmp + fact_len ; *s1 = *s ; s1++, s++)
    if ((*s == '"') || (*s == '\\')) {
      *s1++ = '\\';
      *s1 = *s;
    }
  fact_len = fact_len + i;
}

fact_tmp_alloc(i) {

/* checks if more memory is needed for the fact_tmp			*/
/* allocates more than is needed to save from reallocating later	*/

  if ((i + fact_len) >= fact_size) {
    if ((fact_tmp = (char *)realloc(fact_tmp, (fact_size = 2*(fact_size+i)))) == NULL) {
      fprintf(stderr, "could not allocate memory for fact_tmp in dbquery\n");
      dbexit();
      exit(1);
    }
  }
}



/* message and error handlers for DB-Library stuff */

int err_handler(dbproc, severity, dberr, oserr, dberrstr, oserrstr)
DBPROCESS       *dbproc;
int             severity;
int             dberr;
int             oserr;
char            *dberrstr;
char            *oserrstr;
{
if ((dberr != SYBEPWD) && ((dbproc == NULL) || (DBDEAD(dbproc))))
   return(INT_EXIT);
else 
   {
   printf("DB-Library error:\n\t%s\n", dberrstr);
   if (oserr != DBNOERR) printf("Operating-system error:\n\t%s\n", oserrstr);
   return(INT_CANCEL);
   }
}
int msg_handler(dbproc, msgno, msgstate, severity, msgtext, 
                srvname, procname, line)
DBPROCESS       *dbproc;
DBINT           msgno;
int             msgstate;
int             severity;
char            *msgtext;
char            *srvname;
char            *procname;
DBUSMALLINT     line;
{

if (severity == 0) return(0);

printf ("Msg %ld, Level %d, State %d\n", msgno, severity, msgstate);
  
if (strlen(srvname) > 0)  printf ("Server '%s', ", srvname);
if (strlen(procname) > 0) printf ("Procedure '%s', ", procname);
if (line > 0)             printf ("Line %d", line);
  
printf("\n\t%s\n", msgtext);
  
return(0);
}

  
