;;;************************************************************
;;; FUZZY DEFTEMPLATE ERROR CHECKING
;;;
;;; This file tests a number of common errors which can be
;;; made with fuzzy deftemplates. Among the errors tested are
;;;   (1) incomplete range (universe) spec
;;;   (2) incorrect order of range specifiers
;;;   (3) units spec not a simple word
;;;   (4) no terms specified
;;;   (5) invalid function used to define fuzzy set for a term
;;;   (6) S, Z, PI functions - parameters generate x values out of range
;;;                          - parameters out of range
;;;   (7) singleton specification - x values not in increasing order
;;;                               - x values out of range
;;;                               - y values out of range
;;;   (8) term name not a single word
;;;   (9) check S and Z functions can have equal parameters,
;;;       that PI function's first parameter can be 0.
;;;  (10) errors in fuzzy slot definitions
;;;  (11) repeating same fuzzy variable in deftemplate
;;;  (12) referencing term before it is defined.
;;;
;;; When the file is loaded, only those fuzzy deftemplates with
;;; the aok prefix should be displayed with a list-deftemplates
;;; command is executed. Any deftemplates shown with the prefix
;;; bad indicate that an error was not detected. The number of
;;; deftemplates listed should also be checked to make sure all
;;; of the aok deftemplates loaded properly.
;;;************************************************************

;;;********************************************
;;; These deftemplates check incomplete range (universe) spec
;;;********************************************

(deftemplate bad-fz01 ; missing value in universe of discourse
 10 DEGREES
 ((t1 (s 0 5))
 )
)
(deftemplate bad-fz02 ; only 2 numbers in universe of discourse
 10 30 40 DEGREES
 ((t1 (s 0 5))
 )
)
(deftemplate aok-fz01  ; no errors
 0 10 DEGREES
 ((t1 (s 0 5))
 )
)

;;;********************************************
;;; This deftemplate checks incorrect order of range specifiers
;;;********************************************

(deftemplate bad-fz03
 10 0 DEGREES
 ((t1 (s 0 5))
 )
)

;;;********************************************
;;; This deftemplate checks units spec not a simple word
;;;********************************************

(deftemplate bad-fz04
 0 10 DEGREES CENTIGRADE
 ((t1 (s 0 5))
 )
)

;;;********************************************
;;; This deftemplate checks no terms specified
;;;********************************************

(deftemplate bad-fz05
 0 10 DEGREES-C
 (
 )
)

;;;********************************************
;;; This deftemplate checks invalid function used to define
;;; fuzzy set for a term
;;;********************************************

(deftemplate bad-fz07
 0 10 DEGREES-C
 ((t1 (bad-term-fcn 0 5))
 )
)

;;;********************************************
;;; These deftemplates check S, Z, PI functions - parameter errors
;;;********************************************

(deftemplate bad-fz08
 0 10 DEGREES-C
 ((t1 (S 0 15))
 )
)
(deftemplate bad-fz09
 0 10 DEGREES-C
 ((t1 (Z -5 5))
 )
)
(deftemplate bad-fz10
 0 10 DEGREES-C
 ((t1 (PI 10 5))
 )
)
(deftemplate bad-fz11
 0 10 DEGREES-C
 ((t1 (PI 5 15))
 )
)
(deftemplate bad-fz12
 0 10 DEGREES-C
 ((t1 (PI -1 5))
 )
)
(deftemplate aok-fz03
 0 10 DEGREES-C
 ((t1 (S 0 8))
 )
)
(deftemplate aok-fz04
 0 10 DEGREES-C
 ((t1 (Z 0 5))
 )
)
(deftemplate aok-fz05
 0 10 DEGREES-C
 ((t1 (PI 2 5))
 )
)

;;;********************************************
;;; These deftemplates check singleton specification errors
;;;********************************************

(deftemplate bad-fz13  ; x values must be in increasing order
 0 10 DEGREES-C
 ((t1 (1 1) (0 .5) (5 0))
 )
)
(deftemplate bad-fz14  ; x value out of range
 0 10 DEGREES-C
 ((t1 (15 0) (20 1))
 )
)
(deftemplate bad-fz15  ; y value too large
 0 10 DEGREES-C
 ((t1 (0 0) (5 2) (10 1))
 )
)
(deftemplate aok-fz06
 0 10 DEGREES-C
 ((t1 (0 0) (5 1) (10 1))
 )
)
(deftemplate aok-fz06A
 0 10 DEGREES-C
 ((t1 (0 0) (0 .8) (10 1))
 )
)

;;;********************************************
;;; This deftemplate checks term name not a single word
;;;********************************************

(deftemplate bad-fz16
 0 10 DEGREES-C
 ((room temperature (s 0 5))
 )
)

;;;********************************************
;;; These deftemplates check that S and Z functions
;;; can have equal parameters, that PI function's
;;; first parameter can be 0.
;;;********************************************

(deftemplate ok-fz17
 0 10 DEGREES-C
 ((t1 (s 5 5))
  (t2 (z 5 5))
  (t3 (s 0 0))    ;;; equal at lower range
  (t4 (s 10 10))  ;;; equal at upper range
  (t5 (z 0 0))    ;;; equal at lower range
  (t6 (z 10 10))  ;;; equal at upper range
 )
)

(deftemplate ok-fz18
 0 10 DEGREES-C
 ((t1 (pi 5 5))
  (t2 (pi 0 0))
  (t3 (pi 0 10))
 )
)

;;;*****************************************
;;;  errors in fuzzy slot definitions
;;;*****************************************

(deftemplate temp
 0 10 DEGREES-C
 ((t1 (pi 5 5))
 )
)
(deftemplate badslot1
  (slot name)
  (slot fz (type FUZZY-VALUE))
)
(deftemplate badslot2
  (slot name)
  (slot fz (type FUZZY-VALUE abc))
)
(deftemplate badslot3
  (slot name)
  (slot fz (type fuzzy-value abc))
)
(deftemplate badslot4
  (slot name)
  (slot fz (FUZZY-VALUE abc))
)
(deftemplate badslot5
  (slot name)
  (slot fz (type INTEGER FUZZY-VALUE temp))
)
(deftemplate badslot6
  (slot name)
  (slot fz (type FUZZY-VALUE temp) (range 0 10))
)

;;;***********************************************
;;; Test error for repeating same fuzzy variable
;;;***********************************************

(deftemplate temperature
 0 100 DEGREE-C
 ((hot (S 70 90))
  (hot (S 60 85))
 )
)

;;;***********************************************
;;; Test error for referencing term before it is
;;; defined.
;;;***********************************************

(deftemplate temperature
 0 100 DEGREE-C
 ((ok NOT cold AND NOT hot)
  (hot (S 50 50))
  (warm (PI 0 40))
  (cold (Z 30 30))  
 )
)

