;;;***********************************************
;;; Test of add-fuzzy-modifier
;;;***********************************************

(watch facts)
(add-fuzzy-modifier mysqrt sqrt)
(deffunction sqr (?x)
  (* ?x ?x)
)
(add-fuzzy-modifier mysqr sqr)
(deftemplate ok
  0 100
  ((ok1 (1.0 0.0) (2.0 1.0))
  )
)

(assert (ok ok1))
(retract *)
(assert (ok mysqrt ok1))
(retract *)
(assert (ok mysqr ok1))
(retract *)

; The result of mysqrt mysqr should be as if they
; were not used.

(assert (ok mysqrt mysqr ok1))
(retract *)

;;;***********************************************
;;; Test of remove-fuzzy-modifier
;;;***********************************************

(remove-fuzzy-modifier mysqr)
(assert (ok mysqrt mysqr ok1))
(retract *)
(remove-fuzzy-modifier mysqrt)
(assert (ok mysqrt mysqr ok1))
(retract *)
(assert (ok more-or-less very ok1))
(retract *)

(deffunction offset (?x)
  (+ ?x 0.5)
)
(add-fuzzy-modifier myoffset offset)

; Notice how the fact ok is clipped because of myoffset

(assert (ok myoffset ok1))

;;;***********************************************
;;; Error checking in add-fuzzy-modifier
;;;***********************************************

(add-fuzzy-modifier myprint format)
(deffunction myprint (?x)
  (printout t "This is the value " ?x crlf)
)
(add-fuzzy-modifier toprint myprint)


;;;********************************************
;;; Test of hedges using generic deftemplates.
;;;********************************************

(deftemplate fz-temp
 0 100
 ((same (50 0.5))
  (warm (40 0)(50 1)(60 0))
  (hot (50 0)(60 1))
  (real-hot (S 60 60))
  (spike (70 0)(70 1)(70 0))
 )
)

(deftemplate s
 (slot name (type SYMBOL))
 (slot temp (type FUZZY-VALUE fz-temp))
)

(assert (s (name t1)(temp same)))
(assert (s (name t2)(temp very same)))
(facts)
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp same)))
(assert (s (name t2)(temp more-or-less same)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp same)))
(assert (s (name t2)(temp somewhat same)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp same)))
(assert (s (name t2)(temp norm same)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp same)))
(assert (s (name t2)(temp intensify same)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp same)))
(assert (s (name t2)(temp plus same)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp same)))
(assert (s (name t2)(temp slightly same)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp same)))
(assert (s (name t2)(temp extremely same)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp same)))
(assert (s (name t2)(temp above same)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp same)))
(assert (s (name t2)(temp below same)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

;;;*********************************************
;;; Let's apply the same hedges to warm.
;;;*********************************************

(retract *)
(assert (s (name t1)(temp warm)))
(assert (s (name t2)(temp very warm)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp warm)))
(assert (s (name t2)(temp more-or-less warm)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp warm)))
(assert (s (name t2)(temp somewhat warm)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp warm)))
(assert (s (name t2)(temp norm warm)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp warm)))
(assert (s (name t2)(temp intensify warm)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp warm)))
(assert (s (name t2)(temp plus warm)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp warm)))
(assert (s (name t2)(temp slightly warm)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp warm)))
(assert (s (name t2)(temp extremely warm)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp warm)))
(assert (s (name t2)(temp above warm)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp warm)))
(assert (s (name t2)(temp below warm)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

;;;*********************************************
;;; Let's apply the same hedges to hot.
;;;*********************************************

(retract *)
(assert (s (name t1)(temp hot)))
(assert (s (name t2)(temp very hot)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp hot)))
(assert (s (name t2)(temp more-or-less hot)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp hot)))
(assert (s (name t2)(temp somewhat hot)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp hot)))
(assert (s (name t2)(temp norm hot)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp hot)))
(assert (s (name t2)(temp intensify hot)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp hot)))
(assert (s (name t2)(temp plus hot)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp hot)))
(assert (s (name t2)(temp slightly hot)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp hot)))
(assert (s (name t2)(temp extremely hot)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp hot)))
(assert (s (name t2)(temp above hot)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp hot)))
(assert (s (name t2)(temp below hot)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

;;;*********************************************
;;; Let's apply the same hedges to real-hot.
;;;*********************************************

(retract *)
(assert (s (name t1)(temp real-hot)))
(assert (s (name t2)(temp very real-hot)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp real-hot)))
(assert (s (name t2)(temp more-or-less real-hot)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp real-hot)))
(assert (s (name t2)(temp somewhat real-hot)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp real-hot)))
(assert (s (name t2)(temp norm real-hot)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp real-hot)))
(assert (s (name t2)(temp intensify real-hot)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp real-hot)))
(assert (s (name t2)(temp plus real-hot)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp real-hot)))
(assert (s (name t2)(temp slightly real-hot)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp real-hot)))
(assert (s (name t2)(temp extremely real-hot)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp real-hot)))
(assert (s (name t2)(temp above real-hot)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp real-hot)))
(assert (s (name t2)(temp below real-hot)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

;;;*********************************************
;;; Let's apply the same hedges to spike.
;;;*********************************************

(retract *)
(assert (s (name t1)(temp spike)))
(assert (s (name t2)(temp very spike)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp spike)))
(assert (s (name t2)(temp more-or-less spike)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp spike)))
(assert (s (name t2)(temp somewhat spike)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp spike)))
(assert (s (name t2)(temp norm spike)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp spike)))
(assert (s (name t2)(temp intensify spike)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp spike)))
(assert (s (name t2)(temp plus spike)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp spike)))
(assert (s (name t2)(temp slightly spike)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp spike)))
(assert (s (name t2)(temp extremely spike)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp spike)))
(assert (s (name t2)(temp above spike)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

(retract *)
(assert (s (name t1)(temp spike)))
(assert (s (name t2)(temp below spike)))
(defrule plot-em
  (s (name t1)(temp ?t1))
  (s (name t2)(temp ?t2))
=>
  (plot-fuzzy-value t "+." nil nil ?t1 ?t2)
)
(run)

















