

;;;***************************************************
;;; Does PI, S & Z produce vertical lines??
;;;***************************************************

(watch facts)
(deftemplate temperature
 0 100 DEGREE-C
 ((hot (S 50 50))
  (warm (PI 0 40))
  (cold (Z 30 30))
  (ok NOT cold AND NOT hot)
  (not-ok NOT cold OR NOT hot)
 )
)

(assert (temperature ok))
(retract *)

(assert (temperature not-ok))
(retract *)

(assert (temperature NOT ok))
(retract *)

(assert (temperature NOT not-ok))
(retract *)

;;;***********************************************
;;; Check that "very" for a fuzzy set with vertical
;;; line doesn't expand to more than 2 points.
;;;***********************************************

(assert (temperature very hot))
(retract *)

(assert (temperature very cold))
(retract *)

(assert (temperature very warm))
(retract *)


;;;************************************************
;;; Check that unnecessary points are not returned
;;; for vertical lines.
;;;************************************************

(deftemplate points
 0 100
 ((p1 (1.0 0.0) (1.0 0.2) (1.0 0.3))           ;;; 3 points increasing
  (p2 (1.0 0.0) (1.0 0.2) (1.0 0.3) (1.0 0.4)) ;;; 4 points increasing
  (p3 (1.0 0.3) (1.0 0.2) (1.0 0.1))           ;;; 3 points decreasing
  (p4 (1.0 0.4) (1.0 0.3) (1.0 0.2) (1.0 0.0)) ;;; 4 points decreasing
  (p5 (1.0 0.0) (1.0 0.8) (1.0 0.5) (1.0 0.3)) ;;; up, down, down
  (p6 (1.0 0.0) (1.0 0.8) (1.0 0.4) (1.0 0.5)) ;;; up, down, up
  (p7 (1.0 1.0) (1.0 0.2) (1.0 0.4) (1.0 0.6)) ;;; down, up, up
  (p8 (1.0 1.0) (1.0 0.2) (1.0 0.6) (1.0 0.4)) ;;; down, up, down
 )
)

(assert (points p1))  ;; should give 2 points increasing
(retract *)
(assert (points p2))  ;; should give 2 points increasing
(retract *)
(assert (points p3))  ;; should be 2 points decreasing
(retract *)
(assert (points p4))  ;; should be 2 points decreasing
(retract *)
(assert (points p5))  ;; should be 2 points up, 1 point down
(retract *)
(assert (points p6))  ;; should be 2 points up, 1 point down
(retract *)
(assert (points p7))  ;; should be 2 points down, 1 point up
(retract *)
(assert (points p8))  ;; should be 2 points down, 1 point up
(retract *)


;;;***********************************************
;;; Test for spike at beginning and end of
;;; universe of discourse.
;;;***********************************************

(deftemplate spikes
 0 100
 ((s1 (0.0 0.0) (0.0 1.0) (0.0 0.0))
  (s2 (100.0 0.0) (100.0 1.0) (100.0 0.0))
 )
)
(assert (spikes s1))
(retract *)
(assert (spikes s2))
(retract *)

;;;*************************************
;;; A complex one.
;;;*************************************

(assert (spikes (0.0 0.0) (30.0 0.0) (30.0 1.0) (30.0 0.0)
                (40.0 0.0) (40.0 1.0) (40.0 0.0)
                (50.0 0.0) (50.0 1.0) (50.0 0.5) (60.0 0.5)
                (70.0 0.0) (100.0 0.0)))

(defrule defuzzy
  ?f <- (spikes ?)
=>
  (bind ?t (moment-defuzzify ?f))
  (printout t "Moment defuzzy of spikes is: " ?t crlf)
  (bind ?t (maximum-defuzzify ?f))
  (printout t "Max. defuzzy of spikes is: " ?t crlf)
)
(run)
(retract *)

