;;; Companion to modlmisc.bat in standard CLIPS tests
(clear) ;; import/export coordination
(defmodule A)
(deftemplate A::foo
 0 100 DEGREES-C
 ((low (0 1) (10 0))
 )
)
(defmodule B (import A ?ALL))
(defrule B::rule1 (foo low) =>)
(clear)
(defmodule A (export ?ALL))
(deftemplate A::foo
 0 100 DEGREES-C
 ((low (0 1) (10 0))
 )
)
(defmodule B (import A ?ALL))
(defrule B::rule1 (foo low) =>)
(clear)
(defmodule A (export deftemplate foo))
(deftemplate A::foo
 0 100 DEGREES-C
 ((low (0 1) (10 0))
 )
)
(defmodule B (import A ?ALL))
(defrule B::rule1 (foo low) =>)
(clear)
(defmodule A (export deftemplate bar))
(deftemplate A::foo
 0 100 DEGREES-C
 ((low (0 1) (10 0))
 )
)
(defmodule B (import A ?ALL))
(defrule B::rule1 (foo low) =>)
(clear) ;; one level of importation
(defmodule A (export ?ALL))
(deftemplate A::foo
 0 100 DEGREES-C
 ((low (0 1) (10 0))
 )
)
(deftemplate A::bar (slot x))
(defmodule B)
(defrule B::rule1 (foo low) =>)
(defrule B::rule2 (bar (x 3)) =>)
(defmodule C (import A ?ALL))
(defrule C::rule1 (foo low) =>)
(defrule C::rule2 (bar (x 3)) =>)
(defmodule D (import A deftemplate ?ALL))
(defrule D::rule1 (foo low) =>)
(defrule D::rule2 (bar (x 3)) =>)
(defmodule E (import A deftemplate foo bar))
(defrule E::rule1 (foo low) =>)
(defrule E::rule2 (bar (x 3)) =>)
(defmodule F (import A deftemplate bar))
(defrule F::rule1 (foo low) =>)
(defrule F::rule2 (bar (x 3)) =>)
(defmodule G (import A deftemplate foo))
(defrule G::rule1 (foo low) =>)
(defrule G::rule2 (bar (x 3)) =>)
(clear) ;; two levels of importation
(defmodule A (export ?ALL))
(deftemplate A::foo
 0 100 DEGREES-C
 ((low (0 1) (10 0))
 )
)
(deftemplate A::bar (slot x))
(defmodule B1 (export ?ALL))
(defmodule B2 (import B1 ?ALL))
(defrule B2::rule1 (foo low) =>)
(defrule B2::rule2 (bar (x 3)) =>)
(defmodule C1 (import A ?ALL) (export ?ALL))
(defmodule C2 (import C1 deftemplate ?ALL))
(defrule C2::rule1 (foo low) =>)
(defrule C2::rule2 (bar (x 3)) =>)
(defmodule D1 (import A deftemplate ?ALL) (export ?ALL))
(defmodule D2 (import D1 deftemplate ?NONE))
(defrule D2::rule1 (foo low) =>)
(defrule D2::rule2 (bar (x 3)) =>)
(defmodule E1 (import A deftemplate foo bar) (export ?ALL))
(defmodule E2 (import E1 deftemplate foo bar))
(defrule E2::rule1 (foo low) =>)
(defrule E2::rule2 (bar (x 3)) =>)
(defmodule F1 (import A deftemplate bar) (export ?ALL))
(defmodule F2 (import F1 deftemplate foo))
(defrule F2::rule1 (foo low) =>)
(defrule F2::rule2 (bar (x 3)) =>)
(defmodule G1 (import A deftemplate foo) (export ?ALL))
(defmodule G2 (import G1 deftemplate foo))
(defrule G2::rule1 (foo low) =>)
(defrule G2::rule2 (bar (x 3)) =>)
(clear) ;; Use of imported deftemplates on the LHS
(defmodule A (export ?ALL))
(deftemplate A::foo
 0 100 DEGREES-C
 ((low (0 1) (10 0))
 )
)
(defmodule B (import A ?ALL))
(deftemplate B::bar (slot y))
(defmodule C (import A ?ALL))
(deftemplate C::yak (slot z))
(defrule C::bad (bar (y 3)) =>)
(defrule C::good (foo low) (yak (z 4)) =>)
(defrule B::bad (yak (z 4)) =>)
(defrule B::good (foo low) (bar (y 3)) =>)
(defrule A::bad1 (yak (z 4)) =>)
(defrule A::bad2 (bar (y 3)) =>)
(defrule A::good (foo low) =>)
