;;; Companion to fctpcstr test used to test fuzzy patterns in rules

;;;***************************************************
;;; Testing some exotic linguistic expressions.
;;; All those is this group should be error free.
;;;***************************************************

(deftemplate fz
 0 100
  ((cold (10 1) (40 0))
   (hot (60 0) (90 1))
   (warm (30 0) (50 1) (70 0))
  )
)
(deftemplate system
  (slot name)
  (slot fz-slot (type FUZZY-VALUE fz))
)

;;; All of fz-noerror-nn? should produce NO ERROR

(defrule fz-noerror-5
  (system (name a) (fz-slot warm))
=>
)
(defrule fz-noerror-6
  (system (name a) (fz-slot cold AND warm))
=>
)
(defrule fz-noerror-7  ; more than one NOT allowed
  (fz NOT NOT cold)
  =>
)
(defrule fz-noerror-8  ; more than one NOT allowed
  (fz NOT hot OR NOT cold)
  =>
)
(defrule fz-noerror-9  ; NOT is in correct position
  (fz very NOT hot)  ; this is OK
  =>
)
(defrule fz-noerror-10a  
  (fz NOT cold OR hot)
  =>
)
(defrule fz-noerror-10b  ; should be different than 10a
  (fz NOT [ cold OR hot ] )
  =>
)
(defrule fz-noerror-10c  
  (fz NOT cold AND hot)
  =>
)
(defrule fz-noerror-10d  ; should be different than 10c  
  (fz NOT [ cold AND hot ] )
  =>
)
(defrule fz-noerror-10e    
  (fz cold AND hot OR warm)
  =>
)
(defrule fz-noerror-10f  ; should be different than 10e    
  (fz [ cold AND hot ] OR warm)
  =>
)
(defrule fz-noerror-10g  ; multiple []'s    
  (fz [ [ [ hot ] ] ] )
  =>
)
(defrule fz-noerror-10h  ; multiple []'s    
  (fz NOT [ [ [ hot ] ] ] )
  =>
)
(defrule fz-noerror-10i      
  (fz very hot)
  =>
)
(defrule fz-noerror-10j    
  (fz NOT very hot)
  =>
)
(defrule fz-noerror-10k    
  (fz more-or-less cold)
  =>
)
(defrule fz-noerror-10l    
  (fz slightly hot)
  =>
)
(defrule fz-noerror-10m    
  (fz intensify cold)
  =>
)
(defrule fz-noerror-10n    
  (fz plus hot)
  =>
)
(defrule fz-noerror-10o    
  (fz NOT [ very hot ] )
  =>
)
(defrule fz-noerror-10p    
  (fz NOT [ very hot ] OR cold)
  =>
)
(defrule fz-noerror-10q    
  (fz [ hot AND cold ] OR NOT [ hot AND cold ] )
  =>
)
(defrule fz-noerror-10r    
  (fz [ NOT cold OR [ very hot ] ] )
  =>
)
(defrule fz-noerror-10s    
  (fz [ NOT cold OR [ very hot ] ] )
  =>
)
(defrule fz-noerror-10t    
  (fz slightly cold OR [ very warm AND hot ] )
  =>
)

;;;***********************************************
;;; All of fz-error-11? should produce an ERROR
;;;***********************************************

(defrule fz-error-11a    
  (fz NOT [ [ hot ] )  ; missing ']'
  =>
)
(defrule fz-error-11b    
  (fz slightly cold OR )  ; incomplete
  =>
)
(defrule fz-error-11c    
  (fz OR cold )  ; incomplete
  =>
)
(defrule fz-error-11d    
  (fz AND cold )  ; incomplete
  =>
)
(defrule fz-error-11e    
  (fz NOT AND hot )  ; incomplete
  =>
)
(defrule fz-error-11f    
  (fz [ NOT ] hot )  ; incomplete
  =>
)
(defrule fz-error-11g    
  (fz [ ] hot )  ; incomplete
  =>
)
(defrule fz-error-11h    
  (fz [ hot )  ; incomplete
  =>
)
(defrule fz-error-11i    
  (fz hot ] )  ; incomplete
  =>
)
(defrule fz-error-11j    
  (fz slightly )  ; incomplete
  =>
)
(defrule fz-error-11k    
  (fz hot very )  ; reversed
  =>
)
(defrule fz-error-11l    
  (fz hot [ OR ] cold)  ; misplaced '[]'
  =>
)
(defrule fz-error-11m    
  (fz hot cold)  ; incomplete
  =>
)
(defrule fz-error-11n    
  (fz immensely warm)  ; incomplete
  =>
)
(defrule fz-error-11o
 (fz [ ] )
=>
)
(defrule fz-error-11p
 (fz [ )
=>
)
(defrule fz-error-11q
 (fz ] )
=>
)

;;;*********************************************
;;; Errors in fuzzy slot patterns
;;;*********************************************

(defrule fz-error-12a
  (system (name a) (fz-slot []))
=>
)
(defrule fz-error-12b
  (system (name a) (fz-slot hot cold))
=>
)
(defrule fz-error-12c  ; Undefined term or modifier
  (fz quite cold)
  =>
)
(defrule fz-error-12d  ; Undefined term or modifier
  (fz very temperate)
  =>
)
(defrule fz-error-12e  ; missing [
  (fz NOT cold OR hot ])
  =>
)
(defrule fz-error-12f  ; missing term
  (fz cold OR very)
  =>
)
(defrule fz-error-12g  ; missing expression
  (fz NOT [ cold OR ])
  =>
)
(defrule fz-error-12h ; missing OR
  (fz hot cold)
  =>
)
(defrule fz-error-12i  ; missing OR
  (fz NOT [ cold hot ])
  =>
)
(defrule fz-error-12j  ; missing OR
  (fz cold very hot)
  =>
)
(defrule fz-error-12k  ; missing spaces around [ ]'s
  (fz NOT[ hot OR cold ])
  =>
)
(defrule fz-error-12l  ; missing spaces around [ ]'s
  (fz NOT [hot OR cold ])
  =>
)
(defrule fz-error-12m  ; missing spaces around [ ]'s
  (fz NOT [ hot OR cold])
  =>
)


