(clear)
(deftemplate temp1
  0 100 degrees-C
   (
    (low  (0 1)  (25 0))
    (med  (20 0) (50 1) (80 0))
    (high (75 0) (100 1))
   )
)
(deftemplate temp2
  0 100 degrees-C
   (
    (low  (0 1)  (25 0))
    (med  (20 0) (50 1) (80 0))
    (high (75 0) (100 1))
   )
)
(deftemplate temp3
  0 100 degrees-C
   (
    (low  (0 1)  (25 0))
    (med  (20 0) (50 1) (80 0))
    (high (75 0) (100 1))
   )
)
(deftemplate temp4
  0 100 degrees-C
   (
    (low  (0 1)  (25 0))
    (med  (20 0) (50 1) (80 0))
    (high (75 0) (100 1))
   )
)
(deftemplate system
  (slot name)
  (slot temp (type FUZZY-VALUE temp1))
)
(deftemplate foo 
  (field x) (multifield y)
)
(deffacts fz1
  (temp1 low)
)
(deffacts fz2
  (temp2 very high)
)
(deffacts fz3
  (temp3 NOT [ very low OR high ])
  (a 3 x)
  (foo (y a) (x 3))
  (temp4 low OR more-or-less high)
  (system (name sysA) (temp slightly low))
)
(list-deffacts)
(ppdeffacts fz1)
(ppdeffacts fz2)
(ppdeffacts fz3)
(reset)
(retract *)

(undeffacts fz1)
(list-deffacts)
(undeffacts fz2)
(undeffacts fz3)
(list-deffacts)

(defmodule FOO)

(deffacts fz1
  (temp1 low)
)
(deffacts fz2
  (temp2 very high)
)

(defmodule BAR)

(deftemplate foobar
  (field x) (multifield y)
)

(deffacts fz3
  (temp3 NOT [ very low OR high ])
  (a 3 x)
  (foobar (y a) (x 3))
  (temp4 low OR more-or-less high)
  (system name sysA temp slightly low)
)

(list-deffacts FOO)
(list-deffacts BAR)
(list-deffacts)
(get-deffacts-list FOO)
(get-deffacts-list BAR)

(focus MAIN)

(ppdeffacts fz1)
(ppdeffacts FOO::fz1)
(ppdeffacts FOO::fz2)
(ppdeffacts BAR::fz3)
(deffacts-module fz1)
(deffacts-module BAR::fz3)
(reset)
(retract *)

(undeffacts BAR::fz3)
(undeffacts FOO::fz1)
(undeffacts FOO::fz2)
(list-deffacts)

(deffacts fz1
  (temp1 low) CF 0.8
)
(deffacts fz2
  (temp2 very high) CF (+ 0.2 0.3)
)
(deffacts fz3
  (temp3 NOT [ very low OR high ]) CF 0.2
  (a 3 x) CF (* 0.5 0.5)
  (foo (y a) (x 3))
  (temp4 low OR more-or-less high) CF 0.3
  (system (name sysA) (temp slightly low))
)

(ppdeffacts fz1)
(ppdeffacts fz2)
(ppdeffacts fz3)
(reset)
(retract *)
