(deffunction compare-files (?base-file ?test-file ?output)
   (open ?base-file base)
   (open ?test-file test)
   (bind ?i 0)
   (bind ?difference FALSE)
   (bind ?base-line (readline base))
   (bind ?test-line (readline test))
   (while (and (neq ?base-line EOF) (neq ?test-line EOF)) do
      (bind ?i (+ ?i 1))
      (if (neq ?base-line ?test-line) then
         ;; remove 'CF 1.00' from the test line
         ;; if the only difference is a certainty factor of 1.00
         ;; then they are really the same - only happens if the 
         ;; CLIPS system has certainty factors included (a fuzzy
         ;; CLIPS extension)
         (bind ?test-line-original ?test-line)
         (bind ?CFfound (str-index " CF 1.00 " ?test-line))
         (if (integerp ?CFfound) 
           then
            (bind ?test-line 
              (str-cat (sub-string 1 (- ?CFfound 1) ?test-line)
                       (sub-string (+ ?CFfound 9) (str-length ?test-line) ?test-line)
              )
            )
         )
         ;; after removing any 'CF 1.00' and still different then
         ;; flag the files as different and report the lines that differ
         (if (neq ?base-line ?test-line) then
             (bind ?difference TRUE)
             (format ?output "   %3d: %s%n" ?i ?base-line)
             (format ?output "   %3d: %s%n" ?i ?test-line-original)
         )
      )
      (bind ?base-line (readline base))
      (bind ?test-line (readline test)))
   (if (or (neq ?base-line EOF) (neq ?test-line EOF)) then
      (bind ?difference TRUE)
      (printout ?output "   Files do not have the same # of lines" crlf))
   (if (not ?difference) then
      (format ?output "   No differences detected in %d lines.%n" ?i))
   (close base)
   (close test))
