; testing the set operation functions similarity, necessity, etc
; by implementing a FUZZY-CRISP rule

(deftemplate fuzzy1
  0 100
   (
    (t1 (20 0) (40 1) (60 0))
    (t2 (0 0)  (20 1) (40 0))
    (t3 (50 0) (60 1) (70 0))
    (t4 (10 0) (25 1) (30 .5) (40 .7) (50 .7) (60 1) (70 0))
    (t5 (20 0) (40 1) (50 .5) (70 .7) (80 0))
    (t6 (10 0) (25 1) (60 1)  (70 0))
   )
)

(deftemplate fuzzy2
  0 100
   (
    (t1 (20 0) (40 1) (60 0))
    (t2 (0 0)  (20 1) (40 0))
    (t3 (50 0) (60 1) (70 0))
    (t4 (10 0) (25 1) (30 .5) (40 .7) (50 .7) (60 1) (70 0))
    (t5 (20 0) (40 1) (50 .5) (70 .7) (80 0))
    (t6 (10 0) (25 1) (60 1)  (70 0))
   )
)

(deftemplate fuzzy3
  0 100
   (
    (t1 (20 0) (40 1) (60 0))
    (t2 (0 0)  (20 1) (40 0))
    (t3 (50 0) (55 1) (60 0))
    (t4 (10 0) (25 1) (30 .5) (40 .7) (50 .7) (60 1) (70 0))
    (t5 (20 0) (40 1) (50 .5) (70 .7) (80 0))
    (t6 (10 0) (25 1) (60 1)  (70 0))
   )
)

(deftemplate fuzzy4
  0 100
   (
    (t1 (20 0) (40 1) (60 0))
    (t2 (0 0)  (20 1) (40 0))
    (t3 (50 0) (55 1) (60 0))
    (t4 (10 0) (25 1) (30 .5) (40 .7) (50 .7) (60 1) (70 0))
    (t5 (20 0) (40 1) (50 .5) (70 .7) (80 0))
    (t6 (10 0) (25 1) (60 1)  (70 0))
   )
)

(deftemplate fuzzy5
  0 100
   (
    (t1 (20 0) (40 1) (60 0))
    (t2 (0 0)  (20 1) (40 0))
    (t3 (50 0) (55 1) (60 0))
    (t4 (10 0) (25 1) (30 .5) (40 .7) (50 .7) (60 1) (70 0))
    (t5 (20 0) (40 1) (50 .5) (70 .7) (80 0))
    (t6 (10 0) (25 1) (60 1)  (70 0))
   )
)

(deftemplate fuzzy6
  0 100
   (
    (t1 (20 0) (40 1) (60 0))
    (t2 (0 0)  (20 1) (40 0))
    (t3 (50 0) (55 1) (60 0))
    (t4 (10 0) (25 1) (30 .5) (40 .7) (50 .7) (60 1) (70 0))
    (t5 (20 0) (40 1) (50 .5) (70 .7) (80 0))
    (t6 (10 0) (25 1) (60 1)  (70 0))
   )
)

(deftemplate fuzzy7
  0 100
   (
    (t1 (20 0) (40 1) (60 0))
    (t2 (0 0)  (20 1) (40 0))
    (t3 (50 0) (55 1) (60 0))
    (t4 (10 0) (25 1) (30 .5) (40 .7) (50 .7) (60 1) (70 0))
    (t5 (20 0) (40 1) (50 .5) (70 .7) (80 0))
    (t6 (10 0) (25 1) (60 1)  (70 0))
   )
)


(deftemplate fuzzy8
  0 100
   (
    (t1 (20 0) (40 1) (60 0))
    (t2 (22 0) (42 1) (62 0))
   )
)

(deftemplate non-fuzzy
  (slot a)
  (slot b (type FUZZY-VALUE fuzzy1))
  (slot c (type FUZZY-VALUE fuzzy2))
)


(deffacts fuzzyfacts
   (fuzzy1 t1)
   (fuzzy2 t1)
   (fuzzy3 t1)
   (fuzzy4 t3)
   (fuzzy5 t5)
   (fuzzy6 t6)
   (fuzzy7 t1)
   (fuzzy8 t2)
   (non-fuzzy (a OK) (b t1) (c t2))
)

(defrule fuzzycrisprule1
   (fuzzy1 t1)
   =>
   (assert (c1))
)

(defrule fuzzycrisprule2
   (fuzzy2 t2)
   =>
   (assert (c2))
)


(defrule fuzzycrisprule3
   (fuzzy3 t3)
   =>
   (assert (c3))
)

(defrule fuzzycrisprule4
   (fuzzy4 t1)
   =>
   (assert (c4))
)

(defrule fuzzycrisprule5
   (fuzzy5 t4)
   =>
   (assert (c5))
)

(defrule fuzzycrisprule6
   (fuzzy6 t1)
   =>
   (assert (c6))
)

(defrule fuzzycrisprule7
   (fuzzy7 t6)
   =>
   (assert (c7))
)


(defrule fuzzycrisprule8
   (fuzzy8 t1)
   =>
   (assert (c8))
)

(defrule fuzzycrisprule9
   (non-fuzzy (a OK) (b t3) (c t1))
  =>
   (assert (c9))
)


;; Tests for the fuzzy 'spike' matching against patterns
;; Check the CF of a crisp fact and the shape of a fuzzy set
;; fuzzy fact being asserted

(clear)
(deftemplate temp
  0 100 C
  ( (low (10 1) (50 0))
    (ok  (20 0) (50 1) (80 0))
    (high (50 0) (90 1))
  )
)

(defrule test-spike1
   (temp low)
  =>
   (printout t "Rule fired ****" crlf)
   (assert (FACT CF should be 0.5))
)

(assert (temp (pi 0 30)))
(run)
(facts)
(retract *)
(undefrule test-spike1)
(defrule test-spike2
   (temp low)
  =>
   (printout t "Rule fired ****" crlf)
   (assert (FACT CF should be 1.0))
)

(assert (temp (pi 0 10)))
(run)
(facts)
(retract *)
(undefrule test-spike2)
(defrule test-spike3
   ?f <- (temp low)
  =>
   (printout t "Rule fired ****" crlf)
   (retract ?f)
   (bind ?newf (assert (temp high)))
   (plot-fuzzy-value t * nil nil ?newf)
)

(assert (temp (pi 0 40)))
(run) ; should plot high clipped at y=0.25
(facts)
(retract *)
(clear)










